/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.protocol.schema;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.teamapps.protocol.file.FileProvider;
import org.teamapps.protocol.schema.MessageModelCollection;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.PojoObjectDecoder;

public class MessageReader
implements AutoCloseable {
    private final DataInputStream dis;
    private final FileProvider fileProvider;
    private MessageModelCollection messageModelCollection;

    public MessageReader(InputStream inputStream, FileProvider fileProvider, MessageModelCollection messageModelCollection) {
        this.dis = new DataInputStream(new BufferedInputStream(inputStream));
        this.fileProvider = fileProvider;
        this.messageModelCollection = messageModelCollection;
    }

    public MessageObject readNextMessage() throws IOException {
        try {
            int length = this.dis.readInt();
            byte[] bytes = new byte[length];
            this.dis.readFully(bytes);
            String objectUuid = MessageObject.readMessageObjectUuid(bytes);
            PojoObjectDecoder<? extends MessageObject> messageDecoder = this.messageModelCollection.getMessageDecoder(objectUuid);
            return messageDecoder.decode(bytes, this.fileProvider);
        }
        catch (EOFException ignore) {
            return null;
        }
    }

    @Override
    public void close() throws Exception {
        this.dis.close();
    }
}

