/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.protocol.schema;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.protocol.message.MessageUtils;
import org.teamapps.protocol.schema.AbstractPropertyDefinition;
import org.teamapps.protocol.schema.MessageModel;
import org.teamapps.protocol.schema.PropertyContentType;
import org.teamapps.protocol.schema.PropertyDefinition;
import org.teamapps.protocol.schema.PropertyType;

public class ObjectPropertyDefinition
extends AbstractPropertyDefinition
implements MessageModel {
    private final String objectUuid;
    private final short modelVersion;
    private final List<PropertyDefinition> definitions = new ArrayList<PropertyDefinition>();
    private final Map<Integer, PropertyDefinition> definitionByKey = new HashMap<Integer, PropertyDefinition>();
    private final Map<String, PropertyDefinition> definitionByName = new HashMap<String, PropertyDefinition>();

    public ObjectPropertyDefinition(String objectUuid, String name, int modelVersion) {
        this(objectUuid, name, null, null, modelVersion);
    }

    public ObjectPropertyDefinition(String objectUuid, String name, String title, String specificType, int modelVersion) {
        super(null, name, 0, PropertyType.OBJECT, PropertyContentType.GENERIC, specificType, title);
        this.objectUuid = objectUuid;
        this.modelVersion = (short)modelVersion;
    }

    public ObjectPropertyDefinition(byte[] bytes) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public ObjectPropertyDefinition(DataInputStream dis) throws IOException {
        this(dis, new HashMap<String, MessageModel>());
    }

    public ObjectPropertyDefinition(DataInputStream dis, Map<String, MessageModel> writeCache) throws IOException {
        this(MessageUtils.readString(dis), MessageUtils.readString(dis), MessageUtils.readString(dis), MessageUtils.readString(dis), dis.readShort());
        int size = dis.readInt();
        for (int i = 0; i < size; ++i) {
            AbstractPropertyDefinition propertyDefinition = new AbstractPropertyDefinition(this, dis, writeCache);
            this.addProperty(propertyDefinition);
        }
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, new HashMap<String, MessageModel>());
    }

    @Override
    public void write(DataOutputStream dos, Map<String, MessageModel> writeCache) throws IOException {
        MessageUtils.writeString(dos, this.objectUuid);
        MessageUtils.writeString(dos, this.getName());
        MessageUtils.writeString(dos, this.getTitle());
        MessageUtils.writeString(dos, this.getSpecificType());
        dos.writeShort(this.modelVersion);
        dos.writeInt(this.definitions.size());
        for (PropertyDefinition propertyDefinition : this.definitions) {
            propertyDefinition.write(dos, writeCache);
        }
    }

    @Override
    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos);
        dos.close();
        return bos.toByteArray();
    }

    public String getObjectUuid() {
        return this.objectUuid;
    }

    public void addBooleanProperty(String name, int key) {
        this.addProperty(name, key, PropertyType.BOOLEAN);
    }

    public void addByteProperty(String name, int key) {
        this.addProperty(name, key, PropertyType.BYTE);
    }

    public void addStringProperty(String name, int key) {
        this.addProperty(name, key, PropertyType.STRING);
    }

    public void addIntProperty(String name, int key) {
        this.addProperty(name, key, PropertyType.INT);
    }

    public void addLongProperty(String name, int key) {
        this.addProperty(name, key, PropertyType.LONG);
    }

    public void addFloatProperty(String name, int key) {
        this.addProperty(name, key, PropertyType.FLOAT);
    }

    public void addDoubleProperty(String name, int key) {
        this.addProperty(name, key, PropertyType.DOUBLE);
    }

    public void addFileProperty(String name, int key) {
        this.addProperty(name, key, PropertyType.FILE);
    }

    public void addByteArrayProperty(String name, int key) {
        this.addProperty(name, key, PropertyType.BYTE_ARRAY);
    }

    public void addIntArrayProperty(String name, int key) {
        this.addProperty(name, key, PropertyType.INT_ARRAY);
    }

    public void addLongArrayProperty(String name, int key) {
        this.addProperty(name, key, PropertyType.LONG_ARRAY);
    }

    public void addFloatArrayProperty(String name, int key) {
        this.addProperty(name, key, PropertyType.FLOAT_ARRAY);
    }

    public void addDoubleArrayProperty(String name, int key) {
        this.addProperty(name, key, PropertyType.DOUBLE_ARRAY);
    }

    public void addStringArrayProperty(String name, int key) {
        this.addProperty(name, key, PropertyType.STRING_ARRAY);
    }

    public void addProperty(String name, int key, PropertyType type) {
        this.addProperty(name, key, type, PropertyContentType.GENERIC, null, null);
    }

    public void addProperty(String name, int key, PropertyType type, PropertyContentType contentType, String specificType, String title) {
        AbstractPropertyDefinition propertyDefinition = new AbstractPropertyDefinition(this, name, key, type, contentType, specificType, title);
        this.addProperty(propertyDefinition);
    }

    public void addSingleReference(String name, int key, ObjectPropertyDefinition referencedObject) {
        this.addSingleReference(name, key, null, null, referencedObject);
    }

    public void addSingleReference(String name, int key, String specificType, String title, ObjectPropertyDefinition referencedObject) {
        AbstractPropertyDefinition referencePropertyDefinition = new AbstractPropertyDefinition(this, name, key, specificType, title, referencedObject, false);
        this.addProperty(referencePropertyDefinition);
    }

    public void addMultiReference(String name, int key, ObjectPropertyDefinition referencedObject) {
        this.addMultiReference(name, key, null, null, referencedObject);
    }

    public void addMultiReference(String name, int key, String specificType, String title, ObjectPropertyDefinition referencedObject) {
        AbstractPropertyDefinition referencePropertyDefinition = new AbstractPropertyDefinition(this, name, key, specificType, title, referencedObject, true);
        this.addProperty(referencePropertyDefinition);
    }

    public void addProperty(PropertyDefinition field) {
        if (this.definitionByName.containsKey(field.getName()) || this.definitionByKey.containsKey(field.getKey())) {
            throw new RuntimeException("Object property already contains field with this name or key:" + field.getName() + "->" + field.getKey());
        }
        this.definitions.add(field);
        this.definitionByKey.put(field.getKey(), field);
        this.definitionByName.put(field.getName(), field);
    }

    @Override
    public ObjectPropertyDefinition getParent() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return this.getName() + "-" + this.objectUuid;
    }

    @Override
    public String getModelUuid() {
        return this.objectUuid;
    }

    @Override
    public short getModelVersion() {
        return this.modelVersion;
    }

    @Override
    public ObjectPropertyDefinition getObjectPropertyDefinition() {
        return this;
    }

    @Override
    public List<PropertyDefinition> getPropertyDefinitions() {
        return this.definitions;
    }

    @Override
    public PropertyDefinition getPropertyDefinitionByKey(int key) {
        return this.definitionByKey.get(key);
    }

    @Override
    public PropertyDefinition getPropertyDefinitionByName(String name) {
        return this.definitionByName.get(name);
    }
}

