/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.protocol.service;

import org.teamapps.protocol.message.Message;
import org.teamapps.protocol.message.MessageDecoder;
import org.teamapps.protocol.service.ServiceRegistry;
import reactor.core.publisher.Mono;

public abstract class AbstractClusterServiceClient {
    private final ServiceRegistry serviceRegistry;
    private final String serviceName;

    public AbstractClusterServiceClient(ServiceRegistry serviceRegistry, String serviceName) {
        this.serviceRegistry = serviceRegistry;
        this.serviceName = serviceName;
    }

    protected <REQUEST extends Message, RESPONSE extends Message> Mono<RESPONSE> createClusterTask(String method, REQUEST request, MessageDecoder<RESPONSE> responseDecoder) {
        return this.serviceRegistry.createServiceTask(this.serviceName, method, request, responseDecoder);
    }

    public boolean isAvailable() {
        return this.serviceRegistry.isServiceAvailable(this.serviceName);
    }
}

