/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.protocol.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.teamapps.protocol.schema.MessageModel;
import org.teamapps.protocol.schema.MessageModelRegistry;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.ModelCollection;
import org.teamapps.protocol.schema.ModelRegistry;
import org.teamapps.protocol.schema.ObjectPropertyDefinition;
import org.teamapps.protocol.schema.PojoObjectDecoder;
import org.teamapps.protocol.schema.ProtocolServiceSchema;

public class MessageModelCollection
implements ModelCollection {
    private final String name;
    private final String namespace;
    private final int version;
    private final List<MessageModel> models = new ArrayList<MessageModel>();
    private final Map<String, MessageModel> modelByKey = new ConcurrentHashMap<String, MessageModel>();
    private Map<String, PojoObjectDecoder<? extends MessageObject>> decoderByUuid = new ConcurrentHashMap<String, PojoObjectDecoder<? extends MessageObject>>();
    private List<ProtocolServiceSchema> protocolServiceSchemas = new ArrayList<ProtocolServiceSchema>();

    public MessageModelCollection(String name, String namespace, int version) {
        this.name = name;
        this.namespace = namespace;
        this.version = version;
    }

    public ObjectPropertyDefinition createModel(String name, String uuid) {
        ObjectPropertyDefinition definition = new ObjectPropertyDefinition(uuid, name, this.version);
        this.addModel(definition);
        return definition;
    }

    public ObjectPropertyDefinition createModel(String name, String uuid, String title, String specificType) {
        ObjectPropertyDefinition definition = new ObjectPropertyDefinition(uuid, name, title, specificType, this.version);
        this.addModel(definition);
        return definition;
    }

    public ObjectPropertyDefinition createModel(String name, String uuid, int modelVersion, String title, String specificType) {
        ObjectPropertyDefinition definition = new ObjectPropertyDefinition(uuid, name, title, specificType, modelVersion);
        this.addModel(definition);
        return definition;
    }

    public void addModel(MessageModel model) {
        this.models.add(model);
        this.modelByKey.put(model.getObjectPropertyDefinition().getObjectUuid(), model);
    }

    public ProtocolServiceSchema createProtocolServiceSchema(String serviceName) {
        ProtocolServiceSchema serviceSchema = new ProtocolServiceSchema(serviceName);
        this.protocolServiceSchemas.add(serviceSchema);
        return serviceSchema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public short getVersion() {
        return (short)this.version;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public MessageModel getModel(String uuid) {
        return this.modelByKey.get(uuid);
    }

    @Override
    public List<MessageModel> getModels() {
        return this.models;
    }

    @Override
    public ModelRegistry createRegistry() {
        return new MessageModelRegistry(this);
    }

    @Override
    public List<ProtocolServiceSchema> getProtocolServiceSchemas() {
        return this.protocolServiceSchemas;
    }

    @Override
    public void addMessageDecoder(String uuid, PojoObjectDecoder<? extends MessageObject> decoder) {
        this.decoderByUuid.put(uuid, decoder);
    }

    @Override
    public PojoObjectDecoder<? extends MessageObject> getMessageDecoder(String uuid) {
        return this.decoderByUuid.get(uuid);
    }

    @Override
    public boolean containsDecoder(String uuid) {
        return this.decoderByUuid.containsKey(uuid);
    }

    @Override
    public byte[] toBytes() {
        return new byte[0];
    }
}

