/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.reporting.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.jvnet.jaxb2_commons.ppp.Child;

public class DocumentBuilder {
    public Map<String, String> createReplaceRowMap(String ... values) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < values.length; i += 2) {
            map.put(values[i], values[i + 1]);
        }
        return map;
    }

    public WordprocessingMLPackage getTemplate(String path) throws Docx4JException, FileNotFoundException {
        return WordprocessingMLPackage.load((InputStream)new FileInputStream(new File(path)));
    }

    public <T> T copyElement(T t) {
        return (T)XmlUtils.deepCopy(t);
    }

    public <T> List<T> getAllElements(Object element, T toSearch) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (element instanceof JAXBElement) {
            element = ((JAXBElement)element).getValue();
        }
        if (element.getClass().equals(toSearch.getClass())) {
            result.add(element);
        } else if (element instanceof ContentAccessor) {
            List children = ((ContentAccessor)element).getContent();
            for (Object child : children) {
                result.addAll(this.getAllElements(child, toSearch));
            }
        }
        return result;
    }

    public void save(WordprocessingMLPackage template, String target) throws Docx4JException {
        File f = new File(target);
        template.save(f);
    }

    public void fillTable(List<Map<String, String>> textToAdd, WordprocessingMLPackage template, String ... keys) throws Docx4JException, JAXBException {
        this.fillTable(textToAdd, template, Arrays.asList(keys));
    }

    public void fillTable(List<Map<String, String>> textToAdd, WordprocessingMLPackage template, List<String> keys) throws Docx4JException, JAXBException {
        List<Tbl> tables = this.getAllElements(template.getMainDocumentPart(), new Tbl());
        Tbl matchingTable = null;
        for (Tbl table : tables) {
            boolean hit = true;
            for (String key : keys) {
                if (this.getParagraphWithText(table, key) != null) continue;
                hit = false;
                break;
            }
            if (!hit) continue;
            matchingTable = table;
            break;
        }
        HashSet<Tr> removeSet = new HashSet<Tr>();
        if (matchingTable != null) {
            for (Map<String, String> replaceMap : textToAdd) {
                Tr templateRow = this.findRowInTable(matchingTable, replaceMap.keySet());
                removeSet.add(templateRow);
                Tr row = this.copyElement(templateRow);
                for (Map.Entry<String, String> entry : replaceMap.entrySet()) {
                    this.replaceParagraph(entry.getKey(), entry.getValue(), row);
                }
                matchingTable.getContent().add(row);
            }
            for (Tr tr : removeSet) {
                matchingTable.getContent().remove(tr);
            }
        }
    }

    public void replaceParagraph(String key, String value, Object element) {
        P paragraph = this.getParagraphWithText(element, key);
        if (paragraph == null) {
            return;
        }
        List<Text> texts = this.getAllElements(paragraph, new Text());
        texts.get(0).setValue(value);
        if (texts.size() == 1) {
            return;
        }
        for (int i = 1; i < texts.size(); ++i) {
            this.removeChild(paragraph, texts.get(i));
        }
    }

    public void replaceTextRun(String key, String value, Object element) {
        P paragraph = this.getParagraphWithText(element, key);
        if (paragraph == null) {
            return;
        }
        List<Text> texts = this.getAllElements(paragraph, new Text());
        for (Text text : texts) {
            if (!text.getValue().contains(key)) continue;
            String replacedTextValue = text.getValue().replace(key, value);
            text.setValue(replacedTextValue);
        }
    }

    public void removeChild(Object parent, Object child) {
        if (parent instanceof ContentAccessor) {
            ContentAccessor contentAccessor = (ContentAccessor)parent;
            List children = contentAccessor.getContent();
            HashSet<Object> contentSet = new HashSet<Object>(children);
            this.removeChild(contentAccessor, contentSet, child);
        }
    }

    public void removeChild(ContentAccessor contentAccessor, Set<Object> contentSet, Object child) {
        Child contentChild;
        Object parent;
        if (contentSet.contains(child)) {
            contentAccessor.getContent().remove(child);
        } else if (child instanceof Child && (parent = (contentChild = (Child)child).getParent()) != null) {
            this.removeChild(contentAccessor, contentSet, parent);
        }
    }

    public Tr findRowInTable(Tbl table, Collection<String> keys) {
        return this.findRowInTable(table, keys.toArray(new String[0]));
    }

    public Tr findRowInTable(Tbl table, String ... keys) {
        List<Tr> rows = this.getAllElements(table, new Tr());
        for (Tr row : rows) {
            boolean hit = true;
            for (String key : keys) {
                if (this.getParagraphWithText(row, key) != null) continue;
                hit = false;
                break;
            }
            if (!hit) continue;
            return row;
        }
        return null;
    }

    public P getParagraphWithText(Object element, String key) {
        List<P> paragraphs = this.getAllElements(element, new P());
        for (P paragraph : paragraphs) {
            List<Text> texts = this.getAllElements(paragraph, new Text());
            StringBuilder sb = new StringBuilder();
            texts.forEach(text -> sb.append(text.getValue()));
            if (sb.length() <= 0 || !sb.toString().contains(key)) continue;
            return paragraph;
        }
        return null;
    }
}

