/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.reporting.builder;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.teamapps.reporting.builder.DocumentBuilder;
import org.teamapps.reporting.builder.DocumentTemplateLoader;
import org.teamapps.reporting.builder.TableBuilder;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.reporting.convert.DocumentFormat;
import org.teamapps.reporting.convert.UnsupportedFormatException;

public class ReportBuilder {
    private final DocumentFormat inputFormat;
    private final InputStream inputStream;
    private File outputFile;
    private Map<String, String> replacementMap = new HashMap<String, String>();
    private List<TableBuilder> tableBuilders = new ArrayList<TableBuilder>();

    public static ReportBuilder create(DocumentFormat inputFormat, File templateFile) throws FileNotFoundException {
        return ReportBuilder.create(inputFormat, new BufferedInputStream(new FileInputStream(templateFile)));
    }

    public static ReportBuilder create(DocumentFormat inputFormat, InputStream inputStream) {
        return new ReportBuilder(inputFormat, inputStream);
    }

    public ReportBuilder(DocumentFormat inputFormat, InputStream inputStream) {
        this.inputFormat = inputFormat;
        this.inputStream = inputStream;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public ReportBuilder addReplacement(String key, String value) {
        this.replacementMap.put(key, value);
        return this;
    }

    public TableBuilder createTableBuilder(String ... keys) {
        return this.createTableBuilder(Arrays.asList(keys));
    }

    public TableBuilder createTableBuilder(List<String> keys) {
        TableBuilder tableBuilder = new TableBuilder(keys);
        this.tableBuilders.add(tableBuilder);
        return tableBuilder;
    }

    public File build() throws Exception {
        if (this.inputFormat != DocumentFormat.DOCX) {
            UnsupportedFormatException.throwException(this.inputFormat);
        }
        WordprocessingMLPackage template = DocumentTemplateLoader.getTemplate(this.inputStream);
        this.processDocument(template);
        File outputFile = this.createOutputFile(DocumentFormat.DOCX);
        template.save(outputFile);
        return outputFile;
    }

    public File build(DocumentFormat outputFormat, DocumentConverter converter) throws Exception {
        InputStream documentInputStream = this.inputStream;
        if (this.inputFormat != DocumentFormat.DOCX) {
            File tempFile = File.createTempFile("temp", "." + DocumentFormat.DOCX.getFormat());
            converter.convertDocument(this.inputStream, this.inputFormat, tempFile, DocumentFormat.DOCX);
            documentInputStream = new BufferedInputStream(new FileInputStream(tempFile));
        }
        WordprocessingMLPackage template = DocumentTemplateLoader.getTemplate(documentInputStream);
        this.processDocument(template);
        File outputFile = this.createOutputFile(outputFormat);
        if (outputFormat == DocumentFormat.DOCX) {
            template.save(outputFile);
            return outputFile;
        }
        converter.convertDocument(template, outputFile, outputFormat);
        return outputFile;
    }

    private void processDocument(WordprocessingMLPackage template) throws Docx4JException, JAXBException {
        MainDocumentPart mainDocumentPart = template.getMainDocumentPart();
        DocumentBuilder documentBuilder = new DocumentBuilder();
        for (Map.Entry<String, String> entry : this.replacementMap.entrySet()) {
            documentBuilder.replaceTextRunWithFootersAndHeaders(entry.getKey(), entry.getValue(), mainDocumentPart, template);
        }
        for (TableBuilder tableBuilder : this.tableBuilders) {
            documentBuilder.fillTable(tableBuilder.createReplacementMap(), template, tableBuilder.getKeys());
        }
    }

    private File createOutputFile(DocumentFormat format) throws IOException {
        if (this.outputFile != null) {
            return this.outputFile;
        }
        return File.createTempFile("temp", "." + format.getFormat());
    }
}

