/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.reporting.parse;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBElement;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.teamapps.reporting.builder.DocumentTemplateLoader;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.reporting.convert.DocumentFormat;
import org.teamapps.reporting.convert.UnsupportedFormatException;

public class DocumentParser {
    private final DocumentFormat inputFormat;
    private final InputStream inputStream;

    public static DocumentParser create(DocumentFormat inputFormat, File templateFile) throws FileNotFoundException {
        return DocumentParser.create(inputFormat, new BufferedInputStream(new FileInputStream(templateFile)));
    }

    public static DocumentParser create(DocumentFormat inputFormat, InputStream inputStream) {
        return new DocumentParser(inputFormat, inputStream);
    }

    protected DocumentParser(DocumentFormat inputFormat, InputStream inputStream) {
        this.inputFormat = inputFormat;
        this.inputStream = inputStream;
    }

    public List<List<String>> parseTableData(int tableIndex) throws Exception {
        if (this.inputFormat != DocumentFormat.DOCX) {
            UnsupportedFormatException.throwException(this.inputFormat);
        }
        return this.parseTableData(tableIndex, this.inputStream);
    }

    public List<List<String>> parseTableData(int tableIndex, DocumentConverter documentConverter) throws Exception {
        InputStream documentInputStream = this.inputStream;
        if (this.inputFormat != DocumentFormat.DOCX) {
            File tempFile = File.createTempFile("temp", "." + DocumentFormat.DOCX.getFormat());
            documentConverter.convertDocument(this.inputStream, this.inputFormat, tempFile, DocumentFormat.DOCX);
            documentInputStream = new BufferedInputStream(new FileInputStream(tempFile));
        }
        return this.parseTableData(tableIndex, documentInputStream);
    }

    private List<List<String>> parseTableData(int tableIndex, InputStream documentInputStream) throws Docx4JException {
        WordprocessingMLPackage template = DocumentTemplateLoader.getTemplate(documentInputStream);
        List<Tbl> tables = DocumentParser.getAllElements(template.getMainDocumentPart(), new Tbl());
        if (tables.size() <= tableIndex) {
            return null;
        }
        Tbl table = tables.get(tableIndex);
        ArrayList<List<String>> tableData = new ArrayList<List<String>>();
        for (Object element : table.getContent()) {
            if (!(element instanceof Tr)) continue;
            Tr row = (Tr)element;
            ArrayList<String> rowData = new ArrayList<String>();
            tableData.add(rowData);
            for (Object cell : row.getContent()) {
                List<Text> texts = DocumentParser.getAllElements(cell, new Text());
                String cellValue = texts.stream().map(Text::getValue).collect(Collectors.joining());
                rowData.add(cellValue);
            }
        }
        return tableData;
    }

    private static <T> List<T> getAllElements(Object element, T toSearch) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (element instanceof JAXBElement) {
            element = ((JAXBElement)element).getValue();
        }
        if (element.getClass().equals(toSearch.getClass())) {
            result.add(element);
        } else if (element instanceof ContentAccessor) {
            List children = ((ContentAccessor)element).getContent();
            for (Object child : children) {
                result.addAll(DocumentParser.getAllElements(child, toSearch));
            }
        }
        return result;
    }
}

