/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.reporting.style.run;

import java.math.BigInteger;
import org.docx4j.jaxb.Context;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.Color;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.R;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Text;
import org.docx4j.wml.U;
import org.docx4j.wml.UnderlineEnumeration;
import org.teamapps.reporting.style.run.StyledElement;

public class StyledText
implements StyledElement {
    private String text;
    private Boolean bold;
    private Boolean italic;
    private Boolean underline;
    private Boolean caps;
    private Integer size;
    private String font;
    private String color;

    public String getText() {
        return this.text;
    }

    public StyledText setText(String text) {
        this.text = text;
        return this;
    }

    public Boolean getBold() {
        return this.bold;
    }

    public StyledText setBold(Boolean bold) {
        this.bold = bold;
        return this;
    }

    public Boolean getItalic() {
        return this.italic;
    }

    public StyledText setItalic(Boolean italic) {
        this.italic = italic;
        return this;
    }

    public Boolean getUnderline() {
        return this.underline;
    }

    public StyledText setUnderline(Boolean underline) {
        this.underline = underline;
        return this;
    }

    public Boolean getCaps() {
        return this.caps;
    }

    public StyledText setCaps(Boolean caps) {
        this.caps = caps;
        return this;
    }

    public Integer getSize() {
        return this.size;
    }

    public StyledText setSize(Integer size) {
        this.size = size;
        return this;
    }

    public String getFont() {
        return this.font;
    }

    public StyledText setFont(String font) {
        this.font = font;
        return this;
    }

    public String getColor() {
        return this.color;
    }

    public StyledText setColor(String color) {
        this.color = color;
        return this;
    }

    @Override
    public R getRun() {
        ObjectFactory factory = Context.getWmlObjectFactory();
        Text text = factory.createText();
        text.setValue(this.text);
        R run = factory.createR();
        run.getContent().add(text);
        RPr runProperties = factory.createRPr();
        BooleanDefaultTrue defaultTrue = new BooleanDefaultTrue();
        if (this.bold != null && this.bold.booleanValue()) {
            runProperties.setB(defaultTrue);
        }
        if (this.italic != null && this.italic.booleanValue()) {
            runProperties.setI(defaultTrue);
        }
        if (this.caps != null && this.caps.booleanValue()) {
            runProperties.setCaps(defaultTrue);
        }
        if (this.size != null) {
            HpsMeasure size = factory.createHpsMeasure();
            size.setVal(BigInteger.valueOf(this.size.intValue()));
            runProperties.setSz(size);
        }
        if (this.underline != null && this.underline.booleanValue()) {
            U underline = factory.createU();
            underline.setVal(UnderlineEnumeration.SINGLE);
            runProperties.setU(underline);
        }
        if (this.color != null) {
            Color color = factory.createColor();
            color.setVal(this.color);
            runProperties.setColor(color);
        }
        if (this.font != null) {
            RFonts rFonts = factory.createRFonts();
            rFonts.setAscii(this.font);
            runProperties.setRFonts(rFonts);
        }
        run.setRPr(runProperties);
        return run;
    }
}

