/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.reporting.style.paragraph;

import java.util.ArrayList;
import java.util.List;
import org.docx4j.jaxb.Context;
import org.docx4j.model.PropertyResolver;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.teamapps.reporting.style.paragraph.ParagraphStyle;
import org.teamapps.reporting.style.run.StyledElement;

public class StyledParagraph {
    public final List<StyledElement> elements = new ArrayList<StyledElement>();
    private WordprocessingMLPackage wordPackage;
    private ParagraphStyle paragraphStyle;

    public void addElement(StyledElement element) {
        this.elements.add(element);
    }

    public void setStyle(ParagraphStyle paragraphStyle, WordprocessingMLPackage wordPackage) {
        this.wordPackage = wordPackage;
        this.paragraphStyle = paragraphStyle;
    }

    public P getParagraph() {
        ObjectFactory factory = Context.getWmlObjectFactory();
        P paragraph = factory.createP();
        this.setStyle(paragraph);
        this.elements.forEach(e -> paragraph.getContent().add(e.getRun()));
        return paragraph;
    }

    public void replaceContent(P paragraph) {
        paragraph.getContent().clear();
        this.setStyle(paragraph);
        this.elements.forEach(e -> paragraph.getContent().add(e.getRun()));
    }

    public void setStyle(P paragraph) {
        String styleId;
        if (this.wordPackage == null || this.paragraphStyle == null) {
            return;
        }
        PropertyResolver propertyResolver = this.wordPackage.getMainDocumentPart().getPropertyResolver();
        if (propertyResolver.activateStyle(styleId = this.paragraphStyle.getStyleId())) {
            ObjectFactory factory = Context.getWmlObjectFactory();
            PPr pPr = factory.createPPr();
            paragraph.setPPr(pPr);
            PPrBase.PStyle pStyle = factory.createPPrBasePStyle();
            pPr.setPStyle(pStyle);
            pStyle.setVal(styleId);
        }
    }
}

