/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.reporting.convert;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.docx4j.Docx4J;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.fonts.IdentityPlusMapper;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.teamapps.reporting.builder.DocumentTemplateLoader;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.reporting.convert.DocumentFormat;
import org.teamapps.reporting.convert.UnsupportedFormatException;

public class LocalDocumentConverter
implements DocumentConverter {
    @Override
    public boolean convertDocument(File input, DocumentFormat inputFormat, File output, DocumentFormat outputFormat) throws Exception {
        if (inputFormat != DocumentFormat.DOCX) {
            UnsupportedFormatException.throwException(inputFormat);
        }
        WordprocessingMLPackage wordprocessingMLPackage = DocumentTemplateLoader.getTemplate(input);
        return this.convertDocument(wordprocessingMLPackage, output, outputFormat);
    }

    @Override
    public boolean convertDocument(WordprocessingMLPackage wordprocessingMLPackage, File output, DocumentFormat outputFormat) throws Exception {
        if (outputFormat != DocumentFormat.PDF) {
            UnsupportedFormatException.throwException(outputFormat);
        }
        IdentityPlusMapper fontMapper = new IdentityPlusMapper();
        fontMapper.getFontMappings().putAll(PhysicalFonts.getPhysicalFonts());
        wordprocessingMLPackage.setFontMapper((Mapper)fontMapper);
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(output));
        FOSettings settings = Docx4J.createFOSettings();
        settings.setWmlPackage((OpcPackage)wordprocessingMLPackage);
        settings.setApacheFopMime("application/pdf");
        Docx4J.toFO((FOSettings)settings, (OutputStream)outputStream, (int)1);
        outputStream.close();
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

