/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.reporting.convert;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.reporting.convert.DocumentFormat;
import org.teamapps.reporting.convert.UnsupportedFormatException;

public class RemoteDocumentConverter
implements DocumentConverter {
    private final String host;
    private String user;
    private String password;
    private boolean noHttps;
    private String proxyHost;
    private int proxyPort;
    private CloseableHttpClient client;
    private HttpClientContext context;

    public RemoteDocumentConverter(String host) {
        this(host, null, null);
    }

    public RemoteDocumentConverter(String host, String user, String password) {
        this.host = this.cleanHost(host);
        this.user = user;
        this.password = password;
        this.init();
    }

    public RemoteDocumentConverter(String host, String user, String password, String proxyHost, int proxyPort) {
        this.host = host;
        this.user = user;
        this.password = password;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.init();
    }

    private void init() {
        this.context = HttpClientContext.create();
        if (this.user != null) {
            HttpHost targetHost = new HttpHost("https", this.host, 443);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(this.host, 443), (Credentials)new UsernamePasswordCredentials(this.user, this.password.toCharArray()));
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(targetHost, (AuthScheme)new BasicScheme());
            this.context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            this.context.setAuthCache((AuthCache)authCache);
        }
        if (this.proxyHost != null && !this.proxyHost.isBlank()) {
            RequestConfig requestConfig = RequestConfig.custom().setProxy(new HttpHost(this.proxyHost, this.proxyPort)).build();
            this.context.setRequestConfig(requestConfig);
        }
        this.client = HttpClients.custom().build();
    }

    public static String getWithBasicAuth(String url, String user, String pass) throws URISyntaxException, IOException, ParseException {
        String result = null;
        URI uri = new URI(url);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        AuthScope authScope = new AuthScope(uri.getHost(), uri.getPort());
        credentialsProvider.setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(user, pass.toCharArray()));
        try (CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();){
            HttpGet httpget = new HttpGet(url);
            try (CloseableHttpResponse response = httpclient.execute((ClassicHttpRequest)httpget);){
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isNoHttps() {
        return this.noHttps;
    }

    public void setNoHttps(boolean noHttps) {
        this.noHttps = noHttps;
    }

    private String cleanHost(String s) {
        if (s.startsWith("http://")) {
            return s.substring(7);
        }
        if (s.startsWith("https://")) {
            return s.substring(8);
        }
        return s;
    }

    @Override
    public boolean convertDocument(File input, DocumentFormat inputFormat, File output, DocumentFormat outputFormat) throws Exception {
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(input));
        return this.processDocumentConversion(inputStream, inputFormat, output, outputFormat);
    }

    @Override
    public boolean convertDocument(WordprocessingMLPackage wordprocessingMLPackage, File output, DocumentFormat outputFormat) throws Exception {
        File tempFile = File.createTempFile("temp", ".docx");
        wordprocessingMLPackage.save(tempFile);
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(tempFile));
        boolean result = this.processDocumentConversion(inputStream, DocumentFormat.DOCX, output, outputFormat);
        tempFile.delete();
        return result;
    }

    public boolean processDocumentConversion(InputStream inputStream, DocumentFormat inputFormat, File output, DocumentFormat outputFormat) throws Exception {
        if (outputFormat == DocumentFormat.PNG) {
            UnsupportedFormatException.throwException(outputFormat);
        }
        String uri = (this.isNoHttps() ? "http://" : "https://") + this.host + "/conversion?format=" + outputFormat.getFormat();
        HttpPost post = new HttpPost(uri);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.EXTENDED);
        builder.addBinaryBody("file", inputStream, ContentType.DEFAULT_BINARY, "input." + inputFormat.getFormat());
        HttpEntity entity = builder.build();
        post.setEntity(entity);
        CloseableHttpResponse response = this.client.execute((ClassicHttpRequest)post, (HttpContext)this.context);
        int statusCode = response.getCode();
        if (statusCode == 200) {
            InputStream content = response.getEntity().getContent();
            FileUtils.copyInputStreamToFile((InputStream)content, (File)output);
        }
        return statusCode == 200;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

