/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.reporting.parse;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.teamapps.reporting.builder.DocumentBuilder;
import org.teamapps.reporting.builder.DocumentTemplateLoader;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.reporting.convert.DocumentFormat;

public class DocumentParser {
    private WordprocessingMLPackage template;
    private DocumentBuilder documentBuilder;
    private final DocumentFormat inputFormat;
    private final InputStream inputStream;
    private final DocumentConverter documentConverter;

    public static DocumentParser create(DocumentFormat inputFormat, File templateFile) throws Exception {
        return DocumentParser.create(inputFormat, new BufferedInputStream(new FileInputStream(templateFile)));
    }

    public static DocumentParser create(DocumentFormat inputFormat, File templateFile, DocumentConverter documentConverter) throws Exception {
        return DocumentParser.create(inputFormat, new BufferedInputStream(new FileInputStream(templateFile)), documentConverter);
    }

    public static DocumentParser create(DocumentFormat inputFormat, InputStream inputStream) throws Exception {
        return new DocumentParser(inputFormat, inputStream);
    }

    public static DocumentParser create(DocumentFormat inputFormat, InputStream inputStream, DocumentConverter documentConverter) throws Exception {
        return new DocumentParser(inputFormat, inputStream, documentConverter);
    }

    protected DocumentParser(DocumentFormat inputFormat, InputStream inputStream) throws Exception {
        this(inputFormat, inputStream, null);
    }

    protected DocumentParser(DocumentFormat inputFormat, InputStream inputStream, DocumentConverter documentConverter) throws Exception {
        this.inputFormat = inputFormat;
        this.inputStream = inputStream;
        this.documentConverter = documentConverter;
        this.documentBuilder = new DocumentBuilder();
        this.readTemplate();
    }

    private void readTemplate() throws Exception {
        InputStream documentInputStream = this.inputStream;
        if (this.inputFormat != DocumentFormat.DOCX) {
            File tempFile = File.createTempFile("temp", "." + DocumentFormat.DOCX.getFormat());
            this.documentConverter.convertDocument(this.inputStream, this.inputFormat, tempFile, DocumentFormat.DOCX);
            documentInputStream = new BufferedInputStream(new FileInputStream(tempFile));
        }
        this.template = DocumentTemplateLoader.getTemplate(documentInputStream);
    }

    public List<List<String>> readTableData(String ... keys) {
        Tbl table = this.documentBuilder.findTable(this.template.getMainDocumentPart(), Arrays.asList(keys));
        return this.readTableData(table);
    }

    public List<List<String>> readTableData(int tableIndex) {
        List<Tbl> tables = this.documentBuilder.getAllElements(this.template.getMainDocumentPart(), new Tbl());
        if (tables.size() <= tableIndex) {
            return null;
        }
        Tbl table = tables.get(tableIndex);
        return this.readTableData(table);
    }

    private List<List<String>> readTableData(Tbl table) {
        ArrayList<List<String>> tableData = new ArrayList<List<String>>();
        for (Object element : table.getContent()) {
            if (!(element instanceof Tr)) continue;
            Tr row = (Tr)element;
            ArrayList<String> rowData = new ArrayList<String>();
            tableData.add(rowData);
            for (Object cell : row.getContent()) {
                List<Text> texts = this.documentBuilder.getAllElements(cell, new Text());
                String cellValue = texts.stream().map(Text::getValue).collect(Collectors.joining());
                rowData.add(cellValue);
            }
        }
        return tableData;
    }
}

