/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.reporting.style.run;

import java.io.File;
import java.nio.file.Files;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.R;
import org.teamapps.reporting.style.run.StyledElement;

public class ImageElement
implements StyledElement {
    private final WordprocessingMLPackage wordPackage;
    private final File file;
    private Integer width;
    private Integer height;

    public ImageElement(WordprocessingMLPackage wordPackage, File file) {
        this.wordPackage = wordPackage;
        this.file = file;
    }

    public ImageElement setSizeInMm(Integer width, Integer height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public R getRun() {
        try {
            Inline inline;
            ObjectFactory factory = new ObjectFactory();
            byte[] fileContent = Files.readAllBytes(this.file.toPath());
            BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)this.wordPackage, (byte[])fileContent);
            if (this.width != null && this.height != null) {
                long widthEmu = UnitsOfMeasurement.twipToEMU((double)UnitsOfMeasurement.mmToTwip((float)this.width.intValue()));
                long heightEmu = UnitsOfMeasurement.twipToEMU((double)UnitsOfMeasurement.mmToTwip((float)this.height.intValue()));
                inline = imagePart.createImageInline("", "", 1L, 2, widthEmu, heightEmu, false);
            } else {
                inline = imagePart.createImageInline("", "", 1L, 2, false);
            }
            R run = factory.createR();
            Drawing drawing = factory.createDrawing();
            run.getContent().add(drawing);
            drawing.getAnchorOrInline().add(inline);
            return run;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

