/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.reporting.convert;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.reporting.convert.DocumentFormat;
import org.teamapps.reporting.convert.UnsupportedFormatException;

public class RemoteDocumentConverter
implements DocumentConverter {
    private final String host;
    private String user;
    private String password;
    private boolean noHttps;
    private CloseableHttpClient client;
    private HttpClientContext context;

    public RemoteDocumentConverter(String host) {
        this(host, null, null);
    }

    public RemoteDocumentConverter(String host, String user, String password) {
        this.host = this.cleanHost(host);
        this.user = user;
        this.password = password;
        this.init();
    }

    public RemoteDocumentConverter(String host, String user, String password, String proxyHost, int proxyPort) {
        this.host = host;
        this.user = user;
        this.password = password;
        this.init();
    }

    private void init() {
        this.client = HttpClients.custom().addRequestInterceptorLast((request, entity, context) -> request.setHeader("Authorization", (Object)("Basic " + Base64.getEncoder().encodeToString((this.user + ":" + this.password).getBytes())))).build();
    }

    public boolean isNoHttps() {
        return this.noHttps;
    }

    public void setNoHttps(boolean noHttps) {
        this.noHttps = noHttps;
    }

    private String cleanHost(String s) {
        if (s.startsWith("http://")) {
            return s.substring(7);
        }
        if (s.startsWith("https://")) {
            return s.substring(8);
        }
        return s;
    }

    @Override
    public boolean convertDocument(File input, DocumentFormat inputFormat, File output, DocumentFormat outputFormat) throws Exception {
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(input));
        return this.processDocumentConversion(inputStream, inputFormat, output, outputFormat);
    }

    @Override
    public boolean convertDocument(WordprocessingMLPackage wordprocessingMLPackage, File output, DocumentFormat outputFormat) throws Exception {
        File tempFile = File.createTempFile("temp", ".docx");
        wordprocessingMLPackage.save(tempFile);
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(tempFile));
        boolean result = this.processDocumentConversion(inputStream, DocumentFormat.DOCX, output, outputFormat);
        tempFile.delete();
        return result;
    }

    public boolean processDocumentConversion(InputStream inputStream, DocumentFormat inputFormat, File output, DocumentFormat outputFormat) throws Exception {
        if (outputFormat == DocumentFormat.PNG) {
            UnsupportedFormatException.throwException(outputFormat);
        }
        String uri = (this.isNoHttps() ? "http://" : "https://") + this.host + "/conversion?format=" + outputFormat.getFormat();
        HttpPost post = new HttpPost(uri);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.EXTENDED);
        builder.addBinaryBody("file", inputStream, ContentType.DEFAULT_BINARY, "input." + inputFormat.getFormat());
        HttpEntity entity = builder.build();
        post.setEntity(entity);
        return (Boolean)this.client.execute((ClassicHttpRequest)post, (HttpContext)this.context, response -> {
            int statusCode = response.getCode();
            if (statusCode == 200) {
                InputStream content = response.getEntity().getContent();
                FileUtils.copyInputStreamToFile((InputStream)content, (File)output);
            }
            return statusCode == 200;
        });
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

