/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.reporting.convert;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.teamapps.reporting.convert.DocumentFormat;
import org.teamapps.reporting.convert.LocalDocumentConverter;
import org.teamapps.reporting.convert.RemoteDocumentConverter;

public interface DocumentConverter {
    public static DocumentConverter createLocalConverter() {
        return new LocalDocumentConverter();
    }

    public static DocumentConverter createRemoteConverter(String host) {
        return new RemoteDocumentConverter(host);
    }

    public static DocumentConverter createRemoteConverter(String host, String user, String password) {
        return new RemoteDocumentConverter(host, user, password);
    }

    default public boolean convertDocument(InputStream inputStream, DocumentFormat inputFormat, File output, DocumentFormat outputFormat) throws Exception {
        File tempFile = File.createTempFile("temp", "." + inputFormat.getFormat());
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
        boolean result = this.convertDocument(tempFile, inputFormat, output, outputFormat);
        tempFile.delete();
        return result;
    }

    public boolean convertDocument(File var1, DocumentFormat var2, File var3, DocumentFormat var4) throws Exception;

    public boolean convertDocument(WordprocessingMLPackage var1, File var2, DocumentFormat var3) throws Exception;

    public void close() throws IOException;
}

