/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.reporting.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import org.docx4j.XmlUtils;
import org.docx4j.model.structure.HeaderFooterPolicy;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.jvnet.jaxb2_commons.ppp.Child;

public class DocumentBuilder {
    public Map<String, String> createReplaceRowMap(String ... values) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < values.length; i += 2) {
            map.put(values[i], values[i + 1]);
        }
        return map;
    }

    public WordprocessingMLPackage getTemplate(String path) throws Docx4JException, FileNotFoundException {
        return WordprocessingMLPackage.load((InputStream)new FileInputStream(new File(path)));
    }

    public <T> T copyElement(T t) {
        return (T)XmlUtils.deepCopy(t);
    }

    public <T> List<T> getAllElements(Object element, T toSearch) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (element instanceof JAXBElement) {
            element = ((JAXBElement)element).getValue();
        }
        if (element.getClass().equals(toSearch.getClass())) {
            result.add(element);
        } else if (element instanceof ContentAccessor) {
            List children = ((ContentAccessor)element).getContent();
            for (Object child : children) {
                result.addAll(this.getAllElements(child, toSearch));
            }
        }
        return result;
    }

    public void save(WordprocessingMLPackage template, String target) throws Docx4JException {
        File f = new File(target);
        template.save(f);
    }

    public void fillTable(List<Map<String, String>> textToAdd, WordprocessingMLPackage template, boolean strictMode, String ... keys) throws Exception {
        this.fillTable(textToAdd, template, strictMode, Arrays.asList(keys));
    }

    public void fillTable(List<Map<String, String>> textToAdd, WordprocessingMLPackage template, boolean strictMode, List<String> keys) throws Exception {
        this.fillTable(textToAdd, Collections.emptyList(), template, strictMode, keys);
    }

    public void fillTable(List<Map<String, String>> textToAdd, List<List<String>> removeTemplateRows, WordprocessingMLPackage template, boolean strictMode, List<String> keys) throws Exception {
        Tbl matchingTable = this.findTable(template.getMainDocumentPart(), keys);
        if (strictMode && matchingTable == null) {
            throw new Exception("Error: missing template table for keys" + String.join((CharSequence)", ", keys));
        }
        HashMap<Set<String>, Tr> templateRowByColumnsSet = new HashMap<Set<String>, Tr>();
        HashSet<Tr> removeSet = new HashSet<Tr>();
        if (matchingTable != null) {
            Tr templateRow;
            for (Map<String, String> map : textToAdd) {
                templateRow = (Tr)templateRowByColumnsSet.get(map.keySet());
                if (templateRow == null) {
                    templateRow = this.findRowInTable(matchingTable, map.keySet());
                    templateRowByColumnsSet.put(map.keySet(), templateRow);
                }
                if (templateRow == null) {
                    if (!strictMode) continue;
                    throw new Exception("Error: missing template row for keys" + String.join((CharSequence)", ", map.keySet()));
                }
                removeSet.add(templateRow);
                Tr row = this.copyElement(templateRow);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    this.replaceParagraph(entry.getKey(), entry.getValue(), row);
                }
                matchingTable.getContent().add(row);
            }
            for (List list : removeTemplateRows) {
                templateRow = this.findRowInTable(matchingTable, list);
                removeSet.add(templateRow);
            }
            for (Tr tr : removeSet) {
                matchingTable.getContent().remove(tr);
            }
        }
    }

    public Tbl findTable(Object element, List<String> keys) {
        List<Tbl> tables = this.getAllElements(element, new Tbl());
        Tbl matchingTable = null;
        for (Tbl table : tables) {
            boolean hit = true;
            for (String key : keys) {
                if (this.getParagraphWithText(table, key) != null) continue;
                hit = false;
                break;
            }
            if (!hit) continue;
            matchingTable = table;
            break;
        }
        return matchingTable;
    }

    public void replaceParagraph(String key, String value, Object element) {
        P paragraph = this.getParagraphWithText(element, key);
        if (paragraph == null) {
            return;
        }
        List<Text> texts = this.getAllElements(paragraph, new Text());
        texts.get(0).setValue(value);
        if (texts.size() == 1) {
            return;
        }
        for (int i = 1; i < texts.size(); ++i) {
            this.removeChild(paragraph, texts.get(i));
        }
    }

    public void replaceParagraphTextRun(String key, String value, Object element) {
        P paragraph = this.getParagraphWithText(element, key);
        if (paragraph == null) {
            return;
        }
        List<Text> texts = this.getAllElements(paragraph, new Text());
        for (Text text : texts) {
            if (!text.getValue().contains(key)) continue;
            String replacedTextValue = text.getValue().replace(key, value);
            text.setValue(replacedTextValue);
        }
    }

    public void replaceTextRun(String key, String value, Object element) {
        List<Text> texts = this.getAllElements(element, new Text());
        for (Text text : texts) {
            if (!text.getValue().contains(key)) continue;
            String replacedTextValue = text.getValue().replace(key, value);
            text.setValue(replacedTextValue);
        }
    }

    private void replaceTextRunWithinMarkers(String key, String value, Text text) {
        P paragraph = this.getParagraphOfText(text);
        if (paragraph != null) {
            List<Text> texts = this.getMarkerTextRuns(paragraph, key, "<", ">");
            if (texts == null || texts.isEmpty()) {
                return;
            }
            if (texts.size() == 1) {
                Text t = texts.get(0);
                t.setValue(t.getValue().replace(key, value));
            } else if (texts.size() == 2) {
                Text start = texts.get(0);
                Text end = texts.get(1);
                int pos = start.getValue().lastIndexOf(60);
                start.setValue(start.getValue().substring(0, pos));
                pos = end.getValue().indexOf(62);
                end.setValue(value + end.getValue().substring(pos + 1));
                this.addSpace(end, true, false);
            } else {
                Text start = texts.get(0);
                Text end = texts.get(texts.size() - 1);
                int pos = start.getValue().lastIndexOf(60);
                start.setValue(start.getValue().substring(0, pos));
                pos = end.getValue().indexOf(62);
                end.setValue(end.getValue().substring(pos + 1));
                Text mid = texts.get(1);
                mid.setValue(value);
                this.addSpace(mid, true, true);
                if (texts.size() > 3) {
                    for (int i = 2; i < texts.size() - 1; ++i) {
                        texts.get(i).setValue("");
                    }
                }
            }
        }
    }

    private List<Text> getMarkerTextRuns(P paragraph, String key, String startMarker, String endMarker) {
        List<Text> texts = this.getAllElements(paragraph, new Text());
        boolean started = false;
        ArrayList<Text> resultRuns = null;
        for (Text text : texts) {
            StringBuilder sb;
            if (text.getValue().contains(startMarker)) {
                if (started && text.getValue().contains(endMarker)) {
                    sb = new StringBuilder();
                    resultRuns.add(text);
                    resultRuns.forEach(t -> sb.append(t.getValue()));
                    if (sb.toString().contains(key)) {
                        return resultRuns;
                    }
                }
                started = true;
                resultRuns = new ArrayList<Text>();
            }
            if (started) {
                resultRuns.add(text);
            }
            if (!text.getValue().contains(endMarker)) continue;
            sb = new StringBuilder();
            resultRuns.forEach(t -> sb.append(t.getValue()));
            if (!sb.toString().contains(key)) continue;
            return resultRuns;
        }
        return null;
    }

    private void addSpace(Text text, boolean left, boolean right) {
        R run;
        Object parent = text.getParent();
        if (parent instanceof R && (run = (R)parent).getContent().size() == 1) {
            Text space;
            if (left) {
                space = new Text();
                space.setSpace("preserve");
                space.setValue(" ");
                run.getContent().add(0, space);
            }
            if (right) {
                space = new Text();
                space.setSpace("preserve");
                space.setValue(" ");
                run.getContent().add(space);
            }
        }
    }

    public void replaceTextRunWithFootersAndHeaders(String key, String value, Object element, WordprocessingMLPackage template) {
        List<Text> texts = this.getAllElements(element, new Text());
        texts.addAll(this.getHeaderFooterTexts(template));
        for (Text text : texts) {
            if (key.startsWith("<") && key.endsWith(">")) {
                this.replaceTextRunWithinMarkers(key, value, text);
                continue;
            }
            if (!text.getValue().contains(key)) continue;
            String replacedTextValue = text.getValue().replace(key, value);
            text.setValue(replacedTextValue);
        }
    }

    private List<Text> getHeaderFooterTexts(WordprocessingMLPackage template) {
        List sectionWrappers = template.getDocumentModel().getSections();
        ArrayList<Text> texts = new ArrayList<Text>();
        for (SectionWrapper sectionWrapper : sectionWrappers) {
            HeaderFooterPolicy headerFooterPolicy = sectionWrapper.getHeaderFooterPolicy();
            if (headerFooterPolicy.getDefaultHeader() != null) {
                texts.addAll(this.getAllElements(headerFooterPolicy.getDefaultHeader(), new Text()));
            }
            if (headerFooterPolicy.getDefaultFooter() == null) continue;
            texts.addAll(this.getAllElements(headerFooterPolicy.getDefaultFooter(), new Text()));
        }
        return texts;
    }

    public void removeChild(Object parent, Object child) {
        if (parent instanceof ContentAccessor) {
            ContentAccessor contentAccessor = (ContentAccessor)parent;
            List children = contentAccessor.getContent();
            HashSet<Object> contentSet = new HashSet<Object>(children);
            this.removeChild(contentAccessor, contentSet, child);
        }
    }

    public void removeChild(ContentAccessor contentAccessor, Set<Object> contentSet, Object child) {
        Child contentChild;
        Object parent;
        if (contentSet.contains(child)) {
            contentAccessor.getContent().remove(child);
        } else if (child instanceof Child && (parent = (contentChild = (Child)child).getParent()) != null) {
            this.removeChild(contentAccessor, contentSet, parent);
        }
    }

    public Tr findRowInTable(Tbl table, Collection<String> keys) {
        return this.findRowInTable(table, keys.toArray(new String[0]));
    }

    public Tr findRowInTable(Tbl table, String ... keys) {
        List<Tr> rows = this.getAllElements(table, new Tr());
        for (Tr row : rows) {
            boolean hit = true;
            for (String key : keys) {
                if (this.getParagraphWithText(row, key) != null) continue;
                hit = false;
                break;
            }
            if (!hit) continue;
            return row;
        }
        return null;
    }

    public P getParagraphWithText(Object element, String key) {
        List<P> paragraphs = this.getAllElements(element, new P());
        for (P paragraph : paragraphs) {
            List<Text> texts = this.getAllElements(paragraph, new Text());
            StringBuilder sb = new StringBuilder();
            texts.forEach(text -> sb.append(text.getValue()));
            if (sb.length() <= 0 || !sb.toString().contains(key)) continue;
            return paragraph;
        }
        return null;
    }

    public P getParagraphOfText(Text text) {
        R run;
        Object paragraph;
        Object parent = text.getParent();
        if (parent != null && parent instanceof R && (paragraph = (run = (R)parent).getParent()) != null && paragraph instanceof P) {
            return (P)paragraph;
        }
        return null;
    }
}

