/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.reporting.convert;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.reporting.convert.DocumentFormat;
import org.teamapps.reporting.convert.UnsupportedFormatException;

public class RemoteDocumentConverter
implements DocumentConverter {
    private final String host;
    private String user;
    private String password;
    private String proxyHost;
    private int proxyPort;
    private CloseableHttpClient client;
    private HttpClientContext context;

    public RemoteDocumentConverter(String host) {
        this(host, null, null);
    }

    public RemoteDocumentConverter(String host, String user, String password) {
        this.host = this.cleanHost(host);
        this.user = user;
        this.password = password;
        this.init();
    }

    public RemoteDocumentConverter(String host, String user, String password, String proxyHost, int proxyPort) {
        this.host = host;
        this.user = user;
        this.password = password;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.init();
    }

    private String cleanHost(String s) {
        if (s.startsWith("http://")) {
            return s.substring(7);
        }
        if (s.startsWith("https://")) {
            return s.substring(8);
        }
        return s;
    }

    private void init() {
        this.context = HttpClientContext.create();
        if (this.user != null) {
            HttpHost targetHost = new HttpHost(this.host, 443, "https");
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.user, this.password));
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(targetHost, (AuthScheme)new BasicScheme());
            this.context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            this.context.setAuthCache((AuthCache)authCache);
        }
        if (this.proxyHost != null) {
            RequestConfig requestConfig = RequestConfig.custom().setProxy(new HttpHost(this.proxyHost, this.proxyPort)).build();
            this.context.setRequestConfig(requestConfig);
        }
        this.client = HttpClients.custom().build();
    }

    @Override
    public boolean convertDocument(File input, DocumentFormat inputFormat, File output, DocumentFormat outputFormat) throws Exception {
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(input));
        return this.processDocumentConversion(inputStream, inputFormat, output, outputFormat);
    }

    @Override
    public boolean convertDocument(WordprocessingMLPackage wordprocessingMLPackage, File output, DocumentFormat outputFormat) throws Exception {
        File tempFile = File.createTempFile("temp", ".docx");
        wordprocessingMLPackage.save(tempFile);
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(tempFile));
        boolean result = this.processDocumentConversion(inputStream, DocumentFormat.DOCX, output, outputFormat);
        tempFile.delete();
        return result;
    }

    public boolean processDocumentConversion(InputStream inputStream, DocumentFormat inputFormat, File output, DocumentFormat outputFormat) throws Exception {
        if (outputFormat == DocumentFormat.PNG) {
            UnsupportedFormatException.throwException(outputFormat);
        }
        HttpPost post = new HttpPost("https://" + this.host + "/conversion?format=" + outputFormat.getFormat());
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addBinaryBody("file", inputStream, ContentType.DEFAULT_BINARY, "input." + inputFormat.getFormat());
        HttpEntity entity = builder.build();
        post.setEntity(entity);
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)post, (HttpContext)this.context);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            InputStream content = response.getEntity().getContent();
            FileUtils.copyInputStreamToFile((InputStream)content, (File)output);
        }
        return statusCode == 200;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

