/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.server.jetty.embedded;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.teamapps.client.ClientCodeExtractor;
import org.teamapps.config.TeamAppsConfiguration;
import org.teamapps.core.TeamAppsCore;
import org.teamapps.util.threading.CompletableFutureChainSequentialExecutorFactory;
import org.teamapps.util.threading.SequentialExecutorFactory;
import org.teamapps.ux.servlet.TeamAppsServletContextListener;
import org.teamapps.webcontroller.WebController;

public class TeamAppsJettyEmbeddedServer {
    public static final int DEFAULT_PORT = 8080;
    private final TeamAppsCore teamAppsCore;
    private final File webAppDirectory;
    private final List<ServletContextListener> customServletContextListeners = new ArrayList<ServletContextListener>();
    private final Server server;
    private final WebAppContext webapp;

    public TeamAppsJettyEmbeddedServer(WebController webController) throws IOException, ServletException {
        this(webController, Files.createTempDirectory("teamapps", new FileAttribute[0]).toFile(), new TeamAppsConfiguration());
    }

    public TeamAppsJettyEmbeddedServer(WebController webController, int port) throws IOException, ServletException {
        this(webController, Files.createTempDirectory("teamapps", new FileAttribute[0]).toFile(), new TeamAppsConfiguration(), port);
    }

    public TeamAppsJettyEmbeddedServer(WebController webController, TeamAppsConfiguration config) throws IOException, ServletException {
        this(webController, Files.createTempDirectory("teamapps", new FileAttribute[0]).toFile(), config, 8080);
    }

    public TeamAppsJettyEmbeddedServer(WebController webController, TeamAppsConfiguration config, int port) throws IOException, ServletException {
        this(webController, Files.createTempDirectory("teamapps", new FileAttribute[0]).toFile(), config, port);
    }

    public TeamAppsJettyEmbeddedServer(WebController webController, File webAppDirectory, int port) throws ServletException {
        this(webController, webAppDirectory, new TeamAppsConfiguration(), port);
    }

    public TeamAppsJettyEmbeddedServer(WebController webController, File webAppDirectory, TeamAppsConfiguration config) throws ServletException {
        this(webController, webAppDirectory, config, 8080);
    }

    public TeamAppsJettyEmbeddedServer(WebController webController, File webAppDirectory, TeamAppsConfiguration config, int port) throws ServletException {
        this.teamAppsCore = new TeamAppsCore(config, (SequentialExecutorFactory)new CompletableFutureChainSequentialExecutorFactory(config.getMaxNumberOfSessionExecutorThreads()), webController);
        this.webAppDirectory = webAppDirectory;
        this.server = new Server(port);
        this.webapp = new WebAppContext();
        this.webapp.setConfigurations(new Configuration[]{new WebXmlConfiguration()});
        this.webapp.setContextPath("/");
        this.webapp.addEventListener((EventListener)new TeamAppsServletContextListener(this.teamAppsCore));
        this.webapp.setResourceBase(webAppDirectory.getAbsolutePath());
        this.webapp.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        this.webapp.getSessionHandler().setSecureRequestOnly(true);
        this.server.setHandler((Handler)this.webapp);
        WebSocketServerContainerInitializer.configureContext((ServletContextHandler)this.webapp);
    }

    public void configureHttpsUsingP12File(int port, File keyStoreFile, String keyStorePassword) {
        if (this.server.isStarting() || this.server.isStarted()) {
            throw new IllegalStateException("HTTPS must be configured before starting the server!");
        }
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setSecureScheme("https");
        http_config.setSecurePort(port);
        HttpConfiguration https_config = new HttpConfiguration(http_config);
        https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        try {
            sslContextFactory.setKeyStore(KeyStore.getInstance(keyStoreFile, keyStorePassword.toCharArray()));
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        sslContextFactory.setKeyStorePassword(keyStorePassword);
        ServerConnector httpsConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, "http/1.1"), new HttpConnectionFactory(https_config)});
        httpsConnector.setPort(8443);
        httpsConnector.setIdleTimeout(50000L);
        this.server.addConnector((Connector)httpsConnector);
    }

    public Server getServer() {
        return this.server;
    }

    public WebAppContext getWebapp() {
        return this.webapp;
    }

    public TeamAppsCore getTeamAppsCore() {
        return this.teamAppsCore;
    }

    public void addServletContextListener(ServletContextListener servletContextListener) {
        if (this.server.isRunning()) {
            throw new IllegalStateException("ServletContextListeners need to be registered before the server is started!");
        }
        this.customServletContextListeners.add(servletContextListener);
    }

    public void start() throws Exception {
        ClientCodeExtractor.initializeWebserverDirectory((File)this.webAppDirectory);
        this.customServletContextListeners.forEach(arg_0 -> ((WebAppContext)this.webapp).addEventListener(arg_0));
        this.server.start();
        this.server.join();
    }

    public void stop() throws Exception {
        this.server.stop();
    }
}

