/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.server.jetty.embedded;

import jakarta.servlet.ServletContextListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.webapp.Configuration;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.ee10.webapp.WebXmlConfiguration;
import org.eclipse.jetty.ee10.websocket.jakarta.server.config.JakartaWebSocketServletContainerInitializer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.teamapps.client.ClientCodeExtractor;
import org.teamapps.config.TeamAppsConfiguration;
import org.teamapps.core.TeamAppsCore;
import org.teamapps.util.threading.CompletableFutureChainSequentialExecutorFactory;
import org.teamapps.util.threading.SequentialExecutorFactory;
import org.teamapps.ux.servlet.TeamAppsServletContextListener;
import org.teamapps.webcontroller.WebController;

public class TeamAppsJettyEmbeddedServer {
    public static final int DEFAULT_PORT = 8080;
    private final TeamAppsCore teamAppsCore;
    private final File webAppDirectory;
    private final List<ServletContextListener> customServletContextListeners = new ArrayList<ServletContextListener>();
    private final Server server;
    private final WebAppContext webapp;

    public TeamAppsJettyEmbeddedServer(WebController webController, File webAppDirectory, TeamAppsConfiguration config, int port, boolean globalGzipCompression) {
        this.teamAppsCore = new TeamAppsCore(config, (SequentialExecutorFactory)new CompletableFutureChainSequentialExecutorFactory(config.getMaxNumberOfSessionExecutorThreads()), webController);
        this.webAppDirectory = webAppDirectory;
        this.server = new Server(port);
        this.webapp = new WebAppContext();
        this.webapp.setClassLoader(TeamAppsJettyEmbeddedServer.class.getClassLoader());
        this.webapp.setConfigurations(new Configuration[]{new WebXmlConfiguration()});
        this.webapp.getServerClassMatcher().exclude("org.eclipse.jetty.");
        this.webapp.setContextPath("/");
        this.webapp.addEventListener((EventListener)new TeamAppsServletContextListener(this.teamAppsCore));
        this.webapp.setBaseResourceAsPath(webAppDirectory.getAbsoluteFile().toPath());
        this.webapp.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        this.webapp.getSessionHandler().setSecureRequestOnly(true);
        if (globalGzipCompression) {
            GzipHandler gzipHandler = new GzipHandler();
            gzipHandler.setInflateBufferSize(32768);
            this.server.setHandler((Handler)gzipHandler);
            gzipHandler.setHandler((Handler)this.webapp);
        } else {
            this.server.setHandler((Handler)this.webapp);
        }
        JakartaWebSocketServletContainerInitializer.configure((ServletContextHandler)this.webapp, null);
    }

    public Server getServer() {
        return this.server;
    }

    public WebAppContext getWebapp() {
        return this.webapp;
    }

    public TeamAppsCore getTeamAppsCore() {
        return this.teamAppsCore;
    }

    public void addServletContextListener(ServletContextListener servletContextListener) {
        if (this.server.isRunning()) {
            throw new IllegalStateException("ServletContextListeners need to be registered before the server is started!");
        }
        this.customServletContextListeners.add(servletContextListener);
    }

    public void start() throws Exception {
        ClientCodeExtractor.initializeWebserverDirectory((File)this.webAppDirectory);
        this.customServletContextListeners.forEach(arg_0 -> ((WebAppContext)this.webapp).addEventListener(arg_0));
        this.server.start();
        this.server.join();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public static class Builder {
        private WebController webController;
        private File webAppDirectory;
        private TeamAppsConfiguration config = new TeamAppsConfiguration();
        private int port = 8080;
        private boolean globalGzipCompression;

        public Builder setWebController(WebController webController) {
            this.webController = webController;
            return this;
        }

        public Builder setWebAppDirectory(File webAppDirectory) {
            this.webAppDirectory = webAppDirectory;
            return this;
        }

        public Builder setConfig(TeamAppsConfiguration config) {
            this.config = config;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setGlobalGzipCompression(boolean globalGzipCompression) {
            this.globalGzipCompression = globalGzipCompression;
            return this;
        }

        public TeamAppsJettyEmbeddedServer build() throws IOException {
            if (this.webAppDirectory == null) {
                this.webAppDirectory = Files.createTempDirectory("teamapps", new FileAttribute[0]).toFile();
            }
            return new TeamAppsJettyEmbeddedServer(this.webController, this.webAppDirectory, this.config, this.port, this.globalGzipCompression);
        }
    }
}

