/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.server.jetty.embedded;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.EventListener;
import javax.servlet.ServletException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.teamapps.client.ClientCodeExtractor;
import org.teamapps.config.TeamAppsConfiguration;
import org.teamapps.ux.servlet.TeamAppsServletContextListener;
import org.teamapps.webcontroller.WebController;

public class TeamAppsJettyEmbeddedServer {
    private final WebController webController;
    private final File webAppDirectory;
    private final Server server;

    public TeamAppsJettyEmbeddedServer(WebController webController, File webAppDirectory) throws ServletException {
        this(webController, webAppDirectory, new TeamAppsConfiguration());
    }

    public TeamAppsJettyEmbeddedServer(WebController webController, File webAppDirectory, TeamAppsConfiguration config) throws ServletException {
        this(webController, webAppDirectory, 8080, config);
    }

    public TeamAppsJettyEmbeddedServer(WebController webController, File webAppDirectory, int port) throws ServletException {
        this(webController, webAppDirectory, port, new TeamAppsConfiguration());
    }

    public TeamAppsJettyEmbeddedServer(WebController webController, File webAppDirectory, int port, TeamAppsConfiguration config) throws ServletException {
        this.webController = webController;
        this.webAppDirectory = webAppDirectory;
        this.server = new Server(port);
        WebAppContext webapp = new WebAppContext();
        webapp.setConfigurations(new Configuration[]{new WebXmlConfiguration()});
        webapp.setContextPath("/");
        webapp.addEventListener((EventListener)new TeamAppsServletContextListener(config, webController));
        webapp.setResourceBase(webAppDirectory.getAbsolutePath());
        this.server.setHandler((Handler)webapp);
        WebSocketServerContainerInitializer.configureContext((ServletContextHandler)webapp);
    }

    public void start() throws Exception {
        ClientCodeExtractor.initializeWebserverDirectory((File)this.webAppDirectory);
        this.server.start();
        this.server.join();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public Server getServer() {
        return this.server;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: webControllerClass [webappDirectory]");
            return;
        }
        WebController webController = (WebController)Class.forName(args[0]).getConstructor(new Class[0]).newInstance(new Object[0]);
        new TeamAppsJettyEmbeddedServer(webController, Files.createTempDirectory("sf", new FileAttribute[0]).toFile(), 8080).start();
    }
}

