/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.server.tomcat.embedded;

import java.io.File;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Wrapper;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.websocket.server.WsSci;
import org.teamapps.client.ClientCodeExtractor;
import org.teamapps.ux.servlet.TeamAppsServletContextListener;
import org.teamapps.webcontroller.WebController;

public class TeamAppsTomcatEmbeddedServer {
    private final WebController webController;
    private final File webAppDirectory;
    private Tomcat server;
    boolean initialized = false;

    public TeamAppsTomcatEmbeddedServer(WebController webController, File webAppDirectory) {
        this.webController = webController;
        this.webAppDirectory = webAppDirectory;
    }

    public void start(int port) throws Exception {
        ClientCodeExtractor.initializeWebserverDirectory((File)this.webAppDirectory);
        this.server = new Tomcat();
        this.server.setPort(port);
        Context context = this.server.addContext("", this.webAppDirectory.getAbsolutePath());
        TeamAppsServletContextListener listener = new TeamAppsServletContextListener(this.webController);
        context.addServletContainerInitializer((ServletContainerInitializer)new WsSci(), null);
        context.addServletContainerInitializer((c, servletContext) -> listener.contextInitialized(new ServletContextEvent(context.getServletContext())), null);
        context.addLifecycleListener(event -> {
            if (event.getLifecycle().getState() == LifecycleState.DESTROYING) {
                listener.contextDestroyed(new ServletContextEvent(context.getServletContext()));
                this.initialized = false;
            }
        });
        DefaultServlet defaultServlet = new DefaultServlet(){

            protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if (request.getPathInfo() == null || request.getPathInfo().equals("/")) {
                    super.doGet((HttpServletRequest)new HttpServletRequestWrapper(request){

                        public String getPathInfo() {
                            return "/index.html";
                        }
                    }, response);
                } else {
                    super.doGet(request, response);
                }
            }
        };
        Wrapper wrapper = Tomcat.addServlet((Context)context, (String)"default", (Servlet)defaultServlet);
        wrapper.addInitParameter("listings", "true");
        wrapper.addMapping("/*");
        this.server.getConnector();
        this.server.start();
    }

    public void start() throws Exception {
        this.start(8080);
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: webControllerClass [webappDirectory]");
        }
        WebController webController = (WebController)Class.forName(args[0]).getConstructor(new Class[0]).newInstance(new Object[0]);
        new TeamAppsTomcatEmbeddedServer(webController, new File(args[1])).start();
    }
}

