/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.server.tomcat.embedded;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Wrapper;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.websocket.server.WsSci;
import org.teamapps.client.ClientCodeExtractor;
import org.teamapps.config.TeamAppsConfiguration;
import org.teamapps.core.TeamAppsCore;
import org.teamapps.ux.servlet.TeamAppsServletContextListener;
import org.teamapps.webcontroller.WebController;

@Deprecated
public class TeamAppsTomcatEmbeddedServer {
    private final TeamAppsCore teamAppsCore;
    private final File webAppDirectory;
    private final List<ServletContextListener> customServletContextListeners = new ArrayList<ServletContextListener>();
    private final int port;
    private Tomcat server;
    private boolean started;

    public TeamAppsTomcatEmbeddedServer(WebController webController) throws IOException {
        this(webController, Files.createTempDirectory("teamapps", new FileAttribute[0]).toFile(), new TeamAppsConfiguration());
    }

    public TeamAppsTomcatEmbeddedServer(WebController webController, int port) throws IOException {
        this(webController, Files.createTempDirectory("teamapps", new FileAttribute[0]).toFile(), new TeamAppsConfiguration(), port);
    }

    public TeamAppsTomcatEmbeddedServer(WebController webController, File webAppDirectory, int port) {
        this(webController, webAppDirectory, new TeamAppsConfiguration(), port);
    }

    public TeamAppsTomcatEmbeddedServer(WebController webController, File webAppDirectory, TeamAppsConfiguration config) {
        this(webController, webAppDirectory, config, 8080);
    }

    public TeamAppsTomcatEmbeddedServer(WebController webController, File webAppDirectory, TeamAppsConfiguration config, int port) {
        this.teamAppsCore = new TeamAppsCore(config, webController);
        this.webAppDirectory = webAppDirectory;
        this.port = port;
    }

    public TeamAppsCore getTeamAppsCore() {
        return this.teamAppsCore;
    }

    public void addServletContextListener(ServletContextListener servletContextListener) {
        if (this.started) {
            throw new IllegalStateException("ServletContextListeners need to be registered before the server is started!");
        }
        this.customServletContextListeners.add(servletContextListener);
    }

    public void start() throws Exception {
        this.started = true;
        ClientCodeExtractor.initializeWebserverDirectory((File)this.webAppDirectory);
        this.server = new Tomcat();
        this.server.setPort(this.port);
        Context context = this.server.addContext("", this.webAppDirectory.getAbsolutePath());
        TeamAppsServletContextListener listener = new TeamAppsServletContextListener(this.teamAppsCore);
        context.addServletContainerInitializer((ServletContainerInitializer)new WsSci(), null);
        context.addServletContainerInitializer((c, servletContext) -> {
            ServletContextEvent servletContextEvent = new ServletContextEvent(servletContext);
            listener.contextInitialized(servletContextEvent);
            this.customServletContextListeners.forEach(l -> l.contextInitialized(servletContextEvent));
        }, null);
        context.addLifecycleListener(event -> {
            if (event.getLifecycle().getState() == LifecycleState.DESTROYING) {
                ServletContextEvent servletContextEvent = new ServletContextEvent(context.getServletContext());
                listener.contextDestroyed(servletContextEvent);
                this.customServletContextListeners.forEach(l -> l.contextDestroyed(servletContextEvent));
            }
        });
        DefaultServlet defaultServlet = new DefaultServlet(){

            protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if (request.getPathInfo() == null || request.getPathInfo().equals("/")) {
                    super.doGet((HttpServletRequest)new HttpServletRequestWrapper(request){

                        public String getPathInfo() {
                            return "/index.html";
                        }
                    }, response);
                } else {
                    super.doGet(request, response);
                }
            }
        };
        Wrapper wrapper = Tomcat.addServlet((Context)context, (String)"default", (Servlet)defaultServlet);
        wrapper.addInitParameter("listings", "true");
        wrapper.addMapping("/*");
        this.server.getConnector();
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }
}

