/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.server.undertow.embedded;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContextListener;
import org.teamapps.client.ClientCodeExtractor;
import org.teamapps.config.TeamAppsConfiguration;
import org.teamapps.core.TeamAppsCore;
import org.teamapps.util.threading.CompletableFutureChainSequentialExecutorFactory;
import org.teamapps.util.threading.SequentialExecutorFactory;
import org.teamapps.ux.servlet.TeamAppsServletContextListener;
import org.teamapps.webcontroller.WebController;

public class TeamAppsUndertowEmbeddedServer {
    private final TeamAppsCore teamAppsCore;
    private final File webAppDirectory;
    private final List<ServletContextListener> customServletContextListeners = new ArrayList<ServletContextListener>();
    private final int port;
    private Undertow server;
    private boolean started;

    public TeamAppsUndertowEmbeddedServer(WebController webController) throws IOException {
        this(webController, Files.createTempDirectory("teamapps", new FileAttribute[0]).toFile(), new TeamAppsConfiguration());
    }

    public TeamAppsUndertowEmbeddedServer(WebController webController, int port) throws IOException {
        this(webController, Files.createTempDirectory("teamapps", new FileAttribute[0]).toFile(), new TeamAppsConfiguration(), port);
    }

    public TeamAppsUndertowEmbeddedServer(WebController webController, TeamAppsConfiguration config) throws IOException {
        this(webController, Files.createTempDirectory("teamapps", new FileAttribute[0]).toFile(), config, 8080);
    }

    public TeamAppsUndertowEmbeddedServer(WebController webController, TeamAppsConfiguration config, int port) throws IOException {
        this(webController, Files.createTempDirectory("teamapps", new FileAttribute[0]).toFile(), config, port);
    }

    public TeamAppsUndertowEmbeddedServer(WebController webController, File webAppDirectory, int port) throws IOException {
        this(webController, webAppDirectory, new TeamAppsConfiguration(), port);
    }

    public TeamAppsUndertowEmbeddedServer(WebController webController, File webAppDirectory, TeamAppsConfiguration config) throws IOException {
        this(webController, webAppDirectory, config, 8080);
    }

    public TeamAppsUndertowEmbeddedServer(WebController webController, File webAppDirectory, TeamAppsConfiguration config, int port) throws IOException {
        this.teamAppsCore = new TeamAppsCore(config, (SequentialExecutorFactory)new CompletableFutureChainSequentialExecutorFactory(config.getMaxNumberOfSessionExecutorThreads()), webController);
        this.webAppDirectory = webAppDirectory.toPath().toRealPath(new LinkOption[0]).toFile();
        this.port = port;
    }

    public TeamAppsCore getTeamAppsCore() {
        return this.teamAppsCore;
    }

    public void addServletContextListener(ServletContextListener servletContextListener) {
        if (this.started) {
            throw new IllegalStateException("ServletContextListeners need to be registered before the server is started!");
        }
        this.customServletContextListeners.add(servletContextListener);
    }

    public void start() throws Exception {
        this.started = true;
        ClientCodeExtractor.initializeWebserverDirectory((File)this.webAppDirectory);
        TeamAppsServletContextListener servletContextListener = new TeamAppsServletContextListener(this.teamAppsCore);
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        DeploymentInfo deploymentInfo = new DeploymentInfo().setContextPath("/").addWelcomePage("index.html").setDeploymentName("teamapps").addListener(new ListenerInfo(ServletContextListener.class, () -> new ImmediateInstanceHandle((Object)servletContextListener))).setResourceManager((ResourceManager)new FileResourceManager(this.webAppDirectory.getAbsoluteFile())).setAllowNonStandardWrappers(true).addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)new WebSocketDeploymentInfo()).setClassLoader(classLoader);
        this.customServletContextListeners.forEach(l -> deploymentInfo.addListener(new ListenerInfo(ServletContextListener.class, () -> new ImmediateInstanceHandle(l))));
        ServletContainer servletContainer = Servlets.defaultContainer();
        DeploymentManager deploymentManager = servletContainer.addDeployment(deploymentInfo);
        deploymentManager.deploy();
        HttpHandler httpHandler = deploymentManager.start();
        this.server = Undertow.builder().addHttpListener(this.port, "0.0.0.0").setHandler(httpHandler).setIoThreads(Math.max(Runtime.getRuntime().availableProcessors() * 4, 10)).setWorkerThreads(Math.max(Runtime.getRuntime().availableProcessors() * 8, 10)).build();
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }
}

