/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.server.undertow.embedded;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.io.File;
import org.teamapps.client.ClientCodeExtractor;
import org.teamapps.config.TeamAppsConfiguration;
import org.teamapps.ux.servlet.TeamAppsServletContextListener;
import org.teamapps.webcontroller.WebController;

public class TeamAppsUndertowEmbeddedServer {
    private final WebController webController;
    private final File webAppDirectory;
    private TeamAppsConfiguration config;
    private Undertow server;

    public TeamAppsUndertowEmbeddedServer(WebController webController, File webAppDirectory) {
        this(webController, webAppDirectory, new TeamAppsConfiguration());
    }

    public TeamAppsUndertowEmbeddedServer(WebController webController, File webAppDirectory, TeamAppsConfiguration config) {
        this.webController = webController;
        this.webAppDirectory = webAppDirectory;
        this.config = config;
    }

    public void start(int port, String host) throws Exception {
        ClientCodeExtractor.initializeWebserverDirectory((File)this.webAppDirectory);
        TeamAppsServletContextListener servletContextListener = new TeamAppsServletContextListener(this.config, this.webController);
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        DeploymentInfo deploymentInfo = new DeploymentInfo().setContextPath("/").addWelcomePage("index.html").setDeploymentName("teamapps").addListener(new ListenerInfo(TeamAppsServletContextListener.class, () -> new ImmediateInstanceHandle((Object)servletContextListener))).setResourceManager((ResourceManager)new FileResourceManager(this.webAppDirectory.getAbsoluteFile())).setAllowNonStandardWrappers(true).addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)new WebSocketDeploymentInfo()).setClassLoader(classLoader);
        ServletContainer servletContainer = Servlets.defaultContainer();
        DeploymentManager deploymentManager = servletContainer.addDeployment(deploymentInfo);
        deploymentManager.deploy();
        HttpHandler httpHandler = deploymentManager.start();
        this.server = Undertow.builder().addHttpListener(8080, "0.0.0.0").setHandler(httpHandler).build();
        this.server.start();
    }

    public void start(int port) throws Exception {
        this.start(port, "0.0.0.0");
    }

    public void start() throws Exception {
        this.start(8080, "0.0.0.0");
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: webControllerClass [webappDirectory]");
        }
        WebController webController = (WebController)Class.forName(args[0]).getConstructor(new Class[0]).newInstance(new Object[0]);
        new TeamAppsUndertowEmbeddedServer(webController, new File(args[1])).start();
    }
}

