/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icon.shape;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.teamapps.icon.shape.ShapeIcon;
import org.teamapps.icon.shape.ShapeIconDefaultStyleSupplier;
import org.teamapps.icon.shape.ShapeIconStyle;
import org.teamapps.icons.IconLoaderContext;
import org.teamapps.icons.IconResource;
import org.teamapps.icons.IconType;
import org.teamapps.icons.spi.IconLoader;

public class ShapeIconLoader
implements IconLoader<ShapeIcon> {
    public IconResource loadIcon(ShapeIcon icon, int size, IconLoaderContext context) {
        String svg = this.getSVG(icon.getIconName(), icon.getStyle());
        return svg != null ? new IconResource(svg.getBytes(StandardCharsets.UTF_8), IconType.SVG) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSVG(String iconName, ShapeIconStyle style) {
        if (!((String)iconName).endsWith(".svg")) {
            iconName = (String)iconName + ".svg";
        }
        String path = "/org/teamapps/icon/shape/" + (String)iconName;
        try (InputStream inputStream = this.getClass().getResourceAsStream(path);){
            if (inputStream == null) {
                String string2 = null;
                return string2;
            }
            String svg = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            if (style == null) {
                style = ShapeIconDefaultStyleSupplier.DEFAULT_STYLE;
            }
            String string = svg = this.applyStyle(svg, style);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String applyStyle(String svg, ShapeIconStyle style) {
        svg = this.insertPlaceHolder(svg, "fillColor", style.getFillColor().toHtmlColorString());
        svg = this.insertPlaceHolder(svg, "strokeColor", style.getStrokeColor().toHtmlColorString());
        svg = this.insertPlaceHolder(svg, "strokeWidth", "" + style.getStrokeWidth());
        svg = this.insertPlaceHolder(svg, "filter", style.isShadow() ? "url(#shadow)" : "none");
        svg = this.insertPlaceHolder(svg, "transform", (String)(style.getScaling() != 1.0f ? "scale(" + style.getScaling() * 100.0f + "%)" : "none"));
        return svg;
    }

    private String insertPlaceHolder(String svg, String placeholderName, String value) {
        return svg.replace("@" + placeholderName + "@", value);
    }
}

