/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icon.shape;

import org.teamapps.icon.shape.ShapeIcon;
import org.teamapps.icon.shape.ShapeIconStyle;
import org.teamapps.icons.IconEncoderContext;
import org.teamapps.icons.spi.IconEncoder;

public class ShapeIconEncoder
implements IconEncoder<ShapeIcon> {
    public static final String FILL_COLOR = "fillColor";
    public static final String STROKE_COLOR = "strokeColor";
    public static final String STROKE_WIDTH = "strokeWidth";
    public static final String SHADOW = "shadow";
    public static final String SCALING = "scaling";

    public String encodeIcon(ShapeIcon icon, IconEncoderContext iconEncoderContext) {
        if (icon.getStyle() != null) {
            return icon.getIconName() + "(" + this.encodeStyle(icon.getStyle()) + ")";
        }
        return icon.getIconName();
    }

    private String encodeStyle(ShapeIconStyle style) {
        return "fillColor!" + style.getFillColor().toHtmlColorString().substring(1) + "!strokeColor!" + style.getStrokeColor().toHtmlColorString().substring(1) + "!strokeWidth!" + style.getStrokeWidth() + "!shadow!" + style.isShadow() + "!scaling!" + style.getScaling();
    }
}

