/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icon.shape;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.teamapps.icon.shape.ShapeIconDecoder;
import org.teamapps.icon.shape.ShapeIconDefaultStyleSupplier;
import org.teamapps.icon.shape.ShapeIconEncoder;
import org.teamapps.icon.shape.ShapeIconLoader;
import org.teamapps.icon.shape.ShapeIconStyle;
import org.teamapps.icon.shape.ShapeIconStyleBuilder;
import org.teamapps.icons.Icon;
import org.teamapps.icons.spi.IconLibrary;

@IconLibrary(name="shape", encoder=ShapeIconEncoder.class, decoder=ShapeIconDecoder.class, loader=ShapeIconLoader.class, defaultStyleSupplier=ShapeIconDefaultStyleSupplier.class)
public class ShapeIcon
implements Icon<ShapeIcon, ShapeIconStyle> {
    private static final Map<String, ShapeIcon> ICONS_BY_CONSTANT_NAME = new HashMap<String, ShapeIcon>();
    private static final Map<String, ShapeIcon> ICONS_BY_ICON_NAME = new HashMap<String, ShapeIcon>();
    public static final ShapeIcon CIRCLE = ShapeIcon.createInternal("circle", "CIRCLE");
    public static final ShapeIcon HEXAGON = ShapeIcon.createInternal("hexagon", "HEXAGON");
    public static final ShapeIcon PENTAGON = ShapeIcon.createInternal("pentagon", "PENTAGON");
    public static final ShapeIcon SQUARE = ShapeIcon.createInternal("square", "SQUARE");
    public static final ShapeIcon TRIANGLE = ShapeIcon.createInternal("triangle", "TRIANGLE");
    private final String iconName;
    private final String constantName;
    private final ShapeIconStyle style;

    public static ShapeIcon valueOf(String constantName) {
        return ICONS_BY_CONSTANT_NAME.get(constantName);
    }

    public static ShapeIcon forName(String constantName) {
        return ICONS_BY_ICON_NAME.get(constantName);
    }

    public static Collection<ShapeIcon> allIcons() {
        return ICONS_BY_ICON_NAME.values();
    }

    private ShapeIcon(String iconName, String constantName) {
        this(iconName, constantName, null);
    }

    private ShapeIcon(String iconName, String constantName, ShapeIconStyle style) {
        this.iconName = iconName;
        this.constantName = constantName;
        this.style = style;
    }

    private static ShapeIcon createInternal(String name, String constantName) {
        ShapeIcon standardIcon = new ShapeIcon(name, constantName);
        ICONS_BY_ICON_NAME.put(name, standardIcon);
        ICONS_BY_CONSTANT_NAME.put(constantName, standardIcon);
        return standardIcon;
    }

    public String getIconName() {
        return this.iconName;
    }

    public String constantName() {
        return this.constantName;
    }

    public ShapeIcon withStyle(ShapeIconStyle style) {
        return new ShapeIcon(this.iconName, this.constantName, style);
    }

    public ShapeIconStyle getStyle() {
        return this.style;
    }

    public static ShapeIconStyleBuilder styleBuilder() {
        return ShapeIconStyle.builder();
    }
}

