/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icon.shape;

import java.util.HashMap;
import org.teamapps.common.format.Color;
import org.teamapps.icon.shape.ShapeIcon;
import org.teamapps.icon.shape.ShapeIconStyle;
import org.teamapps.icon.shape.ShapeIconStyleBuilder;
import org.teamapps.icons.IconDecoderContext;
import org.teamapps.icons.spi.IconDecoder;

public class ShapeIconDecoder
implements IconDecoder<ShapeIcon> {
    public ShapeIcon decodeIcon(String encodedIconString, IconDecoderContext context) {
        int dotIndex = encodedIconString.indexOf(40);
        if (dotIndex < 0) {
            return ShapeIcon.forName(encodedIconString);
        }
        String iconName = encodedIconString.substring(0, dotIndex);
        String encodedStyleString = encodedIconString.substring(dotIndex + 1, encodedIconString.length() - 1);
        ShapeIconStyle style = this.decodeStyle(encodedStyleString);
        return ShapeIcon.forName(iconName).withStyle(style);
    }

    private ShapeIconStyle decodeStyle(String encodedStyleString) {
        String scalingString;
        String shadowString;
        String strokeWidthString;
        String strokeColorString;
        HashMap<String, String> parameterKeyValue = this.extractStyleParameterStrings(encodedStyleString);
        ShapeIconStyleBuilder styleBuilder = ShapeIconStyle.builder();
        String fillColorString = parameterKeyValue.get("fillColor");
        if (fillColorString != null) {
            styleBuilder = styleBuilder.setFillColor(Color.fromHtmlString((String)fillColorString));
        }
        if ((strokeColorString = parameterKeyValue.get("strokeColor")) != null) {
            styleBuilder = styleBuilder.setStrokeColor(Color.fromHtmlString((String)strokeColorString));
        }
        if ((strokeWidthString = parameterKeyValue.get("strokeWidth")) != null) {
            styleBuilder = styleBuilder.setStrokeWidth(Float.parseFloat(strokeWidthString));
        }
        if ((shadowString = parameterKeyValue.get("shadow")) != null) {
            styleBuilder = styleBuilder.setShadow(Boolean.parseBoolean(shadowString));
        }
        if ((scalingString = parameterKeyValue.get("scaling")) != null) {
            styleBuilder = styleBuilder.setScaling(Float.parseFloat(scalingString));
        }
        return styleBuilder.build();
    }

    private HashMap<String, String> extractStyleParameterStrings(String encodedStyleString) {
        String[] split = encodedStyleString.split("!");
        if (split.length % 2 != 0) {
            throw new IllegalArgumentException("Illegal style string: " + encodedStyleString);
        }
        HashMap<String, String> parameterKeyValue = new HashMap<String, String>();
        for (int i = 0; i < split.length; i += 2) {
            parameterKeyValue.put(split[i], split[i + 1]);
        }
        return parameterKeyValue;
    }
}

