package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiAccordionLayout extends UiComponent implements UiObject {


	protected List<UiAccordionPanel> panels;
	protected boolean animate;
	protected boolean showAllPanels;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiAccordionLayout() {
		// default constructor for Jackson
	}

	public UiAccordionLayout(String id, List<UiAccordionPanel> panels) {
		super(id);
		this.panels = panels;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_ACCORDION_LAYOUT;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("animate=" + animate).append(", ")
				.append("showAllPanels=" + showAllPanels).append(", ")
				.append(panels != null ? "panels={" + panels.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("panels")
	public List<UiAccordionPanel> getPanels() {
		return panels;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("animate")
	public boolean getAnimate() {
		return animate;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("showAllPanels")
	public boolean getShowAllPanels() {
		return showAllPanels;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiAccordionLayout setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiAccordionLayout setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("animate")
	public UiAccordionLayout setAnimate(boolean animate) {
		this.animate = animate;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("showAllPanels")
	public UiAccordionLayout setShowAllPanels(boolean showAllPanels) {
		this.showAllPanels = showAllPanels;
		return this;
	}


	public static class AddAccordionPanelCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiAccordionPanel panel;
		protected String neighborPanelId;
		protected boolean beforeNeighbor;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddAccordionPanelCommand() {
			// default constructor for Jackson
		}

		public AddAccordionPanelCommand(String componentId, UiAccordionPanel panel, String neighborPanelId, boolean beforeNeighbor) {
			this.componentId = componentId;
			this.panel = panel;
			this.neighborPanelId = neighborPanelId;
			this.beforeNeighbor = beforeNeighbor;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("neighborPanelId=" + neighborPanelId).append(", ")
					.append("beforeNeighbor=" + beforeNeighbor).append(", ")
					.append(panel != null ? "panel={" + panel.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("panel")
		public UiAccordionPanel getPanel() {
			return panel;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("neighborPanelId")
		public String getNeighborPanelId() {
			return neighborPanelId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("beforeNeighbor")
		public boolean getBeforeNeighbor() {
			return beforeNeighbor;
		}

	}

	public static class AddAccordionPanelContentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String panelId;
		protected UiComponentReference content;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddAccordionPanelContentCommand() {
			// default constructor for Jackson
		}

		public AddAccordionPanelContentCommand(String componentId, String panelId, UiComponentReference content) {
			this.componentId = componentId;
			this.panelId = panelId;
			this.content = content;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("panelId=" + panelId).append(", ")
					.append(content != null ? "content={" + content.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("panelId")
		public String getPanelId() {
			return panelId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("content")
		public UiComponentReference getContent() {
			return content;
		}

	}

	public static class RemoveAccordionPanelCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String panelId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveAccordionPanelCommand() {
			// default constructor for Jackson
		}

		public RemoveAccordionPanelCommand(String componentId, String panelId) {
			this.componentId = componentId;
			this.panelId = panelId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("panelId=" + panelId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("panelId")
		public String getPanelId() {
			return panelId;
		}

	}

	public static class RemoveAllPanelsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveAllPanelsCommand() {
			// default constructor for Jackson
		}

		public RemoveAllPanelsCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class SelectPanelCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String panelId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SelectPanelCommand() {
			// default constructor for Jackson
		}

		public SelectPanelCommand(String componentId, String panelId) {
			this.componentId = componentId;
			this.panelId = panelId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("panelId=" + panelId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("panelId")
		public String getPanelId() {
			return panelId;
		}

	}

	public static class SetPanelOpenCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String panelId;
		protected boolean open;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetPanelOpenCommand() {
			// default constructor for Jackson
		}

		public SetPanelOpenCommand(String componentId, String panelId, boolean open) {
			this.componentId = componentId;
			this.panelId = panelId;
			this.open = open;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("panelId=" + panelId).append(", ")
					.append("open=" + open)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("panelId")
		public String getPanelId() {
			return panelId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("open")
		public boolean getOpen() {
			return open;
		}

	}




}