package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiTextCellTemplate implements UiTemplate, UiObject {

	public enum JustifyLines {
		JUSTIFY_TOP, JUSTIFY_CENTER, JUSTIFY_CENTER_OVERFLOW_BOTTOM;

		@com.fasterxml.jackson.annotation.JsonValue
		public int jsonValue() {
			return ordinal();
		}
	}

	protected UiImageTemplate imageTemplate;
	protected String imagePropertyName;
	protected UiIconPosition iconPosition = UiIconPosition.LEFT_MIDDLE;
	protected int imageSpacing = 0;
	protected int horizontalPadding = 2;
	protected int verticalPadding = 2;
	protected List<UiTextCellTemplateElement> textElements;
	protected int minHeight;
	protected int maxHeight;
	protected JustifyLines justifyLines = JustifyLines.JUSTIFY_CENTER_OVERFLOW_BOTTOM;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiTextCellTemplate() {
		// default constructor for Jackson
	}

	public UiTextCellTemplate(List<UiTextCellTemplateElement> textElements) {
		this.textElements = textElements;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_TEXT_CELL_TEMPLATE;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("imagePropertyName=" + imagePropertyName).append(", ")
				.append("iconPosition=" + iconPosition).append(", ")
				.append("imageSpacing=" + imageSpacing).append(", ")
				.append("horizontalPadding=" + horizontalPadding).append(", ")
				.append("verticalPadding=" + verticalPadding).append(", ")
				.append("minHeight=" + minHeight).append(", ")
				.append("maxHeight=" + maxHeight).append(", ")
				.append("justifyLines=" + justifyLines).append(", ")
				.append(imageTemplate != null ? "imageTemplate={" + imageTemplate.toString() + "}" : "").append(", ")
				.append(textElements != null ? "textElements={" + textElements.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("imageTemplate")
	public UiImageTemplate getImageTemplate() {
		return imageTemplate;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("imagePropertyName")
	public String getImagePropertyName() {
		return imagePropertyName;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("iconPosition")
	public UiIconPosition getIconPosition() {
		return iconPosition;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("imageSpacing")
	public int getImageSpacing() {
		return imageSpacing;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("horizontalPadding")
	public int getHorizontalPadding() {
		return horizontalPadding;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("verticalPadding")
	public int getVerticalPadding() {
		return verticalPadding;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("textElements")
	public List<UiTextCellTemplateElement> getTextElements() {
		return textElements;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("minHeight")
	public int getMinHeight() {
		return minHeight;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxHeight")
	public int getMaxHeight() {
		return maxHeight;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("justifyLines")
	public JustifyLines getJustifyLines() {
		return justifyLines;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("imageTemplate")
	public UiTextCellTemplate setImageTemplate(UiImageTemplate imageTemplate) {
		this.imageTemplate = imageTemplate;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("imagePropertyName")
	public UiTextCellTemplate setImagePropertyName(String imagePropertyName) {
		this.imagePropertyName = imagePropertyName;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("iconPosition")
	public UiTextCellTemplate setIconPosition(UiIconPosition iconPosition) {
		this.iconPosition = iconPosition;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("imageSpacing")
	public UiTextCellTemplate setImageSpacing(int imageSpacing) {
		this.imageSpacing = imageSpacing;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("horizontalPadding")
	public UiTextCellTemplate setHorizontalPadding(int horizontalPadding) {
		this.horizontalPadding = horizontalPadding;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("verticalPadding")
	public UiTextCellTemplate setVerticalPadding(int verticalPadding) {
		this.verticalPadding = verticalPadding;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("minHeight")
	public UiTextCellTemplate setMinHeight(int minHeight) {
		this.minHeight = minHeight;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("maxHeight")
	public UiTextCellTemplate setMaxHeight(int maxHeight) {
		this.maxHeight = maxHeight;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("justifyLines")
	public UiTextCellTemplate setJustifyLines(JustifyLines justifyLines) {
		this.justifyLines = justifyLines;
		return this;
	}






}