package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiTreeGraph extends UiComponent implements UiObject {


	protected List<UiTreeGraphNode> nodes;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiTreeGraph() {
		// default constructor for Jackson
	}

	public UiTreeGraph(String id, List<UiTreeGraphNode> nodes) {
		super(id);
		this.nodes = nodes;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_TREE_GRAPH;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append(nodes != null ? "nodes={" + nodes.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("nodes")
	public List<UiTreeGraphNode> getNodes() {
		return nodes;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiTreeGraph setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiTreeGraph setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	public static class HandleNodeClickEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String nodeId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public HandleNodeClickEvent() {
			// default constructor for Jackson
		}

		public HandleNodeClickEvent(String componentId, String nodeId) {
			this.componentId = componentId;
			this.nodeId = nodeId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TREE_GRAPH_HANDLE_NODE_CLICK;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("nodeId=" + nodeId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("nodeId")
		public String getNodeId() {
			return nodeId;
		}

	}

	public static class SetZoomFactorCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected float zoomFactor;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetZoomFactorCommand() {
			// default constructor for Jackson
		}

		public SetZoomFactorCommand(String componentId, float zoomFactor) {
			this.componentId = componentId;
			this.zoomFactor = zoomFactor;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("zoomFactor=" + zoomFactor)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoomFactor")
		public float getZoomFactor() {
			return zoomFactor;
		}

	}

	public static class AddNodeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiTreeGraphNode node;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddNodeCommand() {
			// default constructor for Jackson
		}

		public AddNodeCommand(String componentId, UiTreeGraphNode node) {
			this.componentId = componentId;
			this.node = node;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(node != null ? "node={" + node.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("node")
		public UiTreeGraphNode getNode() {
			return node;
		}

	}

	public static class RemoveNodeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String nodeId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveNodeCommand() {
			// default constructor for Jackson
		}

		public RemoveNodeCommand(String componentId, String nodeId) {
			this.componentId = componentId;
			this.nodeId = nodeId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("nodeId=" + nodeId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("nodeId")
		public String getNodeId() {
			return nodeId;
		}

	}

	public static class SetExpandedCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String nodeId;
		protected boolean expanded;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetExpandedCommand() {
			// default constructor for Jackson
		}

		public SetExpandedCommand(String componentId, String nodeId, boolean expanded) {
			this.componentId = componentId;
			this.nodeId = nodeId;
			this.expanded = expanded;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("nodeId=" + nodeId).append(", ")
					.append("expanded=" + expanded)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("nodeId")
		public String getNodeId() {
			return nodeId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("expanded")
		public boolean getExpanded() {
			return expanded;
		}

	}




}