package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiTreeGraphNode implements UiObject {


	protected String nodeId;
	protected String parentNodeId;
	protected int width;
	protected int height;
	protected UiColor backgroundColor = new UiColor(255, 255, 255);
	protected UiColor borderColor = new UiColor(100, 100, 100);
	protected float borderWidth = 1;
	protected float borderRadius = 0;
	protected UiTreeGraphNodeImage nodeImage;
	protected UiTreeGraphNodeIcon nodeIcon;
	protected UiTemplate template;
	protected UiClientRecord record;
	protected UiColor connectorLineColor = new UiColor(100, 100, 100);
	protected int connectorLineWidth;
	protected String dashArray;
	protected boolean expanded;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiTreeGraphNode() {
		// default constructor for Jackson
	}

	public UiTreeGraphNode(String nodeId, int width, int height) {
		this.nodeId = nodeId;
		this.width = width;
		this.height = height;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_TREE_GRAPH_NODE;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("nodeId=" + nodeId).append(", ")
				.append("parentNodeId=" + parentNodeId).append(", ")
				.append("width=" + width).append(", ")
				.append("height=" + height).append(", ")
				.append("borderWidth=" + borderWidth).append(", ")
				.append("borderRadius=" + borderRadius).append(", ")
				.append(template != null ? "template={" + template.toString() + "}" : "").append(", ")
				.append("connectorLineWidth=" + connectorLineWidth).append(", ")
				.append("dashArray=" + dashArray).append(", ")
				.append("expanded=" + expanded).append(", ")
				.append(backgroundColor != null ? "backgroundColor={" + backgroundColor.toString() + "}" : "").append(", ")
				.append(borderColor != null ? "borderColor={" + borderColor.toString() + "}" : "").append(", ")
				.append(nodeImage != null ? "nodeImage={" + nodeImage.toString() + "}" : "").append(", ")
				.append(nodeIcon != null ? "nodeIcon={" + nodeIcon.toString() + "}" : "").append(", ")
				.append(record != null ? "record={" + record.toString() + "}" : "").append(", ")
				.append(connectorLineColor != null ? "connectorLineColor={" + connectorLineColor.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("nodeId")
	public String getNodeId() {
		return nodeId;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("parentNodeId")
	public String getParentNodeId() {
		return parentNodeId;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("width")
	public int getWidth() {
		return width;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("height")
	public int getHeight() {
		return height;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public UiColor getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("borderColor")
	public UiColor getBorderColor() {
		return borderColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("borderWidth")
	public float getBorderWidth() {
		return borderWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("borderRadius")
	public float getBorderRadius() {
		return borderRadius;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("nodeImage")
	public UiTreeGraphNodeImage getNodeImage() {
		return nodeImage;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("nodeIcon")
	public UiTreeGraphNodeIcon getNodeIcon() {
		return nodeIcon;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("template")
	public UiTemplate getTemplate() {
		return template;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("record")
	public UiClientRecord getRecord() {
		return record;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("connectorLineColor")
	public UiColor getConnectorLineColor() {
		return connectorLineColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("connectorLineWidth")
	public int getConnectorLineWidth() {
		return connectorLineWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("dashArray")
	public String getDashArray() {
		return dashArray;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("expanded")
	public boolean getExpanded() {
		return expanded;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("parentNodeId")
	public UiTreeGraphNode setParentNodeId(String parentNodeId) {
		this.parentNodeId = parentNodeId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiTreeGraphNode setBackgroundColor(UiColor backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("borderColor")
	public UiTreeGraphNode setBorderColor(UiColor borderColor) {
		this.borderColor = borderColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("borderWidth")
	public UiTreeGraphNode setBorderWidth(float borderWidth) {
		this.borderWidth = borderWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("borderRadius")
	public UiTreeGraphNode setBorderRadius(float borderRadius) {
		this.borderRadius = borderRadius;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("nodeImage")
	public UiTreeGraphNode setNodeImage(UiTreeGraphNodeImage nodeImage) {
		this.nodeImage = nodeImage;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("nodeIcon")
	public UiTreeGraphNode setNodeIcon(UiTreeGraphNodeIcon nodeIcon) {
		this.nodeIcon = nodeIcon;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("template")
	public UiTreeGraphNode setTemplate(UiTemplate template) {
		this.template = template;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("record")
	public UiTreeGraphNode setRecord(UiClientRecord record) {
		this.record = record;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("connectorLineColor")
	public UiTreeGraphNode setConnectorLineColor(UiColor connectorLineColor) {
		this.connectorLineColor = connectorLineColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("connectorLineWidth")
	public UiTreeGraphNode setConnectorLineWidth(int connectorLineWidth) {
		this.connectorLineWidth = connectorLineWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("dashArray")
	public UiTreeGraphNode setDashArray(String dashArray) {
		this.dashArray = dashArray;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("expanded")
	public UiTreeGraphNode setExpanded(boolean expanded) {
		this.expanded = expanded;
		return this;
	}






}