package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiWorkSpaceLayout extends UiComponent implements UiObject {


	protected List<UiWorkSpaceLayoutView> views;
	protected UiWorkSpaceLayoutItem initialLayout;
	protected String childWindowPageTitle;
	protected UiComponentReference toolbar;
	protected String newWindowBackgroundImage;
	protected String newWindowBlurredBackgroundImage;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiWorkSpaceLayout() {
		// default constructor for Jackson
	}

	public UiWorkSpaceLayout(String id, List<UiWorkSpaceLayoutView> views, UiWorkSpaceLayoutItem initialLayout, String childWindowPageTitle) {
		super(id);
		this.views = views;
		this.initialLayout = initialLayout;
		this.childWindowPageTitle = childWindowPageTitle;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_WORK_SPACE_LAYOUT;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("childWindowPageTitle=" + childWindowPageTitle).append(", ")
				.append("newWindowBackgroundImage=" + newWindowBackgroundImage).append(", ")
				.append("newWindowBlurredBackgroundImage=" + newWindowBlurredBackgroundImage).append(", ")
				.append(views != null ? "views={" + views.toString() + "}" : "").append(", ")
				.append(initialLayout != null ? "initialLayout={" + initialLayout.toString() + "}" : "").append(", ")
				.append(toolbar != null ? "toolbar={" + toolbar.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("views")
	public List<UiWorkSpaceLayoutView> getViews() {
		return views;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("initialLayout")
	public UiWorkSpaceLayoutItem getInitialLayout() {
		return initialLayout;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("childWindowPageTitle")
	public String getChildWindowPageTitle() {
		return childWindowPageTitle;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("toolbar")
	public UiComponentReference getToolbar() {
		return toolbar;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("newWindowBackgroundImage")
	public String getNewWindowBackgroundImage() {
		return newWindowBackgroundImage;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("newWindowBlurredBackgroundImage")
	public String getNewWindowBlurredBackgroundImage() {
		return newWindowBlurredBackgroundImage;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiWorkSpaceLayout setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiWorkSpaceLayout setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("toolbar")
	public UiWorkSpaceLayout setToolbar(UiComponentReference toolbar) {
		this.toolbar = toolbar;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("newWindowBackgroundImage")
	public UiWorkSpaceLayout setNewWindowBackgroundImage(String newWindowBackgroundImage) {
		this.newWindowBackgroundImage = newWindowBackgroundImage;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("newWindowBlurredBackgroundImage")
	public UiWorkSpaceLayout setNewWindowBlurredBackgroundImage(String newWindowBlurredBackgroundImage) {
		this.newWindowBlurredBackgroundImage = newWindowBlurredBackgroundImage;
		return this;
	}

	public static class LayoutChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected Map<String, UiWorkSpaceLayoutItem> layoutsByWindowId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public LayoutChangedEvent() {
			// default constructor for Jackson
		}

		public LayoutChangedEvent(String componentId, Map<String, UiWorkSpaceLayoutItem> layoutsByWindowId) {
			this.componentId = componentId;
			this.layoutsByWindowId = layoutsByWindowId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_WORK_SPACE_LAYOUT_LAYOUT_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(layoutsByWindowId != null ? "layoutsByWindowId={" + layoutsByWindowId.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("layoutsByWindowId")
		public Map<String, UiWorkSpaceLayoutItem> getLayoutsByWindowId() {
			return layoutsByWindowId;
		}

	}

	public static class ViewDraggedToNewWindowEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String windowId;
		protected String viewName;
		protected Map<String, UiWorkSpaceLayoutItem> layoutsByWindowId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ViewDraggedToNewWindowEvent() {
			// default constructor for Jackson
		}

		public ViewDraggedToNewWindowEvent(String componentId, String windowId, String viewName, Map<String, UiWorkSpaceLayoutItem> layoutsByWindowId) {
			this.componentId = componentId;
			this.windowId = windowId;
			this.viewName = viewName;
			this.layoutsByWindowId = layoutsByWindowId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_WORK_SPACE_LAYOUT_VIEW_DRAGGED_TO_NEW_WINDOW;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("windowId=" + windowId).append(", ")
					.append(layoutsByWindowId != null ? "layoutsByWindowId={" + layoutsByWindowId.toString() + "}" : "").append(", ")
					.append("viewName=" + viewName)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("windowId")
		public String getWindowId() {
			return windowId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewName")
		public String getViewName() {
			return viewName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("layoutsByWindowId")
		public Map<String, UiWorkSpaceLayoutItem> getLayoutsByWindowId() {
			return layoutsByWindowId;
		}

	}

	public static class ViewNeedsRefreshEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String viewName;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ViewNeedsRefreshEvent() {
			// default constructor for Jackson
		}

		public ViewNeedsRefreshEvent(String componentId, String viewName) {
			this.componentId = componentId;
			this.viewName = viewName;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_WORK_SPACE_LAYOUT_VIEW_NEEDS_REFRESH;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("viewName=" + viewName)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewName")
		public String getViewName() {
			return viewName;
		}

	}

	public static class ChildWindowCreationFailedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String viewName;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ChildWindowCreationFailedEvent() {
			// default constructor for Jackson
		}

		public ChildWindowCreationFailedEvent(String componentId, String viewName) {
			this.componentId = componentId;
			this.viewName = viewName;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_WORK_SPACE_LAYOUT_CHILD_WINDOW_CREATION_FAILED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("viewName=" + viewName)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewName")
		public String getViewName() {
			return viewName;
		}

	}

	public static class ChildWindowClosedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String windowId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ChildWindowClosedEvent() {
			// default constructor for Jackson
		}

		public ChildWindowClosedEvent(String componentId, String windowId) {
			this.componentId = componentId;
			this.windowId = windowId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_WORK_SPACE_LAYOUT_CHILD_WINDOW_CLOSED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("windowId=" + windowId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("windowId")
		public String getWindowId() {
			return windowId;
		}

	}

	public static class ViewSelectedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String viewGroupId;
		protected String viewName;
		protected List<String> siblingViewNames;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ViewSelectedEvent() {
			// default constructor for Jackson
		}

		public ViewSelectedEvent(String componentId, String viewGroupId, String viewName, List<String> siblingViewNames) {
			this.componentId = componentId;
			this.viewGroupId = viewGroupId;
			this.viewName = viewName;
			this.siblingViewNames = siblingViewNames;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_WORK_SPACE_LAYOUT_VIEW_SELECTED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("viewGroupId=" + viewGroupId).append(", ")
					.append("viewName=" + viewName).append(", ")
					.append("siblingViewNames=" + siblingViewNames)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewGroupId")
		public String getViewGroupId() {
			return viewGroupId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewName")
		public String getViewName() {
			return viewName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("siblingViewNames")
		public List<String> getSiblingViewNames() {
			return siblingViewNames;
		}

	}

	public static class ViewClosedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String viewName;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ViewClosedEvent() {
			// default constructor for Jackson
		}

		public ViewClosedEvent(String componentId, String viewName) {
			this.componentId = componentId;
			this.viewName = viewName;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_WORK_SPACE_LAYOUT_VIEW_CLOSED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("viewName=" + viewName)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewName")
		public String getViewName() {
			return viewName;
		}

	}

	public static class ViewGroupPanelStateChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String viewGroupId;
		protected UiViewGroupPanelState panelState;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ViewGroupPanelStateChangedEvent() {
			// default constructor for Jackson
		}

		public ViewGroupPanelStateChangedEvent(String componentId, String viewGroupId, UiViewGroupPanelState panelState) {
			this.componentId = componentId;
			this.viewGroupId = viewGroupId;
			this.panelState = panelState;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_WORK_SPACE_LAYOUT_VIEW_GROUP_PANEL_STATE_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("viewGroupId=" + viewGroupId).append(", ")
					.append("panelState=" + panelState)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewGroupId")
		public String getViewGroupId() {
			return viewGroupId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("panelState")
		public UiViewGroupPanelState getPanelState() {
			return panelState;
		}

	}

	public static class SetToolbarCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiComponentReference toolbar;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetToolbarCommand() {
			// default constructor for Jackson
		}

		public SetToolbarCommand(String componentId, UiComponentReference toolbar) {
			this.componentId = componentId;
			this.toolbar = toolbar;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(toolbar != null ? "toolbar={" + toolbar.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("toolbar")
		public UiComponentReference getToolbar() {
			return toolbar;
		}

	}

	public static class AddViewAsTabCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiWorkSpaceLayoutView newView;
		protected String viewGroupId;
		protected boolean select;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddViewAsTabCommand() {
			// default constructor for Jackson
		}

		public AddViewAsTabCommand(String componentId, UiWorkSpaceLayoutView newView, String viewGroupId, boolean select) {
			this.componentId = componentId;
			this.newView = newView;
			this.viewGroupId = viewGroupId;
			this.select = select;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("viewGroupId=" + viewGroupId).append(", ")
					.append("select=" + select).append(", ")
					.append(newView != null ? "newView={" + newView.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("newView")
		public UiWorkSpaceLayoutView getNewView() {
			return newView;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewGroupId")
		public String getViewGroupId() {
			return viewGroupId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("select")
		public boolean getSelect() {
			return select;
		}

	}

	public static class AddViewAsNeighbourTabCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiWorkSpaceLayoutView newView;
		protected String existingViewName;
		protected boolean select;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddViewAsNeighbourTabCommand() {
			// default constructor for Jackson
		}

		public AddViewAsNeighbourTabCommand(String componentId, UiWorkSpaceLayoutView newView, String existingViewName, boolean select) {
			this.componentId = componentId;
			this.newView = newView;
			this.existingViewName = existingViewName;
			this.select = select;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("existingViewName=" + existingViewName).append(", ")
					.append("select=" + select).append(", ")
					.append(newView != null ? "newView={" + newView.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("newView")
		public UiWorkSpaceLayoutView getNewView() {
			return newView;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("existingViewName")
		public String getExistingViewName() {
			return existingViewName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("select")
		public boolean getSelect() {
			return select;
		}

	}

	public static class AddViewRelativeToOtherViewCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiWorkSpaceLayoutView newView;
		protected String existingViewName;
		protected UiRelativeWorkSpaceViewPosition relativePosition;
		protected UiSplitSizePolicy sizePolicy;
		protected float referenceChildSize;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddViewRelativeToOtherViewCommand() {
			// default constructor for Jackson
		}

		public AddViewRelativeToOtherViewCommand(String componentId, UiWorkSpaceLayoutView newView, String existingViewName, UiRelativeWorkSpaceViewPosition relativePosition, UiSplitSizePolicy sizePolicy, float referenceChildSize) {
			this.componentId = componentId;
			this.newView = newView;
			this.existingViewName = existingViewName;
			this.relativePosition = relativePosition;
			this.sizePolicy = sizePolicy;
			this.referenceChildSize = referenceChildSize;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("existingViewName=" + existingViewName).append(", ")
					.append("relativePosition=" + relativePosition).append(", ")
					.append("sizePolicy=" + sizePolicy).append(", ")
					.append("referenceChildSize=" + referenceChildSize).append(", ")
					.append(newView != null ? "newView={" + newView.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("newView")
		public UiWorkSpaceLayoutView getNewView() {
			return newView;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("existingViewName")
		public String getExistingViewName() {
			return existingViewName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("relativePosition")
		public UiRelativeWorkSpaceViewPosition getRelativePosition() {
			return relativePosition;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizePolicy")
		public UiSplitSizePolicy getSizePolicy() {
			return sizePolicy;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("referenceChildSize")
		public float getReferenceChildSize() {
			return referenceChildSize;
		}

	}

	public static class AddViewToTopLevelCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiWorkSpaceLayoutView newView;
		protected String windowId;
		protected UiRelativeWorkSpaceViewPosition relativePosition;
		protected UiSplitSizePolicy sizePolicy;
		protected float referenceChildSize;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddViewToTopLevelCommand() {
			// default constructor for Jackson
		}

		public AddViewToTopLevelCommand(String componentId, UiWorkSpaceLayoutView newView, String windowId, UiRelativeWorkSpaceViewPosition relativePosition, UiSplitSizePolicy sizePolicy, float referenceChildSize) {
			this.componentId = componentId;
			this.newView = newView;
			this.windowId = windowId;
			this.relativePosition = relativePosition;
			this.sizePolicy = sizePolicy;
			this.referenceChildSize = referenceChildSize;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("windowId=" + windowId).append(", ")
					.append("relativePosition=" + relativePosition).append(", ")
					.append("sizePolicy=" + sizePolicy).append(", ")
					.append("referenceChildSize=" + referenceChildSize).append(", ")
					.append(newView != null ? "newView={" + newView.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("newView")
		public UiWorkSpaceLayoutView getNewView() {
			return newView;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("windowId")
		public String getWindowId() {
			return windowId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("relativePosition")
		public UiRelativeWorkSpaceViewPosition getRelativePosition() {
			return relativePosition;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizePolicy")
		public UiSplitSizePolicy getSizePolicy() {
			return sizePolicy;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("referenceChildSize")
		public float getReferenceChildSize() {
			return referenceChildSize;
		}

	}

	public static class MoveViewToNeighbourTabCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String viewName;
		protected String existingViewName;
		protected boolean select;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public MoveViewToNeighbourTabCommand() {
			// default constructor for Jackson
		}

		public MoveViewToNeighbourTabCommand(String componentId, String viewName, String existingViewName, boolean select) {
			this.componentId = componentId;
			this.viewName = viewName;
			this.existingViewName = existingViewName;
			this.select = select;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("viewName=" + viewName).append(", ")
					.append("existingViewName=" + existingViewName).append(", ")
					.append("select=" + select)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewName")
		public String getViewName() {
			return viewName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("existingViewName")
		public String getExistingViewName() {
			return existingViewName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("select")
		public boolean getSelect() {
			return select;
		}

	}

	public static class MoveViewRelativeToOtherViewCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String viewName;
		protected String existingViewName;
		protected UiRelativeWorkSpaceViewPosition relativePosition;
		protected UiSplitSizePolicy sizePolicy;
		protected float referenceChildSize;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public MoveViewRelativeToOtherViewCommand() {
			// default constructor for Jackson
		}

		public MoveViewRelativeToOtherViewCommand(String componentId, String viewName, String existingViewName, UiRelativeWorkSpaceViewPosition relativePosition, UiSplitSizePolicy sizePolicy, float referenceChildSize) {
			this.componentId = componentId;
			this.viewName = viewName;
			this.existingViewName = existingViewName;
			this.relativePosition = relativePosition;
			this.sizePolicy = sizePolicy;
			this.referenceChildSize = referenceChildSize;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("viewName=" + viewName).append(", ")
					.append("existingViewName=" + existingViewName).append(", ")
					.append("relativePosition=" + relativePosition).append(", ")
					.append("sizePolicy=" + sizePolicy).append(", ")
					.append("referenceChildSize=" + referenceChildSize)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewName")
		public String getViewName() {
			return viewName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("existingViewName")
		public String getExistingViewName() {
			return existingViewName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("relativePosition")
		public UiRelativeWorkSpaceViewPosition getRelativePosition() {
			return relativePosition;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizePolicy")
		public UiSplitSizePolicy getSizePolicy() {
			return sizePolicy;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("referenceChildSize")
		public float getReferenceChildSize() {
			return referenceChildSize;
		}

	}

	public static class MoveViewToTopLevelCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String viewName;
		protected String windowId;
		protected UiRelativeWorkSpaceViewPosition relativePosition;
		protected UiSplitSizePolicy sizePolicy;
		protected float referenceChildSize;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public MoveViewToTopLevelCommand() {
			// default constructor for Jackson
		}

		public MoveViewToTopLevelCommand(String componentId, String viewName, String windowId, UiRelativeWorkSpaceViewPosition relativePosition, UiSplitSizePolicy sizePolicy, float referenceChildSize) {
			this.componentId = componentId;
			this.viewName = viewName;
			this.windowId = windowId;
			this.relativePosition = relativePosition;
			this.sizePolicy = sizePolicy;
			this.referenceChildSize = referenceChildSize;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("windowId=" + windowId).append(", ")
					.append("viewName=" + viewName).append(", ")
					.append("relativePosition=" + relativePosition).append(", ")
					.append("sizePolicy=" + sizePolicy).append(", ")
					.append("referenceChildSize=" + referenceChildSize)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewName")
		public String getViewName() {
			return viewName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("windowId")
		public String getWindowId() {
			return windowId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("relativePosition")
		public UiRelativeWorkSpaceViewPosition getRelativePosition() {
			return relativePosition;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizePolicy")
		public UiSplitSizePolicy getSizePolicy() {
			return sizePolicy;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("referenceChildSize")
		public float getReferenceChildSize() {
			return referenceChildSize;
		}

	}

	public static class RedefineLayoutCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected Map<String, UiWorkSpaceLayoutItem> layoutsByWindowId;
		protected List<UiWorkSpaceLayoutView> addedViews;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RedefineLayoutCommand() {
			// default constructor for Jackson
		}

		public RedefineLayoutCommand(String componentId, Map<String, UiWorkSpaceLayoutItem> layoutsByWindowId, List<UiWorkSpaceLayoutView> addedViews) {
			this.componentId = componentId;
			this.layoutsByWindowId = layoutsByWindowId;
			this.addedViews = addedViews;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(layoutsByWindowId != null ? "layoutsByWindowId={" + layoutsByWindowId.toString() + "}" : "").append(", ")
					.append(addedViews != null ? "addedViews={" + addedViews.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("layoutsByWindowId")
		public Map<String, UiWorkSpaceLayoutItem> getLayoutsByWindowId() {
			return layoutsByWindowId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("addedViews")
		public List<UiWorkSpaceLayoutView> getAddedViews() {
			return addedViews;
		}

	}

	public static class RemoveViewCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String viewName;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveViewCommand() {
			// default constructor for Jackson
		}

		public RemoveViewCommand(String componentId, String viewName) {
			this.componentId = componentId;
			this.viewName = viewName;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("viewName=" + viewName)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewName")
		public String getViewName() {
			return viewName;
		}

	}

	public static class RefreshViewAttributesCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String viewName;
		protected String tabIcon;
		protected String tabCaption;
		protected boolean tabCloseable;
		protected boolean visible;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RefreshViewAttributesCommand() {
			// default constructor for Jackson
		}

		public RefreshViewAttributesCommand(String componentId, String viewName, String tabIcon, String tabCaption, boolean tabCloseable, boolean visible) {
			this.componentId = componentId;
			this.viewName = viewName;
			this.tabIcon = tabIcon;
			this.tabCaption = tabCaption;
			this.tabCloseable = tabCloseable;
			this.visible = visible;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("viewName=" + viewName).append(", ")
					.append("tabIcon=" + tabIcon).append(", ")
					.append("tabCaption=" + tabCaption).append(", ")
					.append("tabCloseable=" + tabCloseable).append(", ")
					.append("visible=" + visible)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewName")
		public String getViewName() {
			return viewName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("tabIcon")
		public String getTabIcon() {
			return tabIcon;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("tabCaption")
		public String getTabCaption() {
			return tabCaption;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("tabCloseable")
		public boolean getTabCloseable() {
			return tabCloseable;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("visible")
		public boolean getVisible() {
			return visible;
		}

	}

	public static class RefreshViewComponentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String viewName;
		protected UiComponentReference component;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RefreshViewComponentCommand() {
			// default constructor for Jackson
		}

		public RefreshViewComponentCommand(String componentId, String viewName, UiComponentReference component) {
			this.componentId = componentId;
			this.viewName = viewName;
			this.component = component;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("viewName=" + viewName).append(", ")
					.append(component != null ? "component={" + component.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewName")
		public String getViewName() {
			return viewName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("component")
		public UiComponentReference getComponent() {
			return component;
		}

	}

	public static class SelectViewCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String viewName;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SelectViewCommand() {
			// default constructor for Jackson
		}

		public SelectViewCommand(String componentId, String viewName) {
			this.componentId = componentId;
			this.viewName = viewName;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("viewName=" + viewName)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewName")
		public String getViewName() {
			return viewName;
		}

	}

	public static class SetViewGroupPanelStateCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String viewGroupId;
		protected UiViewGroupPanelState panelState;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetViewGroupPanelStateCommand() {
			// default constructor for Jackson
		}

		public SetViewGroupPanelStateCommand(String componentId, String viewGroupId, UiViewGroupPanelState panelState) {
			this.componentId = componentId;
			this.viewGroupId = viewGroupId;
			this.panelState = panelState;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("viewGroupId=" + viewGroupId).append(", ")
					.append("panelState=" + panelState)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewGroupId")
		public String getViewGroupId() {
			return viewGroupId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("panelState")
		public UiViewGroupPanelState getPanelState() {
			return panelState;
		}

	}




}