/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiChartLegendStyle;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AbstractUiChart
extends UiComponent
implements UiObject {
    protected long initialAnimationDuration = 200L;
    protected UiChartLegendStyle legendStyle = UiChartLegendStyle.INLINE;

    @Deprecated
    public AbstractUiChart() {
    }

    public AbstractUiChart(String id) {
        super(id);
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.ABSTRACT_UI_CHART;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("initialAnimationDuration=" + this.initialAnimationDuration) + ", " + ("legendStyle=" + this.legendStyle);
    }

    @JsonGetter(value="initialAnimationDuration")
    public long getInitialAnimationDuration() {
        return this.initialAnimationDuration;
    }

    @JsonGetter(value="legendStyle")
    public UiChartLegendStyle getLegendStyle() {
        return this.legendStyle;
    }

    @Override
    @JsonSetter(value="visible")
    public AbstractUiChart setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public AbstractUiChart setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="initialAnimationDuration")
    public AbstractUiChart setInitialAnimationDuration(long initialAnimationDuration) {
        this.initialAnimationDuration = initialAnimationDuration;
        return this;
    }

    @JsonSetter(value="legendStyle")
    public AbstractUiChart setLegendStyle(UiChartLegendStyle legendStyle) {
        this.legendStyle = legendStyle;
        return this;
    }

    public static class SetLegendStyleCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiChartLegendStyle legendStyle;

        @Deprecated
        public SetLegendStyleCommand() {
        }

        public SetLegendStyleCommand(String componentId, UiChartLegendStyle legendStyle) {
            this.componentId = componentId;
            this.legendStyle = legendStyle;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("legendStyle=" + this.legendStyle);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="legendStyle")
        public UiChartLegendStyle getLegendStyle() {
            return this.legendStyle;
        }
    }
}

