/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiIdentifiableClientRecord;
import org.teamapps.dto.UiItemJustification;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTemplate;
import org.teamapps.dto.UiVerticalItemAlignment;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiInfiniteItemView
extends UiComponent
implements UiObject {
    protected UiTemplate itemTemplate;
    protected float itemWidth = 0.0f;
    protected int rowHeight;
    protected List<UiIdentifiableClientRecord> data;
    protected int totalNumberOfRecords = 0;
    protected int horizontalItemMargin = 0;
    protected UiItemJustification itemJustification = UiItemJustification.LEFT;
    protected UiVerticalItemAlignment verticalItemAlignment = UiVerticalItemAlignment.STRETCH;

    @Deprecated
    public UiInfiniteItemView() {
    }

    public UiInfiniteItemView(String id, UiTemplate itemTemplate, int rowHeight) {
        super(id);
        this.itemTemplate = itemTemplate;
        this.rowHeight = rowHeight;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_INFINITE_ITEM_VIEW;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + (String)(this.itemTemplate != null ? "itemTemplate={" + this.itemTemplate.toString() + "}" : "") + ", " + ("itemWidth=" + this.itemWidth) + ", " + ("rowHeight=" + this.rowHeight) + ", " + ("totalNumberOfRecords=" + this.totalNumberOfRecords) + ", " + ("horizontalItemMargin=" + this.horizontalItemMargin) + ", " + ("itemJustification=" + this.itemJustification) + ", " + ("verticalItemAlignment=" + this.verticalItemAlignment) + ", " + (String)(this.data != null ? "data={" + this.data.toString() + "}" : "");
    }

    @JsonGetter(value="itemTemplate")
    public UiTemplate getItemTemplate() {
        return this.itemTemplate;
    }

    @JsonGetter(value="itemWidth")
    public float getItemWidth() {
        return this.itemWidth;
    }

    @JsonGetter(value="rowHeight")
    public int getRowHeight() {
        return this.rowHeight;
    }

    @JsonGetter(value="data")
    public List<UiIdentifiableClientRecord> getData() {
        return this.data;
    }

    @JsonGetter(value="totalNumberOfRecords")
    public int getTotalNumberOfRecords() {
        return this.totalNumberOfRecords;
    }

    @JsonGetter(value="horizontalItemMargin")
    public int getHorizontalItemMargin() {
        return this.horizontalItemMargin;
    }

    @JsonGetter(value="itemJustification")
    public UiItemJustification getItemJustification() {
        return this.itemJustification;
    }

    @JsonGetter(value="verticalItemAlignment")
    public UiVerticalItemAlignment getVerticalItemAlignment() {
        return this.verticalItemAlignment;
    }

    @Override
    @JsonSetter(value="visible")
    public UiInfiniteItemView setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiInfiniteItemView setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="itemWidth")
    public UiInfiniteItemView setItemWidth(float itemWidth) {
        this.itemWidth = itemWidth;
        return this;
    }

    @JsonSetter(value="data")
    public UiInfiniteItemView setData(List<UiIdentifiableClientRecord> data) {
        this.data = data;
        return this;
    }

    @JsonSetter(value="totalNumberOfRecords")
    public UiInfiniteItemView setTotalNumberOfRecords(int totalNumberOfRecords) {
        this.totalNumberOfRecords = totalNumberOfRecords;
        return this;
    }

    @JsonSetter(value="horizontalItemMargin")
    public UiInfiniteItemView setHorizontalItemMargin(int horizontalItemMargin) {
        this.horizontalItemMargin = horizontalItemMargin;
        return this;
    }

    @JsonSetter(value="itemJustification")
    public UiInfiniteItemView setItemJustification(UiItemJustification itemJustification) {
        this.itemJustification = itemJustification;
        return this;
    }

    @JsonSetter(value="verticalItemAlignment")
    public UiInfiniteItemView setVerticalItemAlignment(UiVerticalItemAlignment verticalItemAlignment) {
        this.verticalItemAlignment = verticalItemAlignment;
        return this;
    }

    public static class SetVerticalItemAlignmentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiVerticalItemAlignment verticalItemAlignment;

        @Deprecated
        public SetVerticalItemAlignmentCommand() {
        }

        public SetVerticalItemAlignmentCommand(String componentId, UiVerticalItemAlignment verticalItemAlignment) {
            this.componentId = componentId;
            this.verticalItemAlignment = verticalItemAlignment;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("verticalItemAlignment=" + this.verticalItemAlignment);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="verticalItemAlignment")
        public UiVerticalItemAlignment getVerticalItemAlignment() {
            return this.verticalItemAlignment;
        }
    }

    public static class SetItemJustificationCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiItemJustification itemJustification;

        @Deprecated
        public SetItemJustificationCommand() {
        }

        public SetItemJustificationCommand(String componentId, UiItemJustification itemJustification) {
            this.componentId = componentId;
            this.itemJustification = itemJustification;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("itemJustification=" + this.itemJustification);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="itemJustification")
        public UiItemJustification getItemJustification() {
            return this.itemJustification;
        }
    }

    public static class SetHorizontalItemMarginCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int horizontalItemMargin;

        @Deprecated
        public SetHorizontalItemMarginCommand() {
        }

        public SetHorizontalItemMarginCommand(String componentId, int horizontalItemMargin) {
            this.componentId = componentId;
            this.horizontalItemMargin = horizontalItemMargin;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("horizontalItemMargin=" + this.horizontalItemMargin);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="horizontalItemMargin")
        public int getHorizontalItemMargin() {
            return this.horizontalItemMargin;
        }
    }

    public static class SetItemWidthCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected float itemWidth;

        @Deprecated
        public SetItemWidthCommand() {
        }

        public SetItemWidthCommand(String componentId, float itemWidth) {
            this.componentId = componentId;
            this.itemWidth = itemWidth;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("itemWidth=" + this.itemWidth);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="itemWidth")
        public float getItemWidth() {
            return this.itemWidth;
        }
    }

    public static class SetItemTemplateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiTemplate itemTemplate;

        @Deprecated
        public SetItemTemplateCommand() {
        }

        public SetItemTemplateCommand(String componentId, UiTemplate itemTemplate) {
            this.componentId = componentId;
            this.itemTemplate = itemTemplate;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.itemTemplate != null ? "itemTemplate={" + this.itemTemplate.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="itemTemplate")
        public UiTemplate getItemTemplate() {
            return this.itemTemplate;
        }
    }

    public static class RemoveDataCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<Integer> ids;

        @Deprecated
        public RemoveDataCommand() {
        }

        public RemoveDataCommand(String componentId, List<Integer> ids) {
            this.componentId = componentId;
            this.ids = ids;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("ids=" + this.ids);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="ids")
        public List<Integer> getIds() {
            return this.ids;
        }
    }

    public static class AddDataCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int startIndex;
        protected List<UiIdentifiableClientRecord> data;
        protected int totalNumberOfRecords;
        protected boolean clear;

        @Deprecated
        public AddDataCommand() {
        }

        public AddDataCommand(String componentId, int startIndex, List<UiIdentifiableClientRecord> data, int totalNumberOfRecords, boolean clear) {
            this.componentId = componentId;
            this.startIndex = startIndex;
            this.data = data;
            this.totalNumberOfRecords = totalNumberOfRecords;
            this.clear = clear;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("startIndex=" + this.startIndex) + ", " + ("totalNumberOfRecords=" + this.totalNumberOfRecords) + ", " + ("clear=" + this.clear) + ", " + (String)(this.data != null ? "data={" + this.data.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="startIndex")
        public int getStartIndex() {
            return this.startIndex;
        }

        @JsonGetter(value="data")
        public List<UiIdentifiableClientRecord> getData() {
            return this.data;
        }

        @JsonGetter(value="totalNumberOfRecords")
        public int getTotalNumberOfRecords() {
            return this.totalNumberOfRecords;
        }

        @JsonGetter(value="clear")
        public boolean getClear() {
            return this.clear;
        }
    }

    public static class ItemClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int recordId;
        protected boolean isRightMouseButton;
        protected boolean isDoubleClick;

        @Deprecated
        public ItemClickedEvent() {
        }

        public ItemClickedEvent(String componentId, int recordId, boolean isRightMouseButton, boolean isDoubleClick) {
            this.componentId = componentId;
            this.recordId = recordId;
            this.isRightMouseButton = isRightMouseButton;
            this.isDoubleClick = isDoubleClick;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_INFINITE_ITEM_VIEW_ITEM_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordId=" + this.recordId) + ", " + ("isRightMouseButton=" + this.isRightMouseButton) + ", " + ("isDoubleClick=" + this.isDoubleClick);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="recordId")
        public int getRecordId() {
            return this.recordId;
        }

        @JsonGetter(value="isRightMouseButton")
        public boolean getIsRightMouseButton() {
            return this.isRightMouseButton;
        }

        @JsonGetter(value="isDoubleClick")
        public boolean getIsDoubleClick() {
            return this.isDoubleClick;
        }
    }

    public static class DataRequestEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int startIndex;
        protected int length;

        @Deprecated
        public DataRequestEvent() {
        }

        public DataRequestEvent(String componentId, int startIndex, int length) {
            this.componentId = componentId;
            this.startIndex = startIndex;
            this.length = length;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_INFINITE_ITEM_VIEW_DATA_REQUEST;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("startIndex=" + this.startIndex) + ", " + ("length=" + this.length);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="startIndex")
        public int getStartIndex() {
            return this.startIndex;
        }

        @JsonGetter(value="length")
        public int getLength() {
            return this.length;
        }
    }
}

