/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiClientRecord;
import org.teamapps.dto.UiColor;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTemplate;
import org.teamapps.dto.UiTreeGraphNodeIcon;
import org.teamapps.dto.UiTreeGraphNodeImage;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiTreeGraphNode
implements UiObject {
    protected String nodeId;
    protected String parentNodeId;
    protected int width;
    protected int height;
    protected UiColor backgroundColor = new UiColor(255, 255, 255);
    protected UiColor borderColor = new UiColor(100, 100, 100);
    protected float borderWidth = 1.0f;
    protected float borderRadius = 0.0f;
    protected UiTreeGraphNodeImage nodeImage;
    protected UiTreeGraphNodeIcon nodeIcon;
    protected UiTemplate template;
    protected UiClientRecord record;
    protected UiColor connectorLineColor = new UiColor(100, 100, 100);
    protected int connectorLineWidth;
    protected String dashArray;
    protected boolean expanded;

    @Deprecated
    public UiTreeGraphNode() {
    }

    public UiTreeGraphNode(String nodeId, int width, int height) {
        this.nodeId = nodeId;
        this.width = width;
        this.height = height;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_TREE_GRAPH_NODE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("nodeId=" + this.nodeId) + ", " + ("parentNodeId=" + this.parentNodeId) + ", " + ("width=" + this.width) + ", " + ("height=" + this.height) + ", " + ("borderWidth=" + this.borderWidth) + ", " + ("borderRadius=" + this.borderRadius) + ", " + (String)(this.template != null ? "template={" + this.template.toString() + "}" : "") + ", " + ("connectorLineWidth=" + this.connectorLineWidth) + ", " + ("dashArray=" + this.dashArray) + ", " + ("expanded=" + this.expanded) + ", " + (String)(this.backgroundColor != null ? "backgroundColor={" + this.backgroundColor.toString() + "}" : "") + ", " + (String)(this.borderColor != null ? "borderColor={" + this.borderColor.toString() + "}" : "") + ", " + (String)(this.nodeImage != null ? "nodeImage={" + this.nodeImage.toString() + "}" : "") + ", " + (String)(this.nodeIcon != null ? "nodeIcon={" + this.nodeIcon.toString() + "}" : "") + ", " + (String)(this.record != null ? "record={" + this.record.toString() + "}" : "") + ", " + (String)(this.connectorLineColor != null ? "connectorLineColor={" + this.connectorLineColor.toString() + "}" : "");
    }

    @JsonGetter(value="nodeId")
    public String getNodeId() {
        return this.nodeId;
    }

    @JsonGetter(value="parentNodeId")
    public String getParentNodeId() {
        return this.parentNodeId;
    }

    @JsonGetter(value="width")
    public int getWidth() {
        return this.width;
    }

    @JsonGetter(value="height")
    public int getHeight() {
        return this.height;
    }

    @JsonGetter(value="backgroundColor")
    public UiColor getBackgroundColor() {
        return this.backgroundColor;
    }

    @JsonGetter(value="borderColor")
    public UiColor getBorderColor() {
        return this.borderColor;
    }

    @JsonGetter(value="borderWidth")
    public float getBorderWidth() {
        return this.borderWidth;
    }

    @JsonGetter(value="borderRadius")
    public float getBorderRadius() {
        return this.borderRadius;
    }

    @JsonGetter(value="nodeImage")
    public UiTreeGraphNodeImage getNodeImage() {
        return this.nodeImage;
    }

    @JsonGetter(value="nodeIcon")
    public UiTreeGraphNodeIcon getNodeIcon() {
        return this.nodeIcon;
    }

    @JsonGetter(value="template")
    public UiTemplate getTemplate() {
        return this.template;
    }

    @JsonGetter(value="record")
    public UiClientRecord getRecord() {
        return this.record;
    }

    @JsonGetter(value="connectorLineColor")
    public UiColor getConnectorLineColor() {
        return this.connectorLineColor;
    }

    @JsonGetter(value="connectorLineWidth")
    public int getConnectorLineWidth() {
        return this.connectorLineWidth;
    }

    @JsonGetter(value="dashArray")
    public String getDashArray() {
        return this.dashArray;
    }

    @JsonGetter(value="expanded")
    public boolean getExpanded() {
        return this.expanded;
    }

    @JsonSetter(value="parentNodeId")
    public UiTreeGraphNode setParentNodeId(String parentNodeId) {
        this.parentNodeId = parentNodeId;
        return this;
    }

    @JsonSetter(value="backgroundColor")
    public UiTreeGraphNode setBackgroundColor(UiColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @JsonSetter(value="borderColor")
    public UiTreeGraphNode setBorderColor(UiColor borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    @JsonSetter(value="borderWidth")
    public UiTreeGraphNode setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    @JsonSetter(value="borderRadius")
    public UiTreeGraphNode setBorderRadius(float borderRadius) {
        this.borderRadius = borderRadius;
        return this;
    }

    @JsonSetter(value="nodeImage")
    public UiTreeGraphNode setNodeImage(UiTreeGraphNodeImage nodeImage) {
        this.nodeImage = nodeImage;
        return this;
    }

    @JsonSetter(value="nodeIcon")
    public UiTreeGraphNode setNodeIcon(UiTreeGraphNodeIcon nodeIcon) {
        this.nodeIcon = nodeIcon;
        return this;
    }

    @JsonSetter(value="template")
    public UiTreeGraphNode setTemplate(UiTemplate template) {
        this.template = template;
        return this;
    }

    @JsonSetter(value="record")
    public UiTreeGraphNode setRecord(UiClientRecord record) {
        this.record = record;
        return this;
    }

    @JsonSetter(value="connectorLineColor")
    public UiTreeGraphNode setConnectorLineColor(UiColor connectorLineColor) {
        this.connectorLineColor = connectorLineColor;
        return this;
    }

    @JsonSetter(value="connectorLineWidth")
    public UiTreeGraphNode setConnectorLineWidth(int connectorLineWidth) {
        this.connectorLineWidth = connectorLineWidth;
        return this;
    }

    @JsonSetter(value="dashArray")
    public UiTreeGraphNode setDashArray(String dashArray) {
        this.dashArray = dashArray;
        return this;
    }

    @JsonSetter(value="expanded")
    public UiTreeGraphNode setExpanded(boolean expanded) {
        this.expanded = expanded;
        return this;
    }
}

