package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiChatInput extends UiComponent implements UiObject {


	protected String defaultFileIcon;
	protected long maxBytesPerUpload = 5000000;
	protected String uploadUrl = "/upload";
	protected int messageLengthLimit = 10000;
	protected boolean attachmentsEnabled;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiChatInput() {
		// default constructor for Jackson
	}

	public UiChatInput(String defaultFileIcon) {
		super();
		this.defaultFileIcon = defaultFileIcon;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_CHAT_INPUT;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append("defaultFileIcon=" + defaultFileIcon).append(", ")
				.append("maxBytesPerUpload=" + maxBytesPerUpload).append(", ")
				.append("uploadUrl=" + uploadUrl).append(", ")
				.append("messageLengthLimit=" + messageLengthLimit).append(", ")
				.append("attachmentsEnabled=" + attachmentsEnabled)
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("defaultFileIcon")
	public String getDefaultFileIcon() {
		return defaultFileIcon;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxBytesPerUpload")
	public long getMaxBytesPerUpload() {
		return maxBytesPerUpload;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("uploadUrl")
	public String getUploadUrl() {
		return uploadUrl;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("messageLengthLimit")
	public int getMessageLengthLimit() {
		return messageLengthLimit;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("attachmentsEnabled")
	public boolean getAttachmentsEnabled() {
		return attachmentsEnabled;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiChatInput setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiChatInput setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiChatInput setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiChatInput setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiChatInput setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiChatInput setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("maxBytesPerUpload")
	public UiChatInput setMaxBytesPerUpload(long maxBytesPerUpload) {
		this.maxBytesPerUpload = maxBytesPerUpload;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("uploadUrl")
	public UiChatInput setUploadUrl(String uploadUrl) {
		this.uploadUrl = uploadUrl;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("messageLengthLimit")
	public UiChatInput setMessageLengthLimit(int messageLengthLimit) {
		this.messageLengthLimit = messageLengthLimit;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attachmentsEnabled")
	public UiChatInput setAttachmentsEnabled(boolean attachmentsEnabled) {
		this.attachmentsEnabled = attachmentsEnabled;
		return this;
	}

	public static class MessageSentEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiNewChatMessage message;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public MessageSentEvent() {
			// default constructor for Jackson
		}

		public MessageSentEvent(String componentId, UiNewChatMessage message) {
			this.componentId = componentId;
			this.message = message;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_CHAT_INPUT_MESSAGE_SENT;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(message != null ? "message={" + message.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("message")
		public UiNewChatMessage getMessage() {
			return message;
		}

	}

	public static class UploadTooLargeEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadTooLargeEvent() {
			// default constructor for Jackson
		}

		public UploadTooLargeEvent(String componentId, String fileItemUuid, String fileName, String mimeType, long sizeInBytes) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_CHAT_INPUT_UPLOAD_TOO_LARGE;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("fileItemUuid=" + fileItemUuid).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

	}

	public static class UploadStartedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;
		protected int incompleteUploadsCount;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadStartedEvent() {
			// default constructor for Jackson
		}

		public UploadStartedEvent(String componentId, String fileItemUuid, String fileName, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
			this.incompleteUploadsCount = incompleteUploadsCount;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_CHAT_INPUT_UPLOAD_STARTED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("fileItemUuid=" + fileItemUuid).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes).append(", ")
					.append("incompleteUploadsCount=" + incompleteUploadsCount)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("incompleteUploadsCount")
		public int getIncompleteUploadsCount() {
			return incompleteUploadsCount;
		}

	}

	public static class UploadCanceledEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;
		protected int incompleteUploadsCount;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadCanceledEvent() {
			// default constructor for Jackson
		}

		public UploadCanceledEvent(String componentId, String fileItemUuid, String fileName, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
			this.incompleteUploadsCount = incompleteUploadsCount;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_CHAT_INPUT_UPLOAD_CANCELED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("fileItemUuid=" + fileItemUuid).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes).append(", ")
					.append("incompleteUploadsCount=" + incompleteUploadsCount)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("incompleteUploadsCount")
		public int getIncompleteUploadsCount() {
			return incompleteUploadsCount;
		}

	}

	public static class UploadFailedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;
		protected int incompleteUploadsCount;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadFailedEvent() {
			// default constructor for Jackson
		}

		public UploadFailedEvent(String componentId, String fileItemUuid, String fileName, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
			this.incompleteUploadsCount = incompleteUploadsCount;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_CHAT_INPUT_UPLOAD_FAILED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("fileItemUuid=" + fileItemUuid).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes).append(", ")
					.append("incompleteUploadsCount=" + incompleteUploadsCount)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("incompleteUploadsCount")
		public int getIncompleteUploadsCount() {
			return incompleteUploadsCount;
		}

	}

	public static class UploadSuccessfulEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;
		protected String uploadedFileUuid;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;
		protected int incompleteUploadsCount;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadSuccessfulEvent() {
			// default constructor for Jackson
		}

		public UploadSuccessfulEvent(String componentId, String fileItemUuid, String uploadedFileUuid, String fileName, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
			this.uploadedFileUuid = uploadedFileUuid;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
			this.incompleteUploadsCount = incompleteUploadsCount;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_CHAT_INPUT_UPLOAD_SUCCESSFUL;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("fileItemUuid=" + fileItemUuid).append(", ")
					.append("uploadedFileUuid=" + uploadedFileUuid).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes).append(", ")
					.append("incompleteUploadsCount=" + incompleteUploadsCount)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("uploadedFileUuid")
		public String getUploadedFileUuid() {
			return uploadedFileUuid;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("incompleteUploadsCount")
		public int getIncompleteUploadsCount() {
			return incompleteUploadsCount;
		}

	}

	public static class FileItemClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public FileItemClickedEvent() {
			// default constructor for Jackson
		}

		public FileItemClickedEvent(String componentId, String fileItemUuid) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_CHAT_INPUT_FILE_ITEM_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileItemUuid=" + fileItemUuid)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

	}

	public static class FileItemRemovedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public FileItemRemovedEvent() {
			// default constructor for Jackson
		}

		public FileItemRemovedEvent(String componentId, String fileItemUuid) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_CHAT_INPUT_FILE_ITEM_REMOVED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileItemUuid=" + fileItemUuid)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

	}


	public static class SetAttachmentsEnabledCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean attachmentsEnabled;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetAttachmentsEnabledCommand() {
			// default constructor for Jackson
		}

		public SetAttachmentsEnabledCommand(String componentId, boolean attachmentsEnabled) {
			this.componentId = componentId;
			this.attachmentsEnabled = attachmentsEnabled;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("attachmentsEnabled=" + attachmentsEnabled)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("attachmentsEnabled")
		public boolean getAttachmentsEnabled() {
			return attachmentsEnabled;
		}

	}

}