package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiPopup extends UiComponent implements UiObject {


	protected UiClientObjectReference contentComponent;
	protected int width;
	protected int height;
	protected int x;
	protected int y;
	protected String backgroundColor;
	protected boolean modal = false;
	protected String dimmingColor = "rgba(0, 0, 0, .2)";
	protected boolean closeOnEscape;
	protected boolean closeOnClickOutside;

	public UiPopup() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_POPUP;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append("width=" + width).append(", ")
				.append("height=" + height).append(", ")
				.append("x=" + x).append(", ")
				.append("y=" + y).append(", ")
				.append("backgroundColor=" + backgroundColor).append(", ")
				.append("modal=" + modal).append(", ")
				.append("dimmingColor=" + dimmingColor).append(", ")
				.append("closeOnEscape=" + closeOnEscape).append(", ")
				.append("closeOnClickOutside=" + closeOnClickOutside).append(", ")
				.append(contentComponent != null ? "contentComponent={" + contentComponent.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("contentComponent")
	public UiClientObjectReference getContentComponent() {
		return contentComponent;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("width")
	public int getWidth() {
		return width;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("height")
	public int getHeight() {
		return height;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("x")
	public int getX() {
		return x;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("y")
	public int getY() {
		return y;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public String getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("modal")
	public boolean getModal() {
		return modal;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("dimmingColor")
	public String getDimmingColor() {
		return dimmingColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("closeOnEscape")
	public boolean getCloseOnEscape() {
		return closeOnEscape;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("closeOnClickOutside")
	public boolean getCloseOnClickOutside() {
		return closeOnClickOutside;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiPopup setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiPopup setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiPopup setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiPopup setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiPopup setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiPopup setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("contentComponent")
	public UiPopup setContentComponent(UiClientObjectReference contentComponent) {
		this.contentComponent = contentComponent;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("width")
	public UiPopup setWidth(int width) {
		this.width = width;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("height")
	public UiPopup setHeight(int height) {
		this.height = height;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("x")
	public UiPopup setX(int x) {
		this.x = x;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("y")
	public UiPopup setY(int y) {
		this.y = y;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiPopup setBackgroundColor(String backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("modal")
	public UiPopup setModal(boolean modal) {
		this.modal = modal;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("dimmingColor")
	public UiPopup setDimmingColor(String dimmingColor) {
		this.dimmingColor = dimmingColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("closeOnEscape")
	public UiPopup setCloseOnEscape(boolean closeOnEscape) {
		this.closeOnEscape = closeOnEscape;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("closeOnClickOutside")
	public UiPopup setCloseOnClickOutside(boolean closeOnClickOutside) {
		this.closeOnClickOutside = closeOnClickOutside;
		return this;
	}



	public static class SetBackgroundColorCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String backgroundColor;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetBackgroundColorCommand() {
			// default constructor for Jackson
		}

		public SetBackgroundColorCommand(String componentId, String backgroundColor) {
			this.componentId = componentId;
			this.backgroundColor = backgroundColor;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("backgroundColor=" + backgroundColor)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
		public String getBackgroundColor() {
			return backgroundColor;
		}

	}

	public static class SetDimmingColorCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String backgroundColor;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetDimmingColorCommand() {
			// default constructor for Jackson
		}

		public SetDimmingColorCommand(String componentId, String backgroundColor) {
			this.componentId = componentId;
			this.backgroundColor = backgroundColor;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("backgroundColor=" + backgroundColor)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
		public String getBackgroundColor() {
			return backgroundColor;
		}

	}

	public static class SetPositionCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int x;
		protected int y;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetPositionCommand() {
			// default constructor for Jackson
		}

		public SetPositionCommand(String componentId, int x, int y) {
			this.componentId = componentId;
			this.x = x;
			this.y = y;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("x=" + x).append(", ")
					.append("y=" + y)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("x")
		public int getX() {
			return x;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("y")
		public int getY() {
			return y;
		}

	}

	public static class SetDimensionsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int width;
		protected int height;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetDimensionsCommand() {
			// default constructor for Jackson
		}

		public SetDimensionsCommand(String componentId, int width, int height) {
			this.componentId = componentId;
			this.width = width;
			this.height = height;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("width=" + width).append(", ")
					.append("height=" + height)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("width")
		public int getWidth() {
			return width;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("height")
		public int getHeight() {
			return height;
		}

	}

	public static class CloseCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public CloseCommand() {
			// default constructor for Jackson
		}

		public CloseCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

}