package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiFormSection implements UiObject {


	protected String id;
	protected List<UiGridColumn> columns;
	protected List<UiGridRow> rows;
	protected List<UiFormSectionPlacement> fieldPlacements;
	protected UiSpacing margin;
	protected UiSpacing padding;
	protected UiBorder border;
	protected UiShadow shadow;
	protected String backgroundColor;
	protected boolean collapsible;
	protected boolean collapsed;
	protected boolean visible = true;
	protected UiTemplate headerTemplate;

	@JsonSerialize(using = ObjectSerializer.class)
	@JsonDeserialize(using = ObjectDeserializer.class)
	protected Object headerData;
	protected boolean drawHeaderLine = true;
	protected int gridGap = 7;
	protected boolean fillRemainingHeight;
	protected boolean hideWhenNoVisibleFields;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiFormSection() {
		// default constructor for Jackson
	}

	public UiFormSection(String id, List<UiGridColumn> columns, List<UiGridRow> rows, List<UiFormSectionPlacement> fieldPlacements) {
		this.id = id;
		this.columns = columns;
		this.rows = rows;
		this.fieldPlacements = fieldPlacements;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_FORM_SECTION;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append(fieldPlacements != null ? "fieldPlacements={" + fieldPlacements.toString() + "}" : "").append(", ")
				.append("backgroundColor=" + backgroundColor).append(", ")
				.append("collapsible=" + collapsible).append(", ")
				.append("collapsed=" + collapsed).append(", ")
				.append("visible=" + visible).append(", ")
				.append(headerTemplate != null ? "headerTemplate={" + headerTemplate.toString() + "}" : "").append(", ")
				.append("headerData=" + headerData).append(", ")
				.append("drawHeaderLine=" + drawHeaderLine).append(", ")
				.append("gridGap=" + gridGap).append(", ")
				.append("fillRemainingHeight=" + fillRemainingHeight).append(", ")
				.append("hideWhenNoVisibleFields=" + hideWhenNoVisibleFields).append(", ")
				.append(columns != null ? "columns={" + columns.toString() + "}" : "").append(", ")
				.append(rows != null ? "rows={" + rows.toString() + "}" : "").append(", ")
				.append(margin != null ? "margin={" + margin.toString() + "}" : "").append(", ")
				.append(padding != null ? "padding={" + padding.toString() + "}" : "").append(", ")
				.append(border != null ? "border={" + border.toString() + "}" : "").append(", ")
				.append(shadow != null ? "shadow={" + shadow.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("id")
	public String getId() {
		return id;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("columns")
	public List<UiGridColumn> getColumns() {
		return columns;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("rows")
	public List<UiGridRow> getRows() {
		return rows;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("fieldPlacements")
	public List<UiFormSectionPlacement> getFieldPlacements() {
		return fieldPlacements;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("margin")
	public UiSpacing getMargin() {
		return margin;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("padding")
	public UiSpacing getPadding() {
		return padding;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("border")
	public UiBorder getBorder() {
		return border;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("shadow")
	public UiShadow getShadow() {
		return shadow;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public String getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("collapsible")
	public boolean getCollapsible() {
		return collapsible;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("collapsed")
	public boolean getCollapsed() {
		return collapsed;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("visible")
	public boolean getVisible() {
		return visible;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("headerTemplate")
	public UiTemplate getHeaderTemplate() {
		return headerTemplate;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("headerData")
	public Object getHeaderData() {
		return headerData;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("drawHeaderLine")
	public boolean getDrawHeaderLine() {
		return drawHeaderLine;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("gridGap")
	public int getGridGap() {
		return gridGap;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("fillRemainingHeight")
	public boolean getFillRemainingHeight() {
		return fillRemainingHeight;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("hideWhenNoVisibleFields")
	public boolean getHideWhenNoVisibleFields() {
		return hideWhenNoVisibleFields;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("margin")
	public UiFormSection setMargin(UiSpacing margin) {
		this.margin = margin;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("padding")
	public UiFormSection setPadding(UiSpacing padding) {
		this.padding = padding;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("border")
	public UiFormSection setBorder(UiBorder border) {
		this.border = border;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("shadow")
	public UiFormSection setShadow(UiShadow shadow) {
		this.shadow = shadow;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiFormSection setBackgroundColor(String backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("collapsible")
	public UiFormSection setCollapsible(boolean collapsible) {
		this.collapsible = collapsible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("collapsed")
	public UiFormSection setCollapsed(boolean collapsed) {
		this.collapsed = collapsed;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiFormSection setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("headerTemplate")
	public UiFormSection setHeaderTemplate(UiTemplate headerTemplate) {
		this.headerTemplate = headerTemplate;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("headerData")
	public UiFormSection setHeaderData(Object headerData) {
		this.headerData = headerData;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("drawHeaderLine")
	public UiFormSection setDrawHeaderLine(boolean drawHeaderLine) {
		this.drawHeaderLine = drawHeaderLine;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("gridGap")
	public UiFormSection setGridGap(int gridGap) {
		this.gridGap = gridGap;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fillRemainingHeight")
	public UiFormSection setFillRemainingHeight(boolean fillRemainingHeight) {
		this.fillRemainingHeight = fillRemainingHeight;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("hideWhenNoVisibleFields")
	public UiFormSection setHideWhenNoVisibleFields(boolean hideWhenNoVisibleFields) {
		this.hideWhenNoVisibleFields = hideWhenNoVisibleFields;
		return this;
	}




}