/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiIdentifiableClientRecord;
import org.teamapps.dto.UiItemViewItemBackgroundMode;
import org.teamapps.dto.UiItemViewItemGroup;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTemplate;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiItemView.class)
public class UiItemView
extends UiComponent
implements UiObject {
    protected UiTemplate groupHeaderTemplate;
    protected List<UiItemViewItemGroup> itemGroups;
    protected int horizontalPadding = 10;
    protected int verticalPadding = 0;
    protected int groupSpacing;
    protected UiItemViewItemBackgroundMode itemBackgroundMode = UiItemViewItemBackgroundMode.LIGHT;
    protected String filter;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_ITEM_VIEW;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + (String)(this.groupHeaderTemplate != null ? "groupHeaderTemplate={" + this.groupHeaderTemplate.toString() + "}" : "") + ", " + ("horizontalPadding=" + this.horizontalPadding) + ", " + ("verticalPadding=" + this.verticalPadding) + ", " + ("groupSpacing=" + this.groupSpacing) + ", " + ("itemBackgroundMode=" + this.itemBackgroundMode) + ", " + ("filter=" + this.filter) + ", " + (String)(this.itemGroups != null ? "itemGroups={" + this.itemGroups.toString() + "}" : "");
    }

    @JsonGetter(value="groupHeaderTemplate")
    public UiTemplate getGroupHeaderTemplate() {
        return this.groupHeaderTemplate;
    }

    @JsonGetter(value="itemGroups")
    public List<UiItemViewItemGroup> getItemGroups() {
        return this.itemGroups;
    }

    @JsonGetter(value="horizontalPadding")
    public int getHorizontalPadding() {
        return this.horizontalPadding;
    }

    @JsonGetter(value="verticalPadding")
    public int getVerticalPadding() {
        return this.verticalPadding;
    }

    @JsonGetter(value="groupSpacing")
    public int getGroupSpacing() {
        return this.groupSpacing;
    }

    @JsonGetter(value="itemBackgroundMode")
    public UiItemViewItemBackgroundMode getItemBackgroundMode() {
        return this.itemBackgroundMode;
    }

    @JsonGetter(value="filter")
    public String getFilter() {
        return this.filter;
    }

    @Override
    @JsonSetter(value="id")
    public UiItemView setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiItemView setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiItemView setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiItemView setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiItemView setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiItemView setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="groupHeaderTemplate")
    public UiItemView setGroupHeaderTemplate(UiTemplate groupHeaderTemplate) {
        this.groupHeaderTemplate = groupHeaderTemplate;
        return this;
    }

    @JsonSetter(value="itemGroups")
    public UiItemView setItemGroups(List<UiItemViewItemGroup> itemGroups) {
        this.itemGroups = itemGroups;
        return this;
    }

    @JsonSetter(value="horizontalPadding")
    public UiItemView setHorizontalPadding(int horizontalPadding) {
        this.horizontalPadding = horizontalPadding;
        return this;
    }

    @JsonSetter(value="verticalPadding")
    public UiItemView setVerticalPadding(int verticalPadding) {
        this.verticalPadding = verticalPadding;
        return this;
    }

    @JsonSetter(value="groupSpacing")
    public UiItemView setGroupSpacing(int groupSpacing) {
        this.groupSpacing = groupSpacing;
        return this;
    }

    @JsonSetter(value="itemBackgroundMode")
    public UiItemView setItemBackgroundMode(UiItemViewItemBackgroundMode itemBackgroundMode) {
        this.itemBackgroundMode = itemBackgroundMode;
        return this;
    }

    @JsonSetter(value="filter")
    public UiItemView setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public static class RemoveItemCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String groupId;
        protected int itemId;

        @Deprecated
        public RemoveItemCommand() {
        }

        public RemoveItemCommand(String componentId, String groupId, int itemId) {
            this.componentId = componentId;
            this.groupId = groupId;
            this.itemId = itemId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("groupId=" + this.groupId) + ", " + ("itemId=" + this.itemId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="groupId")
        public String getGroupId() {
            return this.groupId;
        }

        @JsonGetter(value="itemId")
        public int getItemId() {
            return this.itemId;
        }
    }

    public static class AddItemCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String groupId;
        protected UiIdentifiableClientRecord item;

        @Deprecated
        public AddItemCommand() {
        }

        public AddItemCommand(String componentId, String groupId, UiIdentifiableClientRecord item) {
            this.componentId = componentId;
            this.groupId = groupId;
            this.item = item;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("groupId=" + this.groupId) + ", " + (String)(this.item != null ? "item={" + this.item.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="groupId")
        public String getGroupId() {
            return this.groupId;
        }

        @JsonGetter(value="item")
        public UiIdentifiableClientRecord getItem() {
            return this.item;
        }
    }

    public static class RemoveItemGroupCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String groupId;

        @Deprecated
        public RemoveItemGroupCommand() {
        }

        public RemoveItemGroupCommand(String componentId, String groupId) {
            this.componentId = componentId;
            this.groupId = groupId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("groupId=" + this.groupId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="groupId")
        public String getGroupId() {
            return this.groupId;
        }
    }

    public static class RefreshItemGroupCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiItemViewItemGroup itemGroup;

        @Deprecated
        public RefreshItemGroupCommand() {
        }

        public RefreshItemGroupCommand(String componentId, UiItemViewItemGroup itemGroup) {
            this.componentId = componentId;
            this.itemGroup = itemGroup;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.itemGroup != null ? "itemGroup={" + this.itemGroup.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="itemGroup")
        public UiItemViewItemGroup getItemGroup() {
            return this.itemGroup;
        }
    }

    public static class AddItemGroupCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiItemViewItemGroup itemGroup;

        @Deprecated
        public AddItemGroupCommand() {
        }

        public AddItemGroupCommand(String componentId, UiItemViewItemGroup itemGroup) {
            this.componentId = componentId;
            this.itemGroup = itemGroup;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.itemGroup != null ? "itemGroup={" + this.itemGroup.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="itemGroup")
        public UiItemViewItemGroup getItemGroup() {
            return this.itemGroup;
        }
    }

    public static class SetFilterCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String filter;

        @Deprecated
        public SetFilterCommand() {
        }

        public SetFilterCommand(String componentId, String filter) {
            this.componentId = componentId;
            this.filter = filter;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("filter=" + this.filter);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="filter")
        public String getFilter() {
            return this.filter;
        }
    }

    public static class ItemClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String groupId;
        protected int itemId;

        @Deprecated
        public ItemClickedEvent() {
        }

        public ItemClickedEvent(String componentId, String groupId, int itemId) {
            this.componentId = componentId;
            this.groupId = groupId;
            this.itemId = itemId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_ITEM_VIEW_ITEM_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("groupId=" + this.groupId) + ", " + ("itemId=" + this.itemId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="groupId")
        public String getGroupId() {
            return this.groupId;
        }

        @JsonGetter(value="itemId")
        public int getItemId() {
            return this.itemId;
        }
    }
}

