/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiTreeGraphNodeImage.class)
public class UiTreeGraphNodeImage
implements UiObject {
    protected String url;
    protected int width;
    protected int height;
    protected int centerTopDistance;
    protected int centerLeftDistance;
    protected CornerShape cornerShape = CornerShape.ROUNDED;
    protected boolean shadow = false;
    protected float borderWidth = 0.0f;
    protected String borderColor = "rgb(100, 100, 100)";

    @Deprecated
    public UiTreeGraphNodeImage() {
    }

    public UiTreeGraphNodeImage(String url, int width, int height) {
        this.url = url;
        this.width = width;
        this.height = height;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_TREE_GRAPH_NODE_IMAGE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("url=" + this.url) + ", " + ("width=" + this.width) + ", " + ("height=" + this.height) + ", " + ("centerTopDistance=" + this.centerTopDistance) + ", " + ("centerLeftDistance=" + this.centerLeftDistance) + ", " + ("cornerShape=" + this.cornerShape) + ", " + ("shadow=" + this.shadow) + ", " + ("borderWidth=" + this.borderWidth) + ", " + ("borderColor=" + this.borderColor);
    }

    @JsonGetter(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonGetter(value="width")
    public int getWidth() {
        return this.width;
    }

    @JsonGetter(value="height")
    public int getHeight() {
        return this.height;
    }

    @JsonGetter(value="centerTopDistance")
    public int getCenterTopDistance() {
        return this.centerTopDistance;
    }

    @JsonGetter(value="centerLeftDistance")
    public int getCenterLeftDistance() {
        return this.centerLeftDistance;
    }

    @JsonGetter(value="cornerShape")
    public CornerShape getCornerShape() {
        return this.cornerShape;
    }

    @JsonGetter(value="shadow")
    public boolean getShadow() {
        return this.shadow;
    }

    @JsonGetter(value="borderWidth")
    public float getBorderWidth() {
        return this.borderWidth;
    }

    @JsonGetter(value="borderColor")
    public String getBorderColor() {
        return this.borderColor;
    }

    @JsonSetter(value="centerTopDistance")
    public UiTreeGraphNodeImage setCenterTopDistance(int centerTopDistance) {
        this.centerTopDistance = centerTopDistance;
        return this;
    }

    @JsonSetter(value="centerLeftDistance")
    public UiTreeGraphNodeImage setCenterLeftDistance(int centerLeftDistance) {
        this.centerLeftDistance = centerLeftDistance;
        return this;
    }

    @JsonSetter(value="cornerShape")
    public UiTreeGraphNodeImage setCornerShape(CornerShape cornerShape) {
        this.cornerShape = cornerShape;
        return this;
    }

    @JsonSetter(value="shadow")
    public UiTreeGraphNodeImage setShadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    @JsonSetter(value="borderWidth")
    public UiTreeGraphNodeImage setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    @JsonSetter(value="borderColor")
    public UiTreeGraphNodeImage setBorderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public static enum CornerShape {
        ORIGINAL,
        ROUNDED,
        CIRCLE;


        @JsonValue
        public int jsonValue() {
            return this.ordinal();
        }
    }
}

