/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class CopyOnWriteLeakyCache<K, V> {
    private Map<K, V> map = Collections.emptyMap();

    public V computeIfAbsent(K key, Function<K, V> computeFunction) {
        V value = this.map.get(key);
        if (value != null) {
            return value;
        }
        HashMap<K, V> mapCopy = new HashMap<K, V>(this.map);
        value = computeFunction.apply(key);
        mapCopy.put(key, value);
        this.map = mapCopy;
        return value;
    }
}

