/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.ObjectDeserializer;
import org.teamapps.dto.ObjectSerializer;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiFieldEditingMode;
import org.teamapps.dto.UiFieldMessage;
import org.teamapps.dto.UiFileFieldDisplayType;
import org.teamapps.dto.UiIdentifiableClientRecord;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTemplate;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiFileField.class)
public class UiFileField
extends UiField
implements UiObject {
    protected UiTemplate itemTemplate;
    protected long maxBytesPerFile = 5000000L;
    protected String uploadUrl = "/upload";
    protected String fileTooLargeMessage = "File too large!";
    protected String uploadErrorMessage = "Error while transmitting file...";
    protected UiFileFieldDisplayType displayType = UiFileFieldDisplayType.LIST;
    protected int maxFiles;
    protected UiTemplate uploadButtonTemplate;
    @JsonSerialize(using=ObjectSerializer.class)
    @JsonDeserialize(using=ObjectDeserializer.class)
    protected Object uploadButtonData;
    protected boolean showEntriesAsButtonsOnHover = false;

    @Deprecated
    public UiFileField() {
    }

    public UiFileField(UiTemplate itemTemplate, UiTemplate uploadButtonTemplate, Object uploadButtonData) {
        this.itemTemplate = itemTemplate;
        this.uploadButtonTemplate = uploadButtonTemplate;
        this.uploadButtonData = uploadButtonData;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_FILE_FIELD;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + ("editingMode=" + this.editingMode) + ", " + ("value=" + this.value) + ", " + (String)(this.itemTemplate != null ? "itemTemplate={" + this.itemTemplate.toString() + "}" : "") + ", " + ("maxBytesPerFile=" + this.maxBytesPerFile) + ", " + ("uploadUrl=" + this.uploadUrl) + ", " + ("fileTooLargeMessage=" + this.fileTooLargeMessage) + ", " + ("uploadErrorMessage=" + this.uploadErrorMessage) + ", " + ("displayType=" + this.displayType) + ", " + ("maxFiles=" + this.maxFiles) + ", " + (String)(this.uploadButtonTemplate != null ? "uploadButtonTemplate={" + this.uploadButtonTemplate.toString() + "}" : "") + ", " + ("uploadButtonData=" + this.uploadButtonData) + ", " + ("showEntriesAsButtonsOnHover=" + this.showEntriesAsButtonsOnHover) + ", " + (String)(this.fieldMessages != null ? "fieldMessages={" + this.fieldMessages.toString() + "}" : "");
    }

    @JsonGetter(value="itemTemplate")
    public UiTemplate getItemTemplate() {
        return this.itemTemplate;
    }

    @JsonGetter(value="maxBytesPerFile")
    public long getMaxBytesPerFile() {
        return this.maxBytesPerFile;
    }

    @JsonGetter(value="uploadUrl")
    public String getUploadUrl() {
        return this.uploadUrl;
    }

    @JsonGetter(value="fileTooLargeMessage")
    public String getFileTooLargeMessage() {
        return this.fileTooLargeMessage;
    }

    @JsonGetter(value="uploadErrorMessage")
    public String getUploadErrorMessage() {
        return this.uploadErrorMessage;
    }

    @JsonGetter(value="displayType")
    public UiFileFieldDisplayType getDisplayType() {
        return this.displayType;
    }

    @JsonGetter(value="maxFiles")
    public int getMaxFiles() {
        return this.maxFiles;
    }

    @JsonGetter(value="uploadButtonTemplate")
    public UiTemplate getUploadButtonTemplate() {
        return this.uploadButtonTemplate;
    }

    @JsonGetter(value="uploadButtonData")
    public Object getUploadButtonData() {
        return this.uploadButtonData;
    }

    @JsonGetter(value="showEntriesAsButtonsOnHover")
    public boolean getShowEntriesAsButtonsOnHover() {
        return this.showEntriesAsButtonsOnHover;
    }

    @Override
    @JsonSetter(value="id")
    public UiFileField setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiFileField setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiFileField setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiFileField setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiFileField setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiFileField setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="editingMode")
    public UiFileField setEditingMode(UiFieldEditingMode editingMode) {
        this.editingMode = editingMode;
        return this;
    }

    @Override
    @JsonSetter(value="value")
    public UiFileField setValue(Object value) {
        this.value = value;
        return this;
    }

    @Override
    @JsonSetter(value="fieldMessages")
    public UiFileField setFieldMessages(List<UiFieldMessage> fieldMessages) {
        this.fieldMessages = fieldMessages;
        return this;
    }

    @JsonSetter(value="maxBytesPerFile")
    public UiFileField setMaxBytesPerFile(long maxBytesPerFile) {
        this.maxBytesPerFile = maxBytesPerFile;
        return this;
    }

    @JsonSetter(value="uploadUrl")
    public UiFileField setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
        return this;
    }

    @JsonSetter(value="fileTooLargeMessage")
    public UiFileField setFileTooLargeMessage(String fileTooLargeMessage) {
        this.fileTooLargeMessage = fileTooLargeMessage;
        return this;
    }

    @JsonSetter(value="uploadErrorMessage")
    public UiFileField setUploadErrorMessage(String uploadErrorMessage) {
        this.uploadErrorMessage = uploadErrorMessage;
        return this;
    }

    @JsonSetter(value="displayType")
    public UiFileField setDisplayType(UiFileFieldDisplayType displayType) {
        this.displayType = displayType;
        return this;
    }

    @JsonSetter(value="maxFiles")
    public UiFileField setMaxFiles(int maxFiles) {
        this.maxFiles = maxFiles;
        return this;
    }

    @JsonSetter(value="showEntriesAsButtonsOnHover")
    public UiFileField setShowEntriesAsButtonsOnHover(boolean showEntriesAsButtonsOnHover) {
        this.showEntriesAsButtonsOnHover = showEntriesAsButtonsOnHover;
        return this;
    }

    public static class SetShowEntriesAsButtonsOnHoverCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected boolean showEntriesAsButtonsOnHover;

        @Deprecated
        public SetShowEntriesAsButtonsOnHoverCommand() {
        }

        public SetShowEntriesAsButtonsOnHoverCommand(String componentId, boolean showEntriesAsButtonsOnHover) {
            this.componentId = componentId;
            this.showEntriesAsButtonsOnHover = showEntriesAsButtonsOnHover;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("showEntriesAsButtonsOnHover=" + this.showEntriesAsButtonsOnHover);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="showEntriesAsButtonsOnHover")
        public boolean getShowEntriesAsButtonsOnHover() {
            return this.showEntriesAsButtonsOnHover;
        }
    }

    public static class SetUploadButtonDataCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        @JsonSerialize(using=ObjectSerializer.class)
        @JsonDeserialize(using=ObjectDeserializer.class)
        protected Object uploadButtonData;

        @Deprecated
        public SetUploadButtonDataCommand() {
        }

        public SetUploadButtonDataCommand(String componentId, Object uploadButtonData) {
            this.componentId = componentId;
            this.uploadButtonData = uploadButtonData;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("uploadButtonData=" + this.uploadButtonData);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="uploadButtonData")
        public Object getUploadButtonData() {
            return this.uploadButtonData;
        }
    }

    public static class SetUploadButtonTemplateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiTemplate uploadButtonTemplate;

        @Deprecated
        public SetUploadButtonTemplateCommand() {
        }

        public SetUploadButtonTemplateCommand(String componentId, UiTemplate uploadButtonTemplate) {
            this.componentId = componentId;
            this.uploadButtonTemplate = uploadButtonTemplate;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.uploadButtonTemplate != null ? "uploadButtonTemplate={" + this.uploadButtonTemplate.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="uploadButtonTemplate")
        public UiTemplate getUploadButtonTemplate() {
            return this.uploadButtonTemplate;
        }
    }

    public static class SetMaxFilesCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int maxFiles;

        @Deprecated
        public SetMaxFilesCommand() {
        }

        public SetMaxFilesCommand(String componentId, int maxFiles) {
            this.componentId = componentId;
            this.maxFiles = maxFiles;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("maxFiles=" + this.maxFiles);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="maxFiles")
        public int getMaxFiles() {
            return this.maxFiles;
        }
    }

    public static class SetDisplayTypeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiFileFieldDisplayType displayType;

        @Deprecated
        public SetDisplayTypeCommand() {
        }

        public SetDisplayTypeCommand(String componentId, UiFileFieldDisplayType displayType) {
            this.componentId = componentId;
            this.displayType = displayType;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("displayType=" + this.displayType);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="displayType")
        public UiFileFieldDisplayType getDisplayType() {
            return this.displayType;
        }
    }

    public static class SetUploadUrlCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String uploadUrl;

        @Deprecated
        public SetUploadUrlCommand() {
        }

        public SetUploadUrlCommand(String componentId, String uploadUrl) {
            this.componentId = componentId;
            this.uploadUrl = uploadUrl;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("uploadUrl=" + this.uploadUrl);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="uploadUrl")
        public String getUploadUrl() {
            return this.uploadUrl;
        }
    }

    public static class SetMaxBytesPerFileCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected long maxBytesPerFile;

        @Deprecated
        public SetMaxBytesPerFileCommand() {
        }

        public SetMaxBytesPerFileCommand(String componentId, long maxBytesPerFile) {
            this.componentId = componentId;
            this.maxBytesPerFile = maxBytesPerFile;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("maxBytesPerFile=" + this.maxBytesPerFile);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="maxBytesPerFile")
        public long getMaxBytesPerFile() {
            return this.maxBytesPerFile;
        }
    }

    public static class SetItemTemplateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiTemplate itemTemplate;

        @Deprecated
        public SetItemTemplateCommand() {
        }

        public SetItemTemplateCommand(String componentId, UiTemplate itemTemplate) {
            this.componentId = componentId;
            this.itemTemplate = itemTemplate;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.itemTemplate != null ? "itemTemplate={" + this.itemTemplate.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="itemTemplate")
        public UiTemplate getItemTemplate() {
            return this.itemTemplate;
        }
    }

    public static class ReplaceFileItemCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;
        protected UiIdentifiableClientRecord data;

        @Deprecated
        public ReplaceFileItemCommand() {
        }

        public ReplaceFileItemCommand(String componentId, String fileItemUuid, UiIdentifiableClientRecord data) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
            this.data = data;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileItemUuid=" + this.fileItemUuid) + ", " + (String)(this.data != null ? "data={" + this.data.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }

        @JsonGetter(value="data")
        public UiIdentifiableClientRecord getData() {
            return this.data;
        }
    }

    public static class FileItemRemoveButtonClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int clientId;

        @Deprecated
        public FileItemRemoveButtonClickedEvent() {
        }

        public FileItemRemoveButtonClickedEvent(String componentId, int clientId) {
            this.componentId = componentId;
            this.clientId = clientId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_FILE_FIELD_FILE_ITEM_REMOVE_BUTTON_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("clientId=" + this.clientId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="clientId")
        public int getClientId() {
            return this.clientId;
        }
    }

    public static class FileItemClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int clientId;

        @Deprecated
        public FileItemClickedEvent() {
        }

        public FileItemClickedEvent(String componentId, int clientId) {
            this.componentId = componentId;
            this.clientId = clientId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_FILE_FIELD_FILE_ITEM_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("clientId=" + this.clientId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="clientId")
        public int getClientId() {
            return this.clientId;
        }
    }

    public static class UploadSuccessfulEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;
        protected String uploadedFileUuid;
        protected String fileName;
        protected String mimeType;
        protected long sizeInBytes;
        protected int incompleteUploadsCount;

        @Deprecated
        public UploadSuccessfulEvent() {
        }

        public UploadSuccessfulEvent(String componentId, String fileItemUuid, String uploadedFileUuid, String fileName, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
            this.uploadedFileUuid = uploadedFileUuid;
            this.fileName = fileName;
            this.mimeType = mimeType;
            this.sizeInBytes = sizeInBytes;
            this.incompleteUploadsCount = incompleteUploadsCount;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_FILE_FIELD_UPLOAD_SUCCESSFUL;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileName=" + this.fileName) + ", " + ("fileItemUuid=" + this.fileItemUuid) + ", " + ("uploadedFileUuid=" + this.uploadedFileUuid) + ", " + ("mimeType=" + this.mimeType) + ", " + ("sizeInBytes=" + this.sizeInBytes) + ", " + ("incompleteUploadsCount=" + this.incompleteUploadsCount);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }

        @JsonGetter(value="uploadedFileUuid")
        public String getUploadedFileUuid() {
            return this.uploadedFileUuid;
        }

        @JsonGetter(value="fileName")
        public String getFileName() {
            return this.fileName;
        }

        @JsonGetter(value="mimeType")
        public String getMimeType() {
            return this.mimeType;
        }

        @JsonGetter(value="sizeInBytes")
        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @JsonGetter(value="incompleteUploadsCount")
        public int getIncompleteUploadsCount() {
            return this.incompleteUploadsCount;
        }
    }

    public static class UploadFailedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;
        protected String fileName;
        protected String mimeType;
        protected long sizeInBytes;
        protected int incompleteUploadsCount;

        @Deprecated
        public UploadFailedEvent() {
        }

        public UploadFailedEvent(String componentId, String fileItemUuid, String fileName, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
            this.fileName = fileName;
            this.mimeType = mimeType;
            this.sizeInBytes = sizeInBytes;
            this.incompleteUploadsCount = incompleteUploadsCount;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_FILE_FIELD_UPLOAD_FAILED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileName=" + this.fileName) + ", " + ("fileItemUuid=" + this.fileItemUuid) + ", " + ("mimeType=" + this.mimeType) + ", " + ("sizeInBytes=" + this.sizeInBytes) + ", " + ("incompleteUploadsCount=" + this.incompleteUploadsCount);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }

        @JsonGetter(value="fileName")
        public String getFileName() {
            return this.fileName;
        }

        @JsonGetter(value="mimeType")
        public String getMimeType() {
            return this.mimeType;
        }

        @JsonGetter(value="sizeInBytes")
        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @JsonGetter(value="incompleteUploadsCount")
        public int getIncompleteUploadsCount() {
            return this.incompleteUploadsCount;
        }
    }

    public static class UploadCanceledEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;
        protected String fileName;
        protected String mimeType;
        protected long sizeInBytes;
        protected int incompleteUploadsCount;

        @Deprecated
        public UploadCanceledEvent() {
        }

        public UploadCanceledEvent(String componentId, String fileItemUuid, String fileName, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
            this.fileName = fileName;
            this.mimeType = mimeType;
            this.sizeInBytes = sizeInBytes;
            this.incompleteUploadsCount = incompleteUploadsCount;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_FILE_FIELD_UPLOAD_CANCELED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileName=" + this.fileName) + ", " + ("fileItemUuid=" + this.fileItemUuid) + ", " + ("mimeType=" + this.mimeType) + ", " + ("sizeInBytes=" + this.sizeInBytes) + ", " + ("incompleteUploadsCount=" + this.incompleteUploadsCount);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }

        @JsonGetter(value="fileName")
        public String getFileName() {
            return this.fileName;
        }

        @JsonGetter(value="mimeType")
        public String getMimeType() {
            return this.mimeType;
        }

        @JsonGetter(value="sizeInBytes")
        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @JsonGetter(value="incompleteUploadsCount")
        public int getIncompleteUploadsCount() {
            return this.incompleteUploadsCount;
        }
    }

    public static class UploadStartedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;
        protected String fileName;
        protected String mimeType;
        protected long sizeInBytes;
        protected int incompleteUploadsCount;

        @Deprecated
        public UploadStartedEvent() {
        }

        public UploadStartedEvent(String componentId, String fileItemUuid, String fileName, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
            this.fileName = fileName;
            this.mimeType = mimeType;
            this.sizeInBytes = sizeInBytes;
            this.incompleteUploadsCount = incompleteUploadsCount;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_FILE_FIELD_UPLOAD_STARTED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileName=" + this.fileName) + ", " + ("fileItemUuid=" + this.fileItemUuid) + ", " + ("mimeType=" + this.mimeType) + ", " + ("sizeInBytes=" + this.sizeInBytes) + ", " + ("incompleteUploadsCount=" + this.incompleteUploadsCount);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }

        @JsonGetter(value="fileName")
        public String getFileName() {
            return this.fileName;
        }

        @JsonGetter(value="mimeType")
        public String getMimeType() {
            return this.mimeType;
        }

        @JsonGetter(value="sizeInBytes")
        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @JsonGetter(value="incompleteUploadsCount")
        public int getIncompleteUploadsCount() {
            return this.incompleteUploadsCount;
        }
    }

    public static class UploadTooLargeEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;
        protected String fileName;
        protected String mimeType;
        protected long sizeInBytes;

        @Deprecated
        public UploadTooLargeEvent() {
        }

        public UploadTooLargeEvent(String componentId, String fileItemUuid, String fileName, String mimeType, long sizeInBytes) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
            this.fileName = fileName;
            this.mimeType = mimeType;
            this.sizeInBytes = sizeInBytes;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_FILE_FIELD_UPLOAD_TOO_LARGE;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileName=" + this.fileName) + ", " + ("fileItemUuid=" + this.fileItemUuid) + ", " + ("mimeType=" + this.mimeType) + ", " + ("sizeInBytes=" + this.sizeInBytes);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }

        @JsonGetter(value="fileName")
        public String getFileName() {
            return this.fileName;
        }

        @JsonGetter(value="mimeType")
        public String getMimeType() {
            return this.mimeType;
        }

        @JsonGetter(value="sizeInBytes")
        public long getSizeInBytes() {
            return this.sizeInBytes;
        }
    }
}

