package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type", defaultImpl = UiImageElement.class)
public class UiImageElement extends AbstractUiTemplateElement implements UiObject {


	protected int width;
	protected int height;
	protected UiBorder border;
	protected UiSpacing padding;
	protected UiShadow shadow;
	protected UiImageSizing imageSizing = UiImageSizing.COVER;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiImageElement() {
		// default constructor for Jackson
	}

	public UiImageElement(String dataKey, int row, int column, int width, int height) {
		super(dataKey, row, column);
		this.width = width;
		this.height = height;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_IMAGE_ELEMENT;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("dataKey=" + dataKey).append(", ")
				.append("row=" + row).append(", ")
				.append("column=" + column).append(", ")
				.append("rowSpan=" + rowSpan).append(", ")
				.append("colSpan=" + colSpan).append(", ")
				.append("horizontalAlignment=" + horizontalAlignment).append(", ")
				.append("verticalAlignment=" + verticalAlignment).append(", ")
				.append("backgroundColor=" + backgroundColor).append(", ")
				.append("width=" + width).append(", ")
				.append("height=" + height).append(", ")
				.append("imageSizing=" + imageSizing).append(", ")
				.append(margin != null ? "margin={" + margin.toString() + "}" : "").append(", ")
				.append(border != null ? "border={" + border.toString() + "}" : "").append(", ")
				.append(padding != null ? "padding={" + padding.toString() + "}" : "").append(", ")
				.append(shadow != null ? "shadow={" + shadow.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("width")
	public int getWidth() {
		return width;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("height")
	public int getHeight() {
		return height;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("border")
	public UiBorder getBorder() {
		return border;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("padding")
	public UiSpacing getPadding() {
		return padding;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("shadow")
	public UiShadow getShadow() {
		return shadow;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("imageSizing")
	public UiImageSizing getImageSizing() {
		return imageSizing;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("rowSpan")
	public UiImageElement setRowSpan(int rowSpan) {
		this.rowSpan = rowSpan;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("colSpan")
	public UiImageElement setColSpan(int colSpan) {
		this.colSpan = colSpan;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("horizontalAlignment")
	public UiImageElement setHorizontalAlignment(UiHorizontalElementAlignment horizontalAlignment) {
		this.horizontalAlignment = horizontalAlignment;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("verticalAlignment")
	public UiImageElement setVerticalAlignment(UiVerticalElementAlignment verticalAlignment) {
		this.verticalAlignment = verticalAlignment;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("margin")
	public UiImageElement setMargin(UiSpacing margin) {
		this.margin = margin;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiImageElement setBackgroundColor(String backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("border")
	public UiImageElement setBorder(UiBorder border) {
		this.border = border;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("padding")
	public UiImageElement setPadding(UiSpacing padding) {
		this.padding = padding;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("shadow")
	public UiImageElement setShadow(UiShadow shadow) {
		this.shadow = shadow;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("imageSizing")
	public UiImageElement setImageSizing(UiImageSizing imageSizing) {
		this.imageSizing = imageSizing;
		return this;
	}




}