/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiClientRecord;
import org.teamapps.dto.UiColor;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTemplate;
import org.teamapps.dto.UiTreeGraphNodeIcon;
import org.teamapps.dto.UiTreeGraphNodeImage;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiTreeGraphNode
implements UiObject {
    protected String id;
    protected String parentId;
    protected int width;
    protected int height;
    protected UiColor backgroundColor = new UiColor(255, 255, 255);
    protected UiColor borderColor = new UiColor(100, 100, 100);
    protected float borderWidth = 1.0f;
    protected float borderRadius = 0.0f;
    protected UiTreeGraphNodeImage image;
    protected UiTreeGraphNodeIcon icon;
    protected UiTemplate template;
    protected UiClientRecord record;
    protected UiColor connectorLineColor = new UiColor(100, 100, 100);
    protected int connectorLineWidth;
    protected String dashArray;
    protected boolean expanded;

    @Deprecated
    public UiTreeGraphNode() {
    }

    public UiTreeGraphNode(String id, int width, int height) {
        this.id = id;
        this.width = width;
        this.height = height;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_TREE_GRAPH_NODE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("parentId=" + this.parentId) + ", " + ("width=" + this.width) + ", " + ("height=" + this.height) + ", " + ("borderWidth=" + this.borderWidth) + ", " + ("borderRadius=" + this.borderRadius) + ", " + (String)(this.template != null ? "template={" + this.template.toString() + "}" : "") + ", " + ("connectorLineWidth=" + this.connectorLineWidth) + ", " + ("dashArray=" + this.dashArray) + ", " + ("expanded=" + this.expanded) + ", " + (String)(this.backgroundColor != null ? "backgroundColor={" + this.backgroundColor.toString() + "}" : "") + ", " + (String)(this.borderColor != null ? "borderColor={" + this.borderColor.toString() + "}" : "") + ", " + (String)(this.image != null ? "image={" + this.image.toString() + "}" : "") + ", " + (String)(this.icon != null ? "icon={" + this.icon.toString() + "}" : "") + ", " + (String)(this.record != null ? "record={" + this.record.toString() + "}" : "") + ", " + (String)(this.connectorLineColor != null ? "connectorLineColor={" + this.connectorLineColor.toString() + "}" : "");
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="parentId")
    public String getParentId() {
        return this.parentId;
    }

    @JsonGetter(value="width")
    public int getWidth() {
        return this.width;
    }

    @JsonGetter(value="height")
    public int getHeight() {
        return this.height;
    }

    @JsonGetter(value="backgroundColor")
    public UiColor getBackgroundColor() {
        return this.backgroundColor;
    }

    @JsonGetter(value="borderColor")
    public UiColor getBorderColor() {
        return this.borderColor;
    }

    @JsonGetter(value="borderWidth")
    public float getBorderWidth() {
        return this.borderWidth;
    }

    @JsonGetter(value="borderRadius")
    public float getBorderRadius() {
        return this.borderRadius;
    }

    @JsonGetter(value="image")
    public UiTreeGraphNodeImage getImage() {
        return this.image;
    }

    @JsonGetter(value="icon")
    public UiTreeGraphNodeIcon getIcon() {
        return this.icon;
    }

    @JsonGetter(value="template")
    public UiTemplate getTemplate() {
        return this.template;
    }

    @JsonGetter(value="record")
    public UiClientRecord getRecord() {
        return this.record;
    }

    @JsonGetter(value="connectorLineColor")
    public UiColor getConnectorLineColor() {
        return this.connectorLineColor;
    }

    @JsonGetter(value="connectorLineWidth")
    public int getConnectorLineWidth() {
        return this.connectorLineWidth;
    }

    @JsonGetter(value="dashArray")
    public String getDashArray() {
        return this.dashArray;
    }

    @JsonGetter(value="expanded")
    public boolean getExpanded() {
        return this.expanded;
    }

    @JsonSetter(value="parentId")
    public UiTreeGraphNode setParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    @JsonSetter(value="backgroundColor")
    public UiTreeGraphNode setBackgroundColor(UiColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @JsonSetter(value="borderColor")
    public UiTreeGraphNode setBorderColor(UiColor borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    @JsonSetter(value="borderWidth")
    public UiTreeGraphNode setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    @JsonSetter(value="borderRadius")
    public UiTreeGraphNode setBorderRadius(float borderRadius) {
        this.borderRadius = borderRadius;
        return this;
    }

    @JsonSetter(value="image")
    public UiTreeGraphNode setImage(UiTreeGraphNodeImage image) {
        this.image = image;
        return this;
    }

    @JsonSetter(value="icon")
    public UiTreeGraphNode setIcon(UiTreeGraphNodeIcon icon) {
        this.icon = icon;
        return this;
    }

    @JsonSetter(value="template")
    public UiTreeGraphNode setTemplate(UiTemplate template) {
        this.template = template;
        return this;
    }

    @JsonSetter(value="record")
    public UiTreeGraphNode setRecord(UiClientRecord record) {
        this.record = record;
        return this;
    }

    @JsonSetter(value="connectorLineColor")
    public UiTreeGraphNode setConnectorLineColor(UiColor connectorLineColor) {
        this.connectorLineColor = connectorLineColor;
        return this;
    }

    @JsonSetter(value="connectorLineWidth")
    public UiTreeGraphNode setConnectorLineWidth(int connectorLineWidth) {
        this.connectorLineWidth = connectorLineWidth;
        return this;
    }

    @JsonSetter(value="dashArray")
    public UiTreeGraphNode setDashArray(String dashArray) {
        this.dashArray = dashArray;
        return this;
    }

    @JsonSetter(value="expanded")
    public UiTreeGraphNode setExpanded(boolean expanded) {
        this.expanded = expanded;
        return this;
    }
}

