/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiGraph;
import org.teamapps.dto.UiGraphData;
import org.teamapps.dto.UiLineChartMouseScrollZoomPanMode;
import org.teamapps.dto.UiLineChartYScaleZoomMode;
import org.teamapps.dto.UiLongInterval;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiScaleType;
import org.teamapps.dto.UiTimeChartZoomLevel;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiTimeGraph.class)
public class UiTimeGraph
extends UiComponent
implements UiObject {
    protected UiLineChartYScaleZoomMode yScaleZoomMode = UiLineChartYScaleZoomMode.DYNAMIC_INCLUDING_ZERO;
    protected UiLongInterval intervalX;
    protected List<UiTimeChartZoomLevel> zoomLevels;
    protected int maxPixelsBetweenDataPoints;
    protected List<UiGraph> graphs;
    protected UiScaleType yScaleType = UiScaleType.LINEAR;
    protected UiLineChartMouseScrollZoomPanMode mouseScrollZoomPanMode = UiLineChartMouseScrollZoomPanMode.ENABLED;
    protected String locale;
    protected String timeZoneId = null;

    @Deprecated
    public UiTimeGraph() {
    }

    public UiTimeGraph(UiLongInterval intervalX, List<UiTimeChartZoomLevel> zoomLevels, int maxPixelsBetweenDataPoints, List<UiGraph> graphs) {
        this.intervalX = intervalX;
        this.zoomLevels = zoomLevels;
        this.maxPixelsBetweenDataPoints = maxPixelsBetweenDataPoints;
        this.graphs = graphs;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_TIME_GRAPH;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("timeZoneId=" + this.timeZoneId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + ("yScaleZoomMode=" + this.yScaleZoomMode) + ", " + ("maxPixelsBetweenDataPoints=" + this.maxPixelsBetweenDataPoints) + ", " + (String)(this.graphs != null ? "graphs={" + this.graphs.toString() + "}" : "") + ", " + ("yScaleType=" + this.yScaleType) + ", " + ("mouseScrollZoomPanMode=" + this.mouseScrollZoomPanMode) + ", " + ("locale=" + this.locale) + ", " + (String)(this.intervalX != null ? "intervalX={" + this.intervalX.toString() + "}" : "") + ", " + (String)(this.zoomLevels != null ? "zoomLevels={" + this.zoomLevels.toString() + "}" : "");
    }

    @JsonGetter(value="yScaleZoomMode")
    public UiLineChartYScaleZoomMode getYScaleZoomMode() {
        return this.yScaleZoomMode;
    }

    @JsonGetter(value="intervalX")
    public UiLongInterval getIntervalX() {
        return this.intervalX;
    }

    @JsonGetter(value="zoomLevels")
    public List<UiTimeChartZoomLevel> getZoomLevels() {
        return this.zoomLevels;
    }

    @JsonGetter(value="maxPixelsBetweenDataPoints")
    public int getMaxPixelsBetweenDataPoints() {
        return this.maxPixelsBetweenDataPoints;
    }

    @JsonGetter(value="graphs")
    public List<UiGraph> getGraphs() {
        return this.graphs;
    }

    @JsonGetter(value="yScaleType")
    public UiScaleType getYScaleType() {
        return this.yScaleType;
    }

    @JsonGetter(value="mouseScrollZoomPanMode")
    public UiLineChartMouseScrollZoomPanMode getMouseScrollZoomPanMode() {
        return this.mouseScrollZoomPanMode;
    }

    @JsonGetter(value="locale")
    public String getLocale() {
        return this.locale;
    }

    @JsonGetter(value="timeZoneId")
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    @Override
    @JsonSetter(value="id")
    public UiTimeGraph setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiTimeGraph setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiTimeGraph setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiTimeGraph setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiTimeGraph setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiTimeGraph setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="yScaleZoomMode")
    public UiTimeGraph setYScaleZoomMode(UiLineChartYScaleZoomMode yScaleZoomMode) {
        this.yScaleZoomMode = yScaleZoomMode;
        return this;
    }

    @JsonSetter(value="yScaleType")
    public UiTimeGraph setYScaleType(UiScaleType yScaleType) {
        this.yScaleType = yScaleType;
        return this;
    }

    @JsonSetter(value="mouseScrollZoomPanMode")
    public UiTimeGraph setMouseScrollZoomPanMode(UiLineChartMouseScrollZoomPanMode mouseScrollZoomPanMode) {
        this.mouseScrollZoomPanMode = mouseScrollZoomPanMode;
        return this;
    }

    @JsonSetter(value="locale")
    public UiTimeGraph setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    @JsonSetter(value="timeZoneId")
    public UiTimeGraph setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
        return this;
    }

    public static class ZoomToCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiLongInterval intervalX;

        @Deprecated
        public ZoomToCommand() {
        }

        public ZoomToCommand(String componentId, UiLongInterval intervalX) {
            this.componentId = componentId;
            this.intervalX = intervalX;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.intervalX != null ? "intervalX={" + this.intervalX.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="intervalX")
        public UiLongInterval getIntervalX() {
            return this.intervalX;
        }
    }

    public static class AddOrUpdateGraphCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiGraph graph;

        @Deprecated
        public AddOrUpdateGraphCommand() {
        }

        public AddOrUpdateGraphCommand(String componentId, UiGraph graph) {
            this.componentId = componentId;
            this.graph = graph;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.graph != null ? "graph={" + this.graph.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="graph")
        public UiGraph getGraph() {
            return this.graph;
        }
    }

    public static class SetGraphsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<UiGraph> graphs;

        @Deprecated
        public SetGraphsCommand() {
        }

        public SetGraphsCommand(String componentId, List<UiGraph> graphs) {
            this.componentId = componentId;
            this.graphs = graphs;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.graphs != null ? "graphs={" + this.graphs.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="graphs")
        public List<UiGraph> getGraphs() {
            return this.graphs;
        }
    }

    public static class SetSelectedIntervalCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiLongInterval intervalX;

        @Deprecated
        public SetSelectedIntervalCommand() {
        }

        public SetSelectedIntervalCommand(String componentId, UiLongInterval intervalX) {
            this.componentId = componentId;
            this.intervalX = intervalX;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.intervalX != null ? "intervalX={" + this.intervalX.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="intervalX")
        public UiLongInterval getIntervalX() {
            return this.intervalX;
        }
    }

    public static class SetMouseScrollZoomPanModeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiLineChartMouseScrollZoomPanMode mouseScrollZoomPanMode;

        @Deprecated
        public SetMouseScrollZoomPanModeCommand() {
        }

        public SetMouseScrollZoomPanModeCommand(String componentId, UiLineChartMouseScrollZoomPanMode mouseScrollZoomPanMode) {
            this.componentId = componentId;
            this.mouseScrollZoomPanMode = mouseScrollZoomPanMode;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("mouseScrollZoomPanMode=" + this.mouseScrollZoomPanMode);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="mouseScrollZoomPanMode")
        public UiLineChartMouseScrollZoomPanMode getMouseScrollZoomPanMode() {
            return this.mouseScrollZoomPanMode;
        }
    }

    public static class ResetAllDataCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<UiTimeChartZoomLevel> newZoomLevels;

        @Deprecated
        public ResetAllDataCommand() {
        }

        public ResetAllDataCommand(String componentId, List<UiTimeChartZoomLevel> newZoomLevels) {
            this.componentId = componentId;
            this.newZoomLevels = newZoomLevels;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.newZoomLevels != null ? "newZoomLevels={" + this.newZoomLevels.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="newZoomLevels")
        public List<UiTimeChartZoomLevel> getNewZoomLevels() {
            return this.newZoomLevels;
        }
    }

    public static class ResetGraphDataCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String graphId;

        @Deprecated
        public ResetGraphDataCommand() {
        }

        public ResetGraphDataCommand(String componentId, String graphId) {
            this.componentId = componentId;
            this.graphId = graphId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("graphId=" + this.graphId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="graphId")
        public String getGraphId() {
            return this.graphId;
        }
    }

    public static class AddDataCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int zoomLevel;
        protected Map<String, UiGraphData> data;

        @Deprecated
        public AddDataCommand() {
        }

        public AddDataCommand(String componentId, int zoomLevel, Map<String, UiGraphData> data) {
            this.componentId = componentId;
            this.zoomLevel = zoomLevel;
            this.data = data;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("zoomLevel=" + this.zoomLevel) + ", " + (String)(this.data != null ? "data={" + this.data.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="zoomLevel")
        public int getZoomLevel() {
            return this.zoomLevel;
        }

        @JsonGetter(value="data")
        public Map<String, UiGraphData> getData() {
            return this.data;
        }
    }

    public static class SetMaxPixelsBetweenDataPointsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int maxPixelsBetweenDataPoints;

        @Deprecated
        public SetMaxPixelsBetweenDataPointsCommand() {
        }

        public SetMaxPixelsBetweenDataPointsCommand(String componentId, int maxPixelsBetweenDataPoints) {
            this.componentId = componentId;
            this.maxPixelsBetweenDataPoints = maxPixelsBetweenDataPoints;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("maxPixelsBetweenDataPoints=" + this.maxPixelsBetweenDataPoints);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="maxPixelsBetweenDataPoints")
        public int getMaxPixelsBetweenDataPoints() {
            return this.maxPixelsBetweenDataPoints;
        }
    }

    public static class SetIntervalXCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiLongInterval intervalX;

        @Deprecated
        public SetIntervalXCommand() {
        }

        public SetIntervalXCommand(String componentId, UiLongInterval intervalX) {
            this.componentId = componentId;
            this.intervalX = intervalX;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.intervalX != null ? "intervalX={" + this.intervalX.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="intervalX")
        public UiLongInterval getIntervalX() {
            return this.intervalX;
        }
    }

    public static class IntervalSelectedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected UiLongInterval intervalX;

        @Deprecated
        public IntervalSelectedEvent() {
        }

        public IntervalSelectedEvent(String componentId, UiLongInterval intervalX) {
            this.componentId = componentId;
            this.intervalX = intervalX;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TIME_GRAPH_INTERVAL_SELECTED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.intervalX != null ? "intervalX={" + this.intervalX.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="intervalX")
        public UiLongInterval getIntervalX() {
            return this.intervalX;
        }
    }

    public static class ZoomedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected UiLongInterval displayedInterval;
        protected int zoomLevelIndex;
        protected double millisecondsPerPixel;
        protected Map<String, List<UiLongInterval>> neededIntervalsByGraphId;

        @Deprecated
        public ZoomedEvent() {
        }

        public ZoomedEvent(String componentId, UiLongInterval displayedInterval, int zoomLevelIndex, double millisecondsPerPixel, Map<String, List<UiLongInterval>> neededIntervalsByGraphId) {
            this.componentId = componentId;
            this.displayedInterval = displayedInterval;
            this.zoomLevelIndex = zoomLevelIndex;
            this.millisecondsPerPixel = millisecondsPerPixel;
            this.neededIntervalsByGraphId = neededIntervalsByGraphId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TIME_GRAPH_ZOOMED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.neededIntervalsByGraphId != null ? "neededIntervalsByGraphId={" + this.neededIntervalsByGraphId.toString() + "}" : "") + ", " + ("zoomLevelIndex=" + this.zoomLevelIndex) + ", " + ("millisecondsPerPixel=" + this.millisecondsPerPixel) + ", " + (String)(this.displayedInterval != null ? "displayedInterval={" + this.displayedInterval.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="displayedInterval")
        public UiLongInterval getDisplayedInterval() {
            return this.displayedInterval;
        }

        @JsonGetter(value="zoomLevelIndex")
        public int getZoomLevelIndex() {
            return this.zoomLevelIndex;
        }

        @JsonGetter(value="millisecondsPerPixel")
        public double getMillisecondsPerPixel() {
            return this.millisecondsPerPixel;
        }

        @JsonGetter(value="neededIntervalsByGraphId")
        public Map<String, List<UiLongInterval>> getNeededIntervalsByGraphId() {
            return this.neededIntervalsByGraphId;
        }
    }
}

