/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Map;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiProgressStatus;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiProgressDisplay.class)
public class UiProgressDisplay
extends UiComponent
implements UiObject {
    protected String icon;
    protected String taskName;
    protected String statusMessage;
    protected double progress;
    protected UiProgressStatus status;
    protected boolean cancelable;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_PROGRESS_DISPLAY;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("taskName=" + this.taskName) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + ("icon=" + this.icon) + ", " + ("statusMessage=" + this.statusMessage) + ", " + ("progress=" + this.progress) + ", " + ("status=" + this.status) + ", " + ("cancelable=" + this.cancelable);
    }

    @JsonGetter(value="icon")
    public String getIcon() {
        return this.icon;
    }

    @JsonGetter(value="taskName")
    public String getTaskName() {
        return this.taskName;
    }

    @JsonGetter(value="statusMessage")
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @JsonGetter(value="progress")
    public double getProgress() {
        return this.progress;
    }

    @JsonGetter(value="status")
    public UiProgressStatus getStatus() {
        return this.status;
    }

    @JsonGetter(value="cancelable")
    public boolean getCancelable() {
        return this.cancelable;
    }

    @Override
    @JsonSetter(value="id")
    public UiProgressDisplay setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiProgressDisplay setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiProgressDisplay setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiProgressDisplay setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiProgressDisplay setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiProgressDisplay setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="icon")
    public UiProgressDisplay setIcon(String icon) {
        this.icon = icon;
        return this;
    }

    @JsonSetter(value="taskName")
    public UiProgressDisplay setTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    @JsonSetter(value="statusMessage")
    public UiProgressDisplay setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return this;
    }

    @JsonSetter(value="progress")
    public UiProgressDisplay setProgress(double progress) {
        this.progress = progress;
        return this;
    }

    @JsonSetter(value="status")
    public UiProgressDisplay setStatus(UiProgressStatus status) {
        this.status = status;
        return this;
    }

    @JsonSetter(value="cancelable")
    public UiProgressDisplay setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
        return this;
    }

    public static class UpdateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiProgressDisplay config;

        @Deprecated
        public UpdateCommand() {
        }

        public UpdateCommand(String componentId, UiProgressDisplay config) {
            this.componentId = componentId;
            this.config = config;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.config != null ? "config={" + this.config.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="config")
        public UiProgressDisplay getConfig() {
            return this.config;
        }
    }

    public static class CancelButtonClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public CancelButtonClickedEvent() {
        }

        public CancelButtonClickedEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_PROGRESS_DISPLAY_CANCEL_BUTTON_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class ClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public ClickedEvent() {
        }

        public ClickedEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_PROGRESS_DISPLAY_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }
}

