/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import org.teamapps.dto.UiBorder;
import org.teamapps.dto.UiGridColumn;
import org.teamapps.dto.UiGridPlacement;
import org.teamapps.dto.UiGridRow;
import org.teamapps.dto.UiHorizontalElementAlignment;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiShadow;
import org.teamapps.dto.UiSpacing;
import org.teamapps.dto.UiVerticalElementAlignment;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiGridLayout.class)
public class UiGridLayout
implements UiObject {
    protected List<UiGridColumn> columns;
    protected List<UiGridRow> rows;
    protected List<UiGridPlacement> componentPlacements;
    protected UiSpacing margin;
    protected UiSpacing padding;
    protected UiBorder border;
    protected UiShadow shadow;
    protected String backgroundColor;
    protected int gridGap = 7;
    protected UiVerticalElementAlignment verticalAlignment = UiVerticalElementAlignment.STRETCH;
    protected UiHorizontalElementAlignment horizontalAlignment = UiHorizontalElementAlignment.STRETCH;

    @Deprecated
    public UiGridLayout() {
    }

    public UiGridLayout(List<UiGridColumn> columns, List<UiGridRow> rows, List<UiGridPlacement> componentPlacements) {
        this.columns = columns;
        this.rows = rows;
        this.componentPlacements = componentPlacements;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_GRID_LAYOUT;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + (String)(this.componentPlacements != null ? "componentPlacements={" + this.componentPlacements.toString() + "}" : "") + ", " + ("backgroundColor=" + this.backgroundColor) + ", " + ("gridGap=" + this.gridGap) + ", " + ("verticalAlignment=" + this.verticalAlignment) + ", " + ("horizontalAlignment=" + this.horizontalAlignment) + ", " + (String)(this.columns != null ? "columns={" + this.columns.toString() + "}" : "") + ", " + (String)(this.rows != null ? "rows={" + this.rows.toString() + "}" : "") + ", " + (String)(this.margin != null ? "margin={" + this.margin.toString() + "}" : "") + ", " + (String)(this.padding != null ? "padding={" + this.padding.toString() + "}" : "") + ", " + (String)(this.border != null ? "border={" + this.border.toString() + "}" : "") + ", " + (String)(this.shadow != null ? "shadow={" + this.shadow.toString() + "}" : "");
    }

    @JsonGetter(value="columns")
    public List<UiGridColumn> getColumns() {
        return this.columns;
    }

    @JsonGetter(value="rows")
    public List<UiGridRow> getRows() {
        return this.rows;
    }

    @JsonGetter(value="componentPlacements")
    public List<UiGridPlacement> getComponentPlacements() {
        return this.componentPlacements;
    }

    @JsonGetter(value="margin")
    public UiSpacing getMargin() {
        return this.margin;
    }

    @JsonGetter(value="padding")
    public UiSpacing getPadding() {
        return this.padding;
    }

    @JsonGetter(value="border")
    public UiBorder getBorder() {
        return this.border;
    }

    @JsonGetter(value="shadow")
    public UiShadow getShadow() {
        return this.shadow;
    }

    @JsonGetter(value="backgroundColor")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @JsonGetter(value="gridGap")
    public int getGridGap() {
        return this.gridGap;
    }

    @JsonGetter(value="verticalAlignment")
    public UiVerticalElementAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @JsonGetter(value="horizontalAlignment")
    public UiHorizontalElementAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @JsonSetter(value="margin")
    public UiGridLayout setMargin(UiSpacing margin) {
        this.margin = margin;
        return this;
    }

    @JsonSetter(value="padding")
    public UiGridLayout setPadding(UiSpacing padding) {
        this.padding = padding;
        return this;
    }

    @JsonSetter(value="border")
    public UiGridLayout setBorder(UiBorder border) {
        this.border = border;
        return this;
    }

    @JsonSetter(value="shadow")
    public UiGridLayout setShadow(UiShadow shadow) {
        this.shadow = shadow;
        return this;
    }

    @JsonSetter(value="backgroundColor")
    public UiGridLayout setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @JsonSetter(value="gridGap")
    public UiGridLayout setGridGap(int gridGap) {
        this.gridGap = gridGap;
        return this;
    }

    @JsonSetter(value="verticalAlignment")
    public UiGridLayout setVerticalAlignment(UiVerticalElementAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @JsonSetter(value="horizontalAlignment")
    public UiGridLayout setHorizontalAlignment(UiHorizontalElementAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }
}

