/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.AbstractUiMapShape;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiHeatMapData;
import org.teamapps.dto.UiMapArea;
import org.teamapps.dto.UiMapConfig;
import org.teamapps.dto.UiMapLocation;
import org.teamapps.dto.UiMapMarkerClientRecord;
import org.teamapps.dto.UiMapMarkerCluster;
import org.teamapps.dto.UiMapShapeType;
import org.teamapps.dto.UiMapType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiShapeProperties;
import org.teamapps.dto.UiTemplate;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiMap.class)
public class UiMap
extends UiComponent
implements UiObject {
    protected Map<String, UiTemplate> markerTemplates;
    protected String accessToken;
    protected UiMapConfig mapConfig;
    protected UiMapType mapType = UiMapType.MAP_BOX_STREETS;
    protected int zoomLevel = 5;
    protected UiMapLocation mapPosition;
    protected Map<String, AbstractUiMapShape> shapes;
    protected List<UiMapMarkerClientRecord> markers;
    protected UiMapMarkerCluster markerCluster;

    @Deprecated
    public UiMap() {
    }

    public UiMap(Map<String, UiTemplate> markerTemplates) {
        this.markerTemplates = markerTemplates;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_MAP;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + (String)(this.markerTemplates != null ? "markerTemplates={" + this.markerTemplates.toString() + "}" : "") + ", " + ("accessToken=" + this.accessToken) + ", " + ("mapType=" + this.mapType) + ", " + ("zoomLevel=" + this.zoomLevel) + ", " + (String)(this.mapConfig != null ? "mapConfig={" + this.mapConfig.toString() + "}" : "") + ", " + (String)(this.mapPosition != null ? "mapPosition={" + this.mapPosition.toString() + "}" : "") + ", " + (String)(this.shapes != null ? "shapes={" + this.shapes.toString() + "}" : "") + ", " + (String)(this.markers != null ? "markers={" + this.markers.toString() + "}" : "") + ", " + (String)(this.markerCluster != null ? "markerCluster={" + this.markerCluster.toString() + "}" : "");
    }

    @JsonGetter(value="markerTemplates")
    public Map<String, UiTemplate> getMarkerTemplates() {
        return this.markerTemplates;
    }

    @JsonGetter(value="accessToken")
    public String getAccessToken() {
        return this.accessToken;
    }

    @JsonGetter(value="mapConfig")
    public UiMapConfig getMapConfig() {
        return this.mapConfig;
    }

    @JsonGetter(value="mapType")
    public UiMapType getMapType() {
        return this.mapType;
    }

    @JsonGetter(value="zoomLevel")
    public int getZoomLevel() {
        return this.zoomLevel;
    }

    @JsonGetter(value="mapPosition")
    public UiMapLocation getMapPosition() {
        return this.mapPosition;
    }

    @JsonGetter(value="shapes")
    public Map<String, AbstractUiMapShape> getShapes() {
        return this.shapes;
    }

    @JsonGetter(value="markers")
    public List<UiMapMarkerClientRecord> getMarkers() {
        return this.markers;
    }

    @JsonGetter(value="markerCluster")
    public UiMapMarkerCluster getMarkerCluster() {
        return this.markerCluster;
    }

    @Override
    @JsonSetter(value="id")
    public UiMap setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiMap setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiMap setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiMap setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiMap setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiMap setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="accessToken")
    public UiMap setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @JsonSetter(value="mapConfig")
    public UiMap setMapConfig(UiMapConfig mapConfig) {
        this.mapConfig = mapConfig;
        return this;
    }

    @JsonSetter(value="mapType")
    public UiMap setMapType(UiMapType mapType) {
        this.mapType = mapType;
        return this;
    }

    @JsonSetter(value="zoomLevel")
    public UiMap setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
        return this;
    }

    @JsonSetter(value="mapPosition")
    public UiMap setMapPosition(UiMapLocation mapPosition) {
        this.mapPosition = mapPosition;
        return this;
    }

    @JsonSetter(value="shapes")
    public UiMap setShapes(Map<String, AbstractUiMapShape> shapes) {
        this.shapes = shapes;
        return this;
    }

    @JsonSetter(value="markers")
    public UiMap setMarkers(List<UiMapMarkerClientRecord> markers) {
        this.markers = markers;
        return this;
    }

    @JsonSetter(value="markerCluster")
    public UiMap setMarkerCluster(UiMapMarkerCluster markerCluster) {
        this.markerCluster = markerCluster;
        return this;
    }

    public static class FitBoundsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiMapLocation southWest;
        protected UiMapLocation northEast;

        @Deprecated
        public FitBoundsCommand() {
        }

        public FitBoundsCommand(String componentId, UiMapLocation southWest, UiMapLocation northEast) {
            this.componentId = componentId;
            this.southWest = southWest;
            this.northEast = northEast;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.southWest != null ? "southWest={" + this.southWest.toString() + "}" : "") + ", " + (String)(this.northEast != null ? "northEast={" + this.northEast.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="southWest")
        public UiMapLocation getSouthWest() {
            return this.southWest;
        }

        @JsonGetter(value="northEast")
        public UiMapLocation getNorthEast() {
            return this.northEast;
        }
    }

    public static class SetHeatMapCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiHeatMapData data;

        @Deprecated
        public SetHeatMapCommand() {
        }

        public SetHeatMapCommand(String componentId, UiHeatMapData data) {
            this.componentId = componentId;
            this.data = data;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.data != null ? "data={" + this.data.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="data")
        public UiHeatMapData getData() {
            return this.data;
        }
    }

    public static class SetMapTypeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiMapType mapType;

        @Deprecated
        public SetMapTypeCommand() {
        }

        public SetMapTypeCommand(String componentId, UiMapType mapType) {
            this.componentId = componentId;
            this.mapType = mapType;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("mapType=" + this.mapType);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="mapType")
        public UiMapType getMapType() {
            return this.mapType;
        }
    }

    public static class SetLocationCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiMapLocation location;

        @Deprecated
        public SetLocationCommand() {
        }

        public SetLocationCommand(String componentId, UiMapLocation location) {
            this.componentId = componentId;
            this.location = location;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.location != null ? "location={" + this.location.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="location")
        public UiMapLocation getLocation() {
            return this.location;
        }
    }

    public static class SetZoomLevelCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int zoom;

        @Deprecated
        public SetZoomLevelCommand() {
        }

        public SetZoomLevelCommand(String componentId, int zoom) {
            this.componentId = componentId;
            this.zoom = zoom;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("zoom=" + this.zoom);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="zoom")
        public int getZoom() {
            return this.zoom;
        }
    }

    public static class StopDrawingShapeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public StopDrawingShapeCommand() {
        }

        public StopDrawingShapeCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class StartDrawingShapeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiMapShapeType shapeType;
        protected UiShapeProperties shapeProperties;

        @Deprecated
        public StartDrawingShapeCommand() {
        }

        public StartDrawingShapeCommand(String componentId, UiMapShapeType shapeType, UiShapeProperties shapeProperties) {
            this.componentId = componentId;
            this.shapeType = shapeType;
            this.shapeProperties = shapeProperties;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("shapeType=" + this.shapeType) + ", " + (String)(this.shapeProperties != null ? "shapeProperties={" + this.shapeProperties.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="shapeType")
        public UiMapShapeType getShapeType() {
            return this.shapeType;
        }

        @JsonGetter(value="shapeProperties")
        public UiShapeProperties getShapeProperties() {
            return this.shapeProperties;
        }
    }

    public static class ClearHeatMapCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public ClearHeatMapCommand() {
        }

        public ClearHeatMapCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class ClearMarkerClusterCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public ClearMarkerClusterCommand() {
        }

        public ClearMarkerClusterCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class ClearMarkersCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public ClearMarkersCommand() {
        }

        public ClearMarkersCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class ClearShapesCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public ClearShapesCommand() {
        }

        public ClearShapesCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class RemoveShapeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String shapeId;

        @Deprecated
        public RemoveShapeCommand() {
        }

        public RemoveShapeCommand(String componentId, String shapeId) {
            this.componentId = componentId;
            this.shapeId = shapeId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("shapeId=" + this.shapeId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="shapeId")
        public String getShapeId() {
            return this.shapeId;
        }
    }

    public static class UpdateShapeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String shapeId;
        protected AbstractUiMapShape shape;

        @Deprecated
        public UpdateShapeCommand() {
        }

        public UpdateShapeCommand(String componentId, String shapeId, AbstractUiMapShape shape) {
            this.componentId = componentId;
            this.shapeId = shapeId;
            this.shape = shape;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("shapeId=" + this.shapeId) + ", " + (String)(this.shape != null ? "shape={" + this.shape.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="shapeId")
        public String getShapeId() {
            return this.shapeId;
        }

        @JsonGetter(value="shape")
        public AbstractUiMapShape getShape() {
            return this.shape;
        }
    }

    public static class AddShapeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String shapeId;
        protected AbstractUiMapShape shape;

        @Deprecated
        public AddShapeCommand() {
        }

        public AddShapeCommand(String componentId, String shapeId, AbstractUiMapShape shape) {
            this.componentId = componentId;
            this.shapeId = shapeId;
            this.shape = shape;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("shapeId=" + this.shapeId) + ", " + (String)(this.shape != null ? "shape={" + this.shape.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="shapeId")
        public String getShapeId() {
            return this.shapeId;
        }

        @JsonGetter(value="shape")
        public AbstractUiMapShape getShape() {
            return this.shape;
        }
    }

    public static class SetMapMarkerClusterCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiMapMarkerCluster cluster;

        @Deprecated
        public SetMapMarkerClusterCommand() {
        }

        public SetMapMarkerClusterCommand(String componentId, UiMapMarkerCluster cluster) {
            this.componentId = componentId;
            this.cluster = cluster;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.cluster != null ? "cluster={" + this.cluster.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="cluster")
        public UiMapMarkerCluster getCluster() {
            return this.cluster;
        }
    }

    public static class RemoveMarkerCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int id;

        @Deprecated
        public RemoveMarkerCommand() {
        }

        public RemoveMarkerCommand(String componentId, int id) {
            this.componentId = componentId;
            this.id = id;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="id")
        public int getId() {
            return this.id;
        }
    }

    public static class AddMarkerCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiMapMarkerClientRecord marker;

        @Deprecated
        public AddMarkerCommand() {
        }

        public AddMarkerCommand(String componentId, UiMapMarkerClientRecord marker) {
            this.componentId = componentId;
            this.marker = marker;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.marker != null ? "marker={" + this.marker.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="marker")
        public UiMapMarkerClientRecord getMarker() {
            return this.marker;
        }
    }

    public static class RegisterTemplateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String id;
        protected UiTemplate template;

        @Deprecated
        public RegisterTemplateCommand() {
        }

        public RegisterTemplateCommand(String componentId, String id, UiTemplate template) {
            this.componentId = componentId;
            this.id = id;
            this.template = template;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("componentId=" + this.componentId) + ", " + (String)(this.template != null ? "template={" + this.template.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }

        @JsonGetter(value="template")
        public UiTemplate getTemplate() {
            return this.template;
        }
    }

    public static class ShapeDrawnEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String shapeId;
        protected AbstractUiMapShape shape;

        @Deprecated
        public ShapeDrawnEvent() {
        }

        public ShapeDrawnEvent(String componentId, String shapeId, AbstractUiMapShape shape) {
            this.componentId = componentId;
            this.shapeId = shapeId;
            this.shape = shape;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MAP_SHAPE_DRAWN;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("shapeId=" + this.shapeId) + ", " + (String)(this.shape != null ? "shape={" + this.shape.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="shapeId")
        public String getShapeId() {
            return this.shapeId;
        }

        @JsonGetter(value="shape")
        public AbstractUiMapShape getShape() {
            return this.shape;
        }
    }

    public static class MarkerClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int markerId;

        @Deprecated
        public MarkerClickedEvent() {
        }

        public MarkerClickedEvent(String componentId, int markerId) {
            this.componentId = componentId;
            this.markerId = markerId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MAP_MARKER_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("markerId=" + this.markerId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="markerId")
        public int getMarkerId() {
            return this.markerId;
        }
    }

    public static class MapClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected UiMapLocation location;

        @Deprecated
        public MapClickedEvent() {
        }

        public MapClickedEvent(String componentId, UiMapLocation location) {
            this.componentId = componentId;
            this.location = location;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MAP_MAP_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.location != null ? "location={" + this.location.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="location")
        public UiMapLocation getLocation() {
            return this.location;
        }
    }

    public static class LocationChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected UiMapLocation center;
        protected UiMapArea displayedArea;

        @Deprecated
        public LocationChangedEvent() {
        }

        public LocationChangedEvent(String componentId, UiMapLocation center, UiMapArea displayedArea) {
            this.componentId = componentId;
            this.center = center;
            this.displayedArea = displayedArea;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MAP_LOCATION_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.center != null ? "center={" + this.center.toString() + "}" : "") + ", " + (String)(this.displayedArea != null ? "displayedArea={" + this.displayedArea.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="center")
        public UiMapLocation getCenter() {
            return this.center;
        }

        @JsonGetter(value="displayedArea")
        public UiMapArea getDisplayedArea() {
            return this.displayedArea;
        }
    }

    public static class ZoomLevelChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int zoomLevel;

        @Deprecated
        public ZoomLevelChangedEvent() {
        }

        public ZoomLevelChangedEvent(String componentId, int zoomLevel) {
            this.componentId = componentId;
            this.zoomLevel = zoomLevel;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MAP_ZOOM_LEVEL_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("zoomLevel=" + this.zoomLevel);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="zoomLevel")
        public int getZoomLevel() {
            return this.zoomLevel;
        }
    }
}

