package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiTable extends UiComponent implements UiObject {


	protected List<UiTableColumn> columns;
	protected boolean displayAsList;
	protected boolean forceFitWidth;
	protected int rowHeight = 28;
	protected boolean stripedRows = true;
	protected UiColor stripedRowColorEven = new UiColor(255, 255, 255);
	protected UiColor stripedRowColorOdd = new UiColor(0, 0, 0).setAlpha(0.05f);
	protected boolean hideHeaders;
	protected boolean allowMultiRowSelection = true;
	protected UiColor selectionColor = new UiColor(222, 238, 255);
	protected int rowBorderWidth = 1;
	protected UiColor rowBorderColor = new UiColor(204, 204, 204);
	protected boolean showRowCheckBoxes;
	protected boolean showNumbering;
	protected List<UiTableClientRecord> tableData;
	protected int totalNumberOfRecords;
	protected String sortField;
	protected UiSortDirection sortDirection = UiSortDirection.ASC;
	protected boolean editable;
	protected boolean treeMode;
	protected String indentedColumnName;
	protected int indentation = 15;
	protected UiSelectionFrame selectionFrame;
	protected boolean showHeaderRow = false;
	protected int headerRowBorderWidth = 1;
	protected UiColor headerRowBorderColor = new UiColor(204, 204, 204);
	protected int headerRowHeight = 28;
	protected UiColor headerRowBackgroundColor = new UiColor(0, 0, 0).setAlpha(0.05f);
	protected Map<String, UiComponentReference> headerRowFields;
	protected boolean showFooterRow = false;
	protected int footerRowBorderWidth = 1;
	protected UiColor footerRowBorderColor = new UiColor(204, 204, 204);
	protected int footerRowHeight = 28;
	protected UiColor footerRowBackgroundColor = new UiColor(0, 0, 0).setAlpha(0.05f);
	protected Map<String, UiComponentReference> footerRowFields;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiTable() {
		// default constructor for Jackson
	}

	public UiTable(String id, List<UiTableColumn> columns) {
		super(id);
		this.columns = columns;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_TABLE;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("indentedColumnName=" + indentedColumnName).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("displayAsList=" + displayAsList).append(", ")
				.append("forceFitWidth=" + forceFitWidth).append(", ")
				.append("rowHeight=" + rowHeight).append(", ")
				.append("stripedRows=" + stripedRows).append(", ")
				.append("hideHeaders=" + hideHeaders).append(", ")
				.append("allowMultiRowSelection=" + allowMultiRowSelection).append(", ")
				.append("rowBorderWidth=" + rowBorderWidth).append(", ")
				.append("showRowCheckBoxes=" + showRowCheckBoxes).append(", ")
				.append("showNumbering=" + showNumbering).append(", ")
				.append("totalNumberOfRecords=" + totalNumberOfRecords).append(", ")
				.append("sortField=" + sortField).append(", ")
				.append("sortDirection=" + sortDirection).append(", ")
				.append("editable=" + editable).append(", ")
				.append("treeMode=" + treeMode).append(", ")
				.append("indentation=" + indentation).append(", ")
				.append("showHeaderRow=" + showHeaderRow).append(", ")
				.append("headerRowBorderWidth=" + headerRowBorderWidth).append(", ")
				.append("headerRowHeight=" + headerRowHeight).append(", ")
				.append("showFooterRow=" + showFooterRow).append(", ")
				.append("footerRowBorderWidth=" + footerRowBorderWidth).append(", ")
				.append("footerRowHeight=" + footerRowHeight).append(", ")
				.append(columns != null ? "columns={" + columns.toString() + "}" : "").append(", ")
				.append(stripedRowColorEven != null ? "stripedRowColorEven={" + stripedRowColorEven.toString() + "}" : "").append(", ")
				.append(stripedRowColorOdd != null ? "stripedRowColorOdd={" + stripedRowColorOdd.toString() + "}" : "").append(", ")
				.append(selectionColor != null ? "selectionColor={" + selectionColor.toString() + "}" : "").append(", ")
				.append(rowBorderColor != null ? "rowBorderColor={" + rowBorderColor.toString() + "}" : "").append(", ")
				.append(tableData != null ? "tableData={" + tableData.toString() + "}" : "").append(", ")
				.append(selectionFrame != null ? "selectionFrame={" + selectionFrame.toString() + "}" : "").append(", ")
				.append(headerRowBorderColor != null ? "headerRowBorderColor={" + headerRowBorderColor.toString() + "}" : "").append(", ")
				.append(headerRowBackgroundColor != null ? "headerRowBackgroundColor={" + headerRowBackgroundColor.toString() + "}" : "").append(", ")
				.append(headerRowFields != null ? "headerRowFields={" + headerRowFields.toString() + "}" : "").append(", ")
				.append(footerRowBorderColor != null ? "footerRowBorderColor={" + footerRowBorderColor.toString() + "}" : "").append(", ")
				.append(footerRowBackgroundColor != null ? "footerRowBackgroundColor={" + footerRowBackgroundColor.toString() + "}" : "").append(", ")
				.append(footerRowFields != null ? "footerRowFields={" + footerRowFields.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("columns")
	public List<UiTableColumn> getColumns() {
		return columns;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("displayAsList")
	public boolean getDisplayAsList() {
		return displayAsList;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("forceFitWidth")
	public boolean getForceFitWidth() {
		return forceFitWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("rowHeight")
	public int getRowHeight() {
		return rowHeight;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("stripedRows")
	public boolean getStripedRows() {
		return stripedRows;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("stripedRowColorEven")
	public UiColor getStripedRowColorEven() {
		return stripedRowColorEven;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("stripedRowColorOdd")
	public UiColor getStripedRowColorOdd() {
		return stripedRowColorOdd;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("hideHeaders")
	public boolean getHideHeaders() {
		return hideHeaders;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("allowMultiRowSelection")
	public boolean getAllowMultiRowSelection() {
		return allowMultiRowSelection;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("selectionColor")
	public UiColor getSelectionColor() {
		return selectionColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("rowBorderWidth")
	public int getRowBorderWidth() {
		return rowBorderWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("rowBorderColor")
	public UiColor getRowBorderColor() {
		return rowBorderColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("showRowCheckBoxes")
	public boolean getShowRowCheckBoxes() {
		return showRowCheckBoxes;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("showNumbering")
	public boolean getShowNumbering() {
		return showNumbering;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("tableData")
	public List<UiTableClientRecord> getTableData() {
		return tableData;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("totalNumberOfRecords")
	public int getTotalNumberOfRecords() {
		return totalNumberOfRecords;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("sortField")
	public String getSortField() {
		return sortField;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("sortDirection")
	public UiSortDirection getSortDirection() {
		return sortDirection;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("editable")
	public boolean getEditable() {
		return editable;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("treeMode")
	public boolean getTreeMode() {
		return treeMode;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("indentedColumnName")
	public String getIndentedColumnName() {
		return indentedColumnName;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("indentation")
	public int getIndentation() {
		return indentation;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("selectionFrame")
	public UiSelectionFrame getSelectionFrame() {
		return selectionFrame;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("showHeaderRow")
	public boolean getShowHeaderRow() {
		return showHeaderRow;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("headerRowBorderWidth")
	public int getHeaderRowBorderWidth() {
		return headerRowBorderWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("headerRowBorderColor")
	public UiColor getHeaderRowBorderColor() {
		return headerRowBorderColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("headerRowHeight")
	public int getHeaderRowHeight() {
		return headerRowHeight;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("headerRowBackgroundColor")
	public UiColor getHeaderRowBackgroundColor() {
		return headerRowBackgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("headerRowFields")
	public Map<String, UiComponentReference> getHeaderRowFields() {
		return headerRowFields;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("showFooterRow")
	public boolean getShowFooterRow() {
		return showFooterRow;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("footerRowBorderWidth")
	public int getFooterRowBorderWidth() {
		return footerRowBorderWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("footerRowBorderColor")
	public UiColor getFooterRowBorderColor() {
		return footerRowBorderColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("footerRowHeight")
	public int getFooterRowHeight() {
		return footerRowHeight;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("footerRowBackgroundColor")
	public UiColor getFooterRowBackgroundColor() {
		return footerRowBackgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("footerRowFields")
	public Map<String, UiComponentReference> getFooterRowFields() {
		return footerRowFields;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiTable setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiTable setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("displayAsList")
	public UiTable setDisplayAsList(boolean displayAsList) {
		this.displayAsList = displayAsList;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("forceFitWidth")
	public UiTable setForceFitWidth(boolean forceFitWidth) {
		this.forceFitWidth = forceFitWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("rowHeight")
	public UiTable setRowHeight(int rowHeight) {
		this.rowHeight = rowHeight;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stripedRows")
	public UiTable setStripedRows(boolean stripedRows) {
		this.stripedRows = stripedRows;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stripedRowColorEven")
	public UiTable setStripedRowColorEven(UiColor stripedRowColorEven) {
		this.stripedRowColorEven = stripedRowColorEven;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stripedRowColorOdd")
	public UiTable setStripedRowColorOdd(UiColor stripedRowColorOdd) {
		this.stripedRowColorOdd = stripedRowColorOdd;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("hideHeaders")
	public UiTable setHideHeaders(boolean hideHeaders) {
		this.hideHeaders = hideHeaders;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("allowMultiRowSelection")
	public UiTable setAllowMultiRowSelection(boolean allowMultiRowSelection) {
		this.allowMultiRowSelection = allowMultiRowSelection;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("selectionColor")
	public UiTable setSelectionColor(UiColor selectionColor) {
		this.selectionColor = selectionColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("rowBorderWidth")
	public UiTable setRowBorderWidth(int rowBorderWidth) {
		this.rowBorderWidth = rowBorderWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("rowBorderColor")
	public UiTable setRowBorderColor(UiColor rowBorderColor) {
		this.rowBorderColor = rowBorderColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("showRowCheckBoxes")
	public UiTable setShowRowCheckBoxes(boolean showRowCheckBoxes) {
		this.showRowCheckBoxes = showRowCheckBoxes;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("showNumbering")
	public UiTable setShowNumbering(boolean showNumbering) {
		this.showNumbering = showNumbering;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("tableData")
	public UiTable setTableData(List<UiTableClientRecord> tableData) {
		this.tableData = tableData;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("totalNumberOfRecords")
	public UiTable setTotalNumberOfRecords(int totalNumberOfRecords) {
		this.totalNumberOfRecords = totalNumberOfRecords;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("sortField")
	public UiTable setSortField(String sortField) {
		this.sortField = sortField;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("sortDirection")
	public UiTable setSortDirection(UiSortDirection sortDirection) {
		this.sortDirection = sortDirection;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("editable")
	public UiTable setEditable(boolean editable) {
		this.editable = editable;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("treeMode")
	public UiTable setTreeMode(boolean treeMode) {
		this.treeMode = treeMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("indentedColumnName")
	public UiTable setIndentedColumnName(String indentedColumnName) {
		this.indentedColumnName = indentedColumnName;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("indentation")
	public UiTable setIndentation(int indentation) {
		this.indentation = indentation;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("selectionFrame")
	public UiTable setSelectionFrame(UiSelectionFrame selectionFrame) {
		this.selectionFrame = selectionFrame;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("showHeaderRow")
	public UiTable setShowHeaderRow(boolean showHeaderRow) {
		this.showHeaderRow = showHeaderRow;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("headerRowBorderWidth")
	public UiTable setHeaderRowBorderWidth(int headerRowBorderWidth) {
		this.headerRowBorderWidth = headerRowBorderWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("headerRowBorderColor")
	public UiTable setHeaderRowBorderColor(UiColor headerRowBorderColor) {
		this.headerRowBorderColor = headerRowBorderColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("headerRowHeight")
	public UiTable setHeaderRowHeight(int headerRowHeight) {
		this.headerRowHeight = headerRowHeight;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("headerRowBackgroundColor")
	public UiTable setHeaderRowBackgroundColor(UiColor headerRowBackgroundColor) {
		this.headerRowBackgroundColor = headerRowBackgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("headerRowFields")
	public UiTable setHeaderRowFields(Map<String, UiComponentReference> headerRowFields) {
		this.headerRowFields = headerRowFields;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("showFooterRow")
	public UiTable setShowFooterRow(boolean showFooterRow) {
		this.showFooterRow = showFooterRow;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("footerRowBorderWidth")
	public UiTable setFooterRowBorderWidth(int footerRowBorderWidth) {
		this.footerRowBorderWidth = footerRowBorderWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("footerRowBorderColor")
	public UiTable setFooterRowBorderColor(UiColor footerRowBorderColor) {
		this.footerRowBorderColor = footerRowBorderColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("footerRowHeight")
	public UiTable setFooterRowHeight(int footerRowHeight) {
		this.footerRowHeight = footerRowHeight;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("footerRowBackgroundColor")
	public UiTable setFooterRowBackgroundColor(UiColor footerRowBackgroundColor) {
		this.footerRowBackgroundColor = footerRowBackgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("footerRowFields")
	public UiTable setFooterRowFields(Map<String, UiComponentReference> footerRowFields) {
		this.footerRowFields = footerRowFields;
		return this;
	}

	public static class CellEditingStartedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int recordId;
		protected String columnPropertyName;

		@JsonSerialize(using = ObjectSerializer.class)
		@JsonDeserialize(using = ObjectDeserializer.class)
		protected Object currentValue;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public CellEditingStartedEvent() {
			// default constructor for Jackson
		}

		public CellEditingStartedEvent(String componentId, int recordId, String columnPropertyName, Object currentValue) {
			this.componentId = componentId;
			this.recordId = recordId;
			this.columnPropertyName = columnPropertyName;
			this.currentValue = currentValue;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TABLE_CELL_EDITING_STARTED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("recordId=" + recordId).append(", ")
					.append("columnPropertyName=" + columnPropertyName).append(", ")
					.append("currentValue=" + currentValue)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("recordId")
		public int getRecordId() {
			return recordId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("columnPropertyName")
		public String getColumnPropertyName() {
			return columnPropertyName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("currentValue")
		public Object getCurrentValue() {
			return currentValue;
		}

	}

	public static class CellEditingStoppedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int recordId;
		protected String columnPropertyName;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public CellEditingStoppedEvent() {
			// default constructor for Jackson
		}

		public CellEditingStoppedEvent(String componentId, int recordId, String columnPropertyName) {
			this.componentId = componentId;
			this.recordId = recordId;
			this.columnPropertyName = columnPropertyName;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TABLE_CELL_EDITING_STOPPED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("recordId=" + recordId).append(", ")
					.append("columnPropertyName=" + columnPropertyName)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("recordId")
		public int getRecordId() {
			return recordId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("columnPropertyName")
		public String getColumnPropertyName() {
			return columnPropertyName;
		}

	}

	public static class RowSelectedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int recordId;
		protected boolean isRightMouseButton;
		protected boolean isDoubleClick;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RowSelectedEvent() {
			// default constructor for Jackson
		}

		public RowSelectedEvent(String componentId, int recordId, boolean isRightMouseButton, boolean isDoubleClick) {
			this.componentId = componentId;
			this.recordId = recordId;
			this.isRightMouseButton = isRightMouseButton;
			this.isDoubleClick = isDoubleClick;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TABLE_ROW_SELECTED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("recordId=" + recordId).append(", ")
					.append("isRightMouseButton=" + isRightMouseButton).append(", ")
					.append("isDoubleClick=" + isDoubleClick)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("recordId")
		public int getRecordId() {
			return recordId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("isRightMouseButton")
		public boolean getIsRightMouseButton() {
			return isRightMouseButton;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("isDoubleClick")
		public boolean getIsDoubleClick() {
			return isDoubleClick;
		}

	}

	public static class MultipleRowsSelectedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected List<Integer> recordIds;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public MultipleRowsSelectedEvent() {
			// default constructor for Jackson
		}

		public MultipleRowsSelectedEvent(String componentId, List<Integer> recordIds) {
			this.componentId = componentId;
			this.recordIds = recordIds;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TABLE_MULTIPLE_ROWS_SELECTED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("recordIds=" + recordIds)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("recordIds")
		public List<Integer> getRecordIds() {
			return recordIds;
		}

	}

	public static class SortingChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String sortField;
		protected UiSortDirection sortDirection;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SortingChangedEvent() {
			// default constructor for Jackson
		}

		public SortingChangedEvent(String componentId, String sortField, UiSortDirection sortDirection) {
			this.componentId = componentId;
			this.sortField = sortField;
			this.sortDirection = sortDirection;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TABLE_SORTING_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("sortField=" + sortField).append(", ")
					.append("sortDirection=" + sortDirection)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sortField")
		public String getSortField() {
			return sortField;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sortDirection")
		public UiSortDirection getSortDirection() {
			return sortDirection;
		}

	}

	public static class DisplayedRangeChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int startIndex;
		protected int length;
		protected List<Integer> displayedRecordIds;
		protected UiTableDataRequest dataRequest;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public DisplayedRangeChangedEvent() {
			// default constructor for Jackson
		}

		public DisplayedRangeChangedEvent(String componentId, int startIndex, int length, List<Integer> displayedRecordIds, UiTableDataRequest dataRequest) {
			this.componentId = componentId;
			this.startIndex = startIndex;
			this.length = length;
			this.displayedRecordIds = displayedRecordIds;
			this.dataRequest = dataRequest;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TABLE_DISPLAYED_RANGE_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("displayedRecordIds=" + displayedRecordIds).append(", ")
					.append("startIndex=" + startIndex).append(", ")
					.append("length=" + length).append(", ")
					.append(dataRequest != null ? "dataRequest={" + dataRequest.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("startIndex")
		public int getStartIndex() {
			return startIndex;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("length")
		public int getLength() {
			return length;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("displayedRecordIds")
		public List<Integer> getDisplayedRecordIds() {
			return displayedRecordIds;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("dataRequest")
		public UiTableDataRequest getDataRequest() {
			return dataRequest;
		}

	}

	public static class RequestNestedDataEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int recordId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RequestNestedDataEvent() {
			// default constructor for Jackson
		}

		public RequestNestedDataEvent(String componentId, int recordId) {
			this.componentId = componentId;
			this.recordId = recordId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TABLE_REQUEST_NESTED_DATA;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("recordId=" + recordId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("recordId")
		public int getRecordId() {
			return recordId;
		}

	}

	public static class FieldOrderChangeEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String columnPropertyName;
		protected int position;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public FieldOrderChangeEvent() {
			// default constructor for Jackson
		}

		public FieldOrderChangeEvent(String componentId, String columnPropertyName, int position) {
			this.componentId = componentId;
			this.columnPropertyName = columnPropertyName;
			this.position = position;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TABLE_FIELD_ORDER_CHANGE;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("columnPropertyName=" + columnPropertyName).append(", ")
					.append("position=" + position)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("columnPropertyName")
		public String getColumnPropertyName() {
			return columnPropertyName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("position")
		public int getPosition() {
			return position;
		}

	}

	public static class ColumnSizeChangeEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String columnPropertyName;
		protected int size;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ColumnSizeChangeEvent() {
			// default constructor for Jackson
		}

		public ColumnSizeChangeEvent(String componentId, String columnPropertyName, int size) {
			this.componentId = componentId;
			this.columnPropertyName = columnPropertyName;
			this.size = size;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TABLE_COLUMN_SIZE_CHANGE;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("columnPropertyName=" + columnPropertyName).append(", ")
					.append("size=" + size)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("columnPropertyName")
		public String getColumnPropertyName() {
			return columnPropertyName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("size")
		public int getSize() {
			return size;
		}

	}

	public static class ClearTableCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ClearTableCommand() {
			// default constructor for Jackson
		}

		public ClearTableCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class AddDataCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int startRowIndex;
		protected List<UiTableClientRecord> data;
		protected int totalNumberOfRecords;
		protected String sortField;
		protected UiSortDirection sortDirection;
		protected boolean clearTableCache;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddDataCommand() {
			// default constructor for Jackson
		}

		public AddDataCommand(String componentId, int startRowIndex, List<UiTableClientRecord> data, int totalNumberOfRecords, String sortField, UiSortDirection sortDirection, boolean clearTableCache) {
			this.componentId = componentId;
			this.startRowIndex = startRowIndex;
			this.data = data;
			this.totalNumberOfRecords = totalNumberOfRecords;
			this.sortField = sortField;
			this.sortDirection = sortDirection;
			this.clearTableCache = clearTableCache;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("startRowIndex=" + startRowIndex).append(", ")
					.append("totalNumberOfRecords=" + totalNumberOfRecords).append(", ")
					.append("sortField=" + sortField).append(", ")
					.append("sortDirection=" + sortDirection).append(", ")
					.append("clearTableCache=" + clearTableCache).append(", ")
					.append(data != null ? "data={" + data.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("startRowIndex")
		public int getStartRowIndex() {
			return startRowIndex;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("data")
		public List<UiTableClientRecord> getData() {
			return data;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("totalNumberOfRecords")
		public int getTotalNumberOfRecords() {
			return totalNumberOfRecords;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sortField")
		public String getSortField() {
			return sortField;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sortDirection")
		public UiSortDirection getSortDirection() {
			return sortDirection;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("clearTableCache")
		public boolean getClearTableCache() {
			return clearTableCache;
		}

	}

	public static class RemoveDataCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<Integer> ids;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveDataCommand() {
			// default constructor for Jackson
		}

		public RemoveDataCommand(String componentId, List<Integer> ids) {
			this.componentId = componentId;
			this.ids = ids;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("ids=" + ids)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("ids")
		public List<Integer> getIds() {
			return ids;
		}

	}

	public static class InsertRowsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int index;
		protected List<UiTableClientRecord> data;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public InsertRowsCommand() {
			// default constructor for Jackson
		}

		public InsertRowsCommand(String componentId, int index, List<UiTableClientRecord> data) {
			this.componentId = componentId;
			this.index = index;
			this.data = data;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("index=" + index).append(", ")
					.append(data != null ? "data={" + data.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("index")
		public int getIndex() {
			return index;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("data")
		public List<UiTableClientRecord> getData() {
			return data;
		}

	}

	public static class DeleteRowsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<Integer> ids;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public DeleteRowsCommand() {
			// default constructor for Jackson
		}

		public DeleteRowsCommand(String componentId, List<Integer> ids) {
			this.componentId = componentId;
			this.ids = ids;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("ids=" + ids)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("ids")
		public List<Integer> getIds() {
			return ids;
		}

	}

	public static class UpdateRecordCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiTableClientRecord record;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UpdateRecordCommand() {
			// default constructor for Jackson
		}

		public UpdateRecordCommand(String componentId, UiTableClientRecord record) {
			this.componentId = componentId;
			this.record = record;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(record != null ? "record={" + record.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("record")
		public UiTableClientRecord getRecord() {
			return record;
		}

	}

	public static class SetCellValueCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int recordId;
		protected String columnPropertyName;

		@JsonSerialize(using = ObjectSerializer.class)
		@JsonDeserialize(using = ObjectDeserializer.class)
		protected Object value;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetCellValueCommand() {
			// default constructor for Jackson
		}

		public SetCellValueCommand(String componentId, int recordId, String columnPropertyName, Object value) {
			this.componentId = componentId;
			this.recordId = recordId;
			this.columnPropertyName = columnPropertyName;
			this.value = value;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("recordId=" + recordId).append(", ")
					.append("columnPropertyName=" + columnPropertyName).append(", ")
					.append("value=" + value)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("recordId")
		public int getRecordId() {
			return recordId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("columnPropertyName")
		public String getColumnPropertyName() {
			return columnPropertyName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("value")
		public Object getValue() {
			return value;
		}

	}

	public static class SetChildrenDataCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int parentRecordId;
		protected List<UiTableClientRecord> data;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetChildrenDataCommand() {
			// default constructor for Jackson
		}

		public SetChildrenDataCommand(String componentId, int parentRecordId, List<UiTableClientRecord> data) {
			this.componentId = componentId;
			this.parentRecordId = parentRecordId;
			this.data = data;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("parentRecordId=" + parentRecordId).append(", ")
					.append(data != null ? "data={" + data.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("parentRecordId")
		public int getParentRecordId() {
			return parentRecordId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("data")
		public List<UiTableClientRecord> getData() {
			return data;
		}

	}

	public static class MarkTableFieldCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int recordId;
		protected String columnPropertyName;
		protected boolean mark;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public MarkTableFieldCommand() {
			// default constructor for Jackson
		}

		public MarkTableFieldCommand(String componentId, int recordId, String columnPropertyName, boolean mark) {
			this.componentId = componentId;
			this.recordId = recordId;
			this.columnPropertyName = columnPropertyName;
			this.mark = mark;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("recordId=" + recordId).append(", ")
					.append("columnPropertyName=" + columnPropertyName).append(", ")
					.append("mark=" + mark)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("recordId")
		public int getRecordId() {
			return recordId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("columnPropertyName")
		public String getColumnPropertyName() {
			return columnPropertyName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mark")
		public boolean getMark() {
			return mark;
		}

	}

	public static class ClearAllFieldMarkingsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ClearAllFieldMarkingsCommand() {
			// default constructor for Jackson
		}

		public ClearAllFieldMarkingsCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class SetRecordBoldCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int recordId;
		protected boolean bold;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetRecordBoldCommand() {
			// default constructor for Jackson
		}

		public SetRecordBoldCommand(String componentId, int recordId, boolean bold) {
			this.componentId = componentId;
			this.recordId = recordId;
			this.bold = bold;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("recordId=" + recordId).append(", ")
					.append("bold=" + bold)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("recordId")
		public int getRecordId() {
			return recordId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("bold")
		public boolean getBold() {
			return bold;
		}

	}

	public static class SelectRowsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<Integer> recordIds;
		protected boolean scrollToFirstRecord;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SelectRowsCommand() {
			// default constructor for Jackson
		}

		public SelectRowsCommand(String componentId, List<Integer> recordIds, boolean scrollToFirstRecord) {
			this.componentId = componentId;
			this.recordIds = recordIds;
			this.scrollToFirstRecord = scrollToFirstRecord;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("recordIds=" + recordIds).append(", ")
					.append("scrollToFirstRecord=" + scrollToFirstRecord)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("recordIds")
		public List<Integer> getRecordIds() {
			return recordIds;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("scrollToFirstRecord")
		public boolean getScrollToFirstRecord() {
			return scrollToFirstRecord;
		}

	}

	public static class EditCellIfAvailableCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int recordId;
		protected String propertyName;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public EditCellIfAvailableCommand() {
			// default constructor for Jackson
		}

		public EditCellIfAvailableCommand(String componentId, int recordId, String propertyName) {
			this.componentId = componentId;
			this.recordId = recordId;
			this.propertyName = propertyName;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("recordId=" + recordId).append(", ")
					.append("propertyName=" + propertyName)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("recordId")
		public int getRecordId() {
			return recordId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("propertyName")
		public String getPropertyName() {
			return propertyName;
		}

	}

	public static class CancelEditingCellCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int recordId;
		protected String propertyName;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public CancelEditingCellCommand() {
			// default constructor for Jackson
		}

		public CancelEditingCellCommand(String componentId, int recordId, String propertyName) {
			this.componentId = componentId;
			this.recordId = recordId;
			this.propertyName = propertyName;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("recordId=" + recordId).append(", ")
					.append("propertyName=" + propertyName)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("recordId")
		public int getRecordId() {
			return recordId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("propertyName")
		public String getPropertyName() {
			return propertyName;
		}

	}

	public static class FocusCellCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int recordId;
		protected String columnPropertyName;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public FocusCellCommand() {
			// default constructor for Jackson
		}

		public FocusCellCommand(String componentId, int recordId, String columnPropertyName) {
			this.componentId = componentId;
			this.recordId = recordId;
			this.columnPropertyName = columnPropertyName;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("recordId=" + recordId).append(", ")
					.append("columnPropertyName=" + columnPropertyName)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("recordId")
		public int getRecordId() {
			return recordId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("columnPropertyName")
		public String getColumnPropertyName() {
			return columnPropertyName;
		}

	}

	public static class SetSingleCellMessagesCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int recordId;
		protected String columnPropertyName;
		protected List<UiFieldMessage> messages;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetSingleCellMessagesCommand() {
			// default constructor for Jackson
		}

		public SetSingleCellMessagesCommand(String componentId, int recordId, String columnPropertyName, List<UiFieldMessage> messages) {
			this.componentId = componentId;
			this.recordId = recordId;
			this.columnPropertyName = columnPropertyName;
			this.messages = messages;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("recordId=" + recordId).append(", ")
					.append("columnPropertyName=" + columnPropertyName).append(", ")
					.append(messages != null ? "messages={" + messages.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("recordId")
		public int getRecordId() {
			return recordId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("columnPropertyName")
		public String getColumnPropertyName() {
			return columnPropertyName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("messages")
		public List<UiFieldMessage> getMessages() {
			return messages;
		}

	}

	public static class ClearAllCellMessagesCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ClearAllCellMessagesCommand() {
			// default constructor for Jackson
		}

		public ClearAllCellMessagesCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class SetColumnMessagesCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String columnPropertyName;
		protected List<UiFieldMessage> messages;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetColumnMessagesCommand() {
			// default constructor for Jackson
		}

		public SetColumnMessagesCommand(String componentId, String columnPropertyName, List<UiFieldMessage> messages) {
			this.componentId = componentId;
			this.columnPropertyName = columnPropertyName;
			this.messages = messages;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("columnPropertyName=" + columnPropertyName).append(", ")
					.append(messages != null ? "messages={" + messages.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("columnPropertyName")
		public String getColumnPropertyName() {
			return columnPropertyName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("messages")
		public List<UiFieldMessage> getMessages() {
			return messages;
		}

	}

	public static class AddColumnsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiTableColumn> column;
		protected int index;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddColumnsCommand() {
			// default constructor for Jackson
		}

		public AddColumnsCommand(String componentId, List<UiTableColumn> column, int index) {
			this.componentId = componentId;
			this.column = column;
			this.index = index;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("index=" + index).append(", ")
					.append(column != null ? "column={" + column.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("column")
		public List<UiTableColumn> getColumn() {
			return column;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("index")
		public int getIndex() {
			return index;
		}

	}

	public static class RemoveColumnsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<String> columnName;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveColumnsCommand() {
			// default constructor for Jackson
		}

		public RemoveColumnsCommand(String componentId, List<String> columnName) {
			this.componentId = componentId;
			this.columnName = columnName;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("columnName=" + columnName)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("columnName")
		public List<String> getColumnName() {
			return columnName;
		}

	}

	public static class SetColumnVisibilityCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String columnPropertyName;
		protected boolean visible;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetColumnVisibilityCommand() {
			// default constructor for Jackson
		}

		public SetColumnVisibilityCommand(String componentId, String columnPropertyName, boolean visible) {
			this.componentId = componentId;
			this.columnPropertyName = columnPropertyName;
			this.visible = visible;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("columnPropertyName=" + columnPropertyName).append(", ")
					.append("visible=" + visible)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("columnPropertyName")
		public String getColumnPropertyName() {
			return columnPropertyName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("visible")
		public boolean getVisible() {
			return visible;
		}

	}




}